/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SyntaxTreeNameFinder
extends BaseTreeVisitor {
    private String name;

    public static String getName(Tree syntaxNode) {
        SyntaxTreeNameFinder finder = new SyntaxTreeNameFinder();
        syntaxNode.accept(finder);
        return finder.getName();
    }

    private String getName() {
        return this.name;
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        this.name = tree.name();
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        String identifierName;
        ExpressionTree expression = ExpressionUtils.skipParentheses(tree.expression());
        if (expression.is(Tree.Kind.IDENTIFIER) && ("this".equals(identifierName = ((IdentifierTree)expression).name()) || "super".equals(identifierName))) {
            tree.identifier().accept(this);
            return;
        }
        expression.accept(this);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        tree.expression().accept(this);
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        tree.expression().accept(this);
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        tree.expression().accept(this);
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            this.name = ((MemberSelectExpressionTree)methodSelect).identifier().name();
        } else {
            methodSelect.accept(this);
        }
    }

    @Override
    public void visitVariable(VariableTree tree) {
        if (tree.initializer() == null) {
            this.name = tree.simpleName().name();
        } else {
            super.visitVariable(tree);
        }
    }
}

