/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.bytecode.loader.SquidClassLoader;

public final class ClassLoaderBuilder {
    private static final Logger LOG = Loggers.get(ClassLoaderBuilder.class);

    private ClassLoaderBuilder() {
    }

    public static SquidClassLoader create(Collection<File> bytecodeFilesOrDirectories) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : bytecodeFilesOrDirectories) {
            if (file.isFile() && file.getPath().endsWith(".class")) {
                LOG.info("SonarQube Squid ClassLoader was expecting a JAR file instead of CLASS file : '" + file.getAbsolutePath() + "'");
                continue;
            }
            files.add(file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("----- Classpath analyzed by Squid:");
            for (File file : files) {
                LOG.debug(file.getAbsolutePath());
            }
            LOG.debug("-----");
        }
        try {
            return new SquidClassLoader(files);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create ClassLoader", e);
        }
    }
}

