/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.cfg;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.objectweb.asm.util.Printer;
import org.sonar.java.bytecode.cfg.Instruction;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.Sema;
import org.sonar.plugins.java.api.semantic.Type;

public class BytecodeCFG {
    List<Block> blocks = new ArrayList<Block>();
    private final Block exitBlock = new Block(this);

    BytecodeCFG() {
        this.exitBlock.successors = Collections.emptyList();
        this.blocks.add(this.exitBlock);
    }

    public CFG.IBlock<Instruction> entry() {
        return this.blocks.get(1);
    }

    public List<Block> blocks() {
        return this.blocks;
    }

    public Block exitBlock() {
        return this.exitBlock;
    }

    public static class Block
    implements CFG.IBlock<Instruction> {
        int id;
        BytecodeCFG cfg;
        List<Instruction> instructions;
        List<Block> successors;
        String exceptionType;
        Instruction terminator;
        private Block trueBlock;
        Block falseBlock;

        Block(BytecodeCFG cfg) {
            this.cfg = cfg;
            this.id = cfg.blocks.size();
            this.instructions = new ArrayList<Instruction>();
            this.successors = new ArrayList<Block>();
        }

        public boolean isCatchBlock() {
            return this.exceptionType != null;
        }

        public Type getExceptionType(Sema semanticModel) {
            Preconditions.checkState((boolean)this.isCatchBlock(), (String)"Block %s is not a catch block", (int)this.id);
            return semanticModel.getClassType(this.exceptionType);
        }

        public boolean isUncaughtException() {
            return this.isCatchBlock() && this.exceptionType.charAt(0) == '!';
        }

        void addInsn(Instruction insn) {
            this.instructions.add(insn);
        }

        void addInsn(int opcode) {
            this.instructions.add(new Instruction(opcode));
        }

        void addInsn(int opcode, int operand) {
            this.instructions.add(new Instruction(opcode, operand));
        }

        void addInsn(int opcode, String className) {
            this.instructions.add(new Instruction(opcode, className));
        }

        void addInsn(int opcode, Instruction.FieldOrMethod fieldOrMethod) {
            this.instructions.add(new Instruction(opcode, fieldOrMethod));
        }

        Block createSuccessor() {
            Block newBlock = new Block(this.cfg);
            this.successors.add(newBlock);
            this.cfg.blocks.add(newBlock);
            return newBlock;
        }

        public Block trueSuccessor() {
            return this.trueBlock;
        }

        public Block falseSuccessor() {
            return this.falseBlock;
        }

        public String printBlock() {
            StringBuilder sb = new StringBuilder();
            sb.append("B").append(this.id);
            if (this.id == 0) {
                sb.append("(Exit)\n");
                return sb.toString();
            }
            sb.append("\n");
            int index = 0;
            for (Instruction instruction : this.instructions) {
                sb.append(index).append(": ").append(Printer.OPCODES[instruction.opcode]).append("\n");
                ++index;
            }
            if (this.terminator != null) {
                sb.append(Printer.OPCODES[this.terminator.opcode]).append(" ");
            }
            sb.append("Jumps to: ");
            this.successors().stream().sorted(Comparator.comparingInt(s -> s.id)).forEachOrdered(s -> {
                sb.append("B").append(s.id);
                if (s == this.trueBlock) {
                    sb.append("(true)");
                }
                if (s == this.falseBlock) {
                    sb.append("(false)");
                }
                if (s.isCatchBlock()) {
                    sb.append("(Exception:").append(s.exceptionType).append(")");
                }
                sb.append(" ");
            });
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public List<Instruction> elements() {
            return this.instructions;
        }

        @Override
        @CheckForNull
        public Instruction terminator() {
            return this.terminator;
        }

        @Override
        public Set<Block> successors() {
            return new HashSet<Block>(this.successors);
        }

        void setTrueBlock(Block trueBlock) {
            this.trueBlock = trueBlock;
            if (!this.successors.contains(trueBlock)) {
                this.successors.add(trueBlock);
            }
        }
    }
}

