/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Sema;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

public class DefaultJavaFileScannerContext
implements JavaFileScannerContext {
    private final JavaTree.CompilationUnitTreeImpl tree;
    private final boolean semanticEnabled;
    private final SonarComponents sonarComponents;
    private final ComplexityVisitor complexityVisitor;
    private final InputFile inputFile;
    private final JavaVersion javaVersion;
    private final boolean fileParsed;

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed) {
        this.tree = (JavaTree.CompilationUnitTreeImpl)tree;
        this.inputFile = inputFile;
        this.semanticEnabled = semanticModel != null;
        this.sonarComponents = sonarComponents;
        this.complexityVisitor = new ComplexityVisitor();
        this.javaVersion = javaVersion;
        this.fileParsed = fileParsed;
    }

    @Override
    public CompilationUnitTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssueOnFile(JavaCheck javaCheck, String message) {
        this.addIssue(-1, javaCheck, message);
    }

    @Override
    public void addIssueOnProject(JavaCheck check, String message) {
        this.sonarComponents.addIssue(this.getProject(), check, -1, message, 0);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message) {
        this.addIssue(line, javaCheck, message, null);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
        this.sonarComponents.addIssue((InputComponent)this.inputFile, javaCheck, line, message, cost);
    }

    @Override
    @Nullable
    public Object getSemanticModel() {
        if (!this.semanticEnabled) {
            return null;
        }
        return this.tree.sema;
    }

    @Override
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean fileParsed() {
        return this.fileParsed;
    }

    @Override
    @Deprecated
    public String getFileKey() {
        return this.inputFile.file().getAbsolutePath();
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        this.reportIssue(javaCheck, tree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssueWithFlow(javaCheck, syntaxNode, message, flows, cost);
    }

    @Override
    public void reportIssueWithFlow(JavaCheck javaCheck, Tree syntaxNode, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, syntaxNode, null, message, flows, cost));
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        this.reportIssue(javaCheck, startTree, endTree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, endTree, message, flows, cost));
    }

    @Override
    public List<String> getFileLines() {
        return this.sonarComponents.fileLines(this.inputFile);
    }

    @Override
    public String getFileContent() {
        return this.sonarComponents.inputFileContents(this.inputFile);
    }

    public void reportIssue(AnalyzerMessage message) {
        this.sonarComponents.reportIssue(message);
    }

    public AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, String message) {
        return DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, null, message, new ArrayList<List<JavaFileScannerContext.Location>>(), null);
    }

    protected static AnalyzerMessage createAnalyzerMessage(InputFile inputFile, JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        AnalyzerMessage.TextSpan textSpan = endTree != null ? AnalyzerMessage.textSpanBetween(startTree, endTree) : AnalyzerMessage.textSpanFor(startTree);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, (InputComponent)inputFile, textSpan, message, cost != null ? cost : 0);
        for (List<JavaFileScannerContext.Location> flow : flows) {
            List sonarqubeFlow = flow.stream().map(l -> new AnalyzerMessage(javaCheck, (InputComponent)inputFile, AnalyzerMessage.textSpanFor(l.syntaxNode), l.msg, 0)).collect(Collectors.toList());
            analyzerMessage.flows.add(sonarqubeFlow);
        }
        return analyzerMessage;
    }

    @Override
    public InputFile getInputFile() {
        return this.inputFile;
    }

    @Override
    public InputComponent getProject() {
        return this.sonarComponents.project();
    }

    @Override
    public File getWorkingDirectory() {
        return this.sonarComponents.workDir();
    }

    public File getBaseDirectory() {
        return this.sonarComponents.baseDir();
    }

    @Override
    public List<Tree> getComplexityNodes(Tree tree) {
        return this.complexityVisitor.getNodes(tree);
    }

    private static void throwIfEndOfAnalysisCheck(JavaCheck javaCheck) {
        if (javaCheck instanceof EndOfAnalysisCheck) {
            throw new UnsupportedOperationException("EndOfAnalysisCheck must only call reportIssue with AnalyzerMessage and must never pass a Tree reference.");
        }
    }
}

