/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import javax.annotation.CheckForNull;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static boolean isSimpleAssignment(AssignmentExpressionTree tree) {
        if (!tree.is(Tree.Kind.ASSIGNMENT)) {
            return false;
        }
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.IDENTIFIER) || ExpressionUtils.isSelectOnThisOrSuper(tree);
    }

    public static boolean isSelectOnThisOrSuper(AssignmentExpressionTree tree) {
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        return variable.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)variable);
    }

    public static boolean isSelectOnThisOrSuper(MemberSelectExpressionTree tree) {
        if (!tree.expression().is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        String selectSourceName = ((IdentifierTree)tree.expression()).name();
        return "this".equalsIgnoreCase(selectSourceName) || "super".equalsIgnoreCase(selectSourceName);
    }

    public static IdentifierTree extractIdentifier(AssignmentExpressionTree tree) {
        MemberSelectExpressionTree selectTree;
        ExpressionTree variable = ExpressionUtils.skipParentheses(tree.variable());
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)variable;
        }
        if (variable.is(Tree.Kind.MEMBER_SELECT) && ExpressionUtils.isSelectOnThisOrSuper(selectTree = (MemberSelectExpressionTree)variable)) {
            return selectTree.identifier();
        }
        throw new IllegalArgumentException("Can not extract identifier.");
    }

    public static ExpressionTree skipParentheses(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    public static boolean isNullLiteral(ExpressionTree tree) {
        return ExpressionUtils.skipParentheses(tree).is(Tree.Kind.NULL_LITERAL);
    }

    public static boolean isSecuringByte(ExpressionTree expression) {
        if (expression.is(Tree.Kind.AND)) {
            BinaryExpressionTree and = (BinaryExpressionTree)expression;
            return LiteralUtils.is0xff(and.rightOperand()) || LiteralUtils.is0xff(and.leftOperand());
        }
        return false;
    }

    public static IdentifierTree methodName(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        IdentifierTree id = methodSelect.is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)methodSelect : ((MemberSelectExpressionTree)methodSelect).identifier();
        return id;
    }

    @CheckForNull
    public static MethodTree getEnclosingMethod(ExpressionTree expr) {
        Tree result;
        for (result = expr.parent(); result != null && !result.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR); result = result.parent()) {
        }
        return (MethodTree)result;
    }

    public static boolean isThis(ExpressionTree expression) {
        ExpressionTree newExpression = ExpressionUtils.skipParentheses(expression);
        return newExpression.is(Tree.Kind.IDENTIFIER) && "this".equals(((IdentifierTree)newExpression).name());
    }

    @CheckForNull
    public static Object resolveAsConstant(ExpressionTree tree) {
        ExpressionTree expression = tree;
        while (expression.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            expression = ((ParenthesizedTree)expression).expression();
        }
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            expression = ((MemberSelectExpressionTree)expression).identifier();
        }
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            return ExpressionUtils.resolveIdentifier((IdentifierTree)expression);
        }
        if (expression.is(Tree.Kind.BOOLEAN_LITERAL)) {
            return Boolean.parseBoolean(((LiteralTree)expression).value());
        }
        if (expression.is(Tree.Kind.STRING_LITERAL)) {
            return LiteralUtils.trimQuotes(((LiteralTree)expression).value());
        }
        if (tree.is(Tree.Kind.INT_LITERAL, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            return LiteralUtils.intLiteralValue(tree);
        }
        if (tree.is(Tree.Kind.LONG_LITERAL)) {
            return LiteralUtils.longLiteralValue(tree);
        }
        if (expression.is(Tree.Kind.PLUS)) {
            return ExpressionUtils.resolvePlus((BinaryExpressionTree)expression);
        }
        return null;
    }

    @CheckForNull
    private static Object resolveIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (!symbol.isVariableSymbol()) {
            return null;
        }
        Symbol owner = symbol.owner();
        if (owner.isTypeSymbol() && owner.type().is("java.lang.Boolean")) {
            if ("TRUE".equals(symbol.name())) {
                return Boolean.TRUE;
            }
            if ("FALSE".equals(symbol.name())) {
                return Boolean.FALSE;
            }
        }
        return JUtils.constantValue((Symbol.VariableSymbol)symbol).orElse(null);
    }

    @CheckForNull
    private static Object resolvePlus(BinaryExpressionTree binaryExpression) {
        Object left = ExpressionUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = ExpressionUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String) {
            return (String)left + right;
        }
        if (right instanceof String) {
            return left + (String)right;
        }
        if (left instanceof Long && right instanceof Long) {
            return (Long)left + (Long)right;
        }
        if (left instanceof Long && right instanceof Integer) {
            return (Long)left + (long)((Integer)right).intValue();
        }
        if (left instanceof Integer && right instanceof Long) {
            return (long)((Integer)left).intValue() + (Long)right;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left + (Integer)right;
        }
        return null;
    }
}

