/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;

final class JMethodSymbol
extends JSymbol
implements Symbol.MethodSymbol {
    JMethodSymbol(JSema sema, IMethodBinding methodBinding) {
        super(sema, (IBinding)methodBinding);
    }

    IMethodBinding methodBinding() {
        return (IMethodBinding)this.binding;
    }

    @Override
    public List<Type> parameterTypes() {
        return Arrays.stream(this.methodBinding().getParameterTypes()).map(this.sema::type).collect(Collectors.toList());
    }

    @Override
    public Symbol.TypeSymbol returnType() {
        return this.sema.typeSymbol(this.methodBinding().getReturnType());
    }

    @Override
    public List<Type> thrownTypes() {
        return Arrays.stream(this.methodBinding().getExceptionTypes()).map(this.sema::type).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Symbol.MethodSymbol overriddenSymbol() {
        IMethodBinding overrides = this.find(arg_0 -> ((IMethodBinding)this.methodBinding()).overrides(arg_0), this.methodBinding().getDeclaringClass());
        if (overrides == null) {
            return null;
        }
        return this.sema.methodSymbol(overrides);
    }

    @Nullable
    private IMethodBinding find(Predicate<IMethodBinding> predicate, ITypeBinding t) {
        for (IMethodBinding iMethodBinding : t.getDeclaredMethods()) {
            if (!predicate.test(iMethodBinding)) continue;
            return iMethodBinding;
        }
        for (IMethodBinding iMethodBinding : t.getInterfaces()) {
            IMethodBinding r = this.find(predicate, (ITypeBinding)iMethodBinding);
            if (r == null) continue;
            return r;
        }
        if (t.getSuperclass() != null) {
            return this.find(predicate, t.getSuperclass());
        }
        ITypeBinding objectTypeBinding = Objects.requireNonNull(this.sema.resolveType("java.lang.Object"));
        if (t != objectTypeBinding) {
            return this.find(predicate, objectTypeBinding);
        }
        return null;
    }

    @Override
    public String signature() {
        return this.methodBinding().getDeclaringClass().getBinaryName() + "#" + this.name() + JSema.signature(this.methodBinding().getMethodDeclaration());
    }

    @Override
    @Nullable
    public MethodTree declaration() {
        return (MethodTree)super.declaration();
    }
}

