/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.sonar.java.model.JMethodSymbol;
import org.sonar.java.model.JPackageSymbol;
import org.sonar.java.model.JSymbol;
import org.sonar.java.model.JSymbolMetadata;
import org.sonar.java.model.JType;
import org.sonar.java.model.JTypeSymbol;
import org.sonar.java.model.JVariableSymbol;
import org.sonar.java.model.Sema;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class JSema
implements Sema {
    private final AST ast;
    final Map<IBinding, Tree> declarations = new HashMap<IBinding, Tree>();
    final Map<IBinding, List<IdentifierTree>> usages = new HashMap<IBinding, List<IdentifierTree>>();
    private final Map<ITypeBinding, JType> types = new HashMap<ITypeBinding, JType>();
    private final Map<IBinding, JSymbol> symbols = new HashMap<IBinding, JSymbol>();
    private final Map<IAnnotationBinding, JSymbolMetadata.JAnnotationInstance> annotations = new HashMap<IAnnotationBinding, JSymbolMetadata.JAnnotationInstance>();

    JSema(AST ast) {
        this.ast = ast;
    }

    public JType type(ITypeBinding typeBinding) {
        typeBinding = JType.normalize(typeBinding);
        return this.types.computeIfAbsent(typeBinding, k -> new JType(this, (ITypeBinding)k));
    }

    public JPackageSymbol packageSymbol(IPackageBinding packageBinding) {
        return (JPackageSymbol)this.symbols.computeIfAbsent((IBinding)packageBinding, k -> new JPackageSymbol(this, (IPackageBinding)k));
    }

    public JTypeSymbol typeSymbol(ITypeBinding typeBinding) {
        typeBinding = JType.normalize(typeBinding);
        return (JTypeSymbol)this.symbols.computeIfAbsent((IBinding)typeBinding, k -> new JTypeSymbol(this, (ITypeBinding)k));
    }

    public JMethodSymbol methodSymbol(IMethodBinding methodBinding) {
        return (JMethodSymbol)this.symbols.computeIfAbsent((IBinding)methodBinding, k -> new JMethodSymbol(this, (IMethodBinding)k));
    }

    public JVariableSymbol variableSymbol(IVariableBinding variableBinding) {
        return (JVariableSymbol)this.symbols.computeIfAbsent((IBinding)variableBinding, k -> new JVariableSymbol(this, (IVariableBinding)k));
    }

    JSymbolMetadata.JAnnotationInstance annotation(IAnnotationBinding annotationBinding) {
        return this.annotations.computeIfAbsent(annotationBinding, k -> new JSymbolMetadata.JAnnotationInstance(this, (IAnnotationBinding)k));
    }

    static IBinding declarationBinding(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
        }
        return binding;
    }

    @Override
    public Type getClassType(String fullyQualifiedName) {
        ITypeBinding typeBinding = this.resolveType(fullyQualifiedName);
        return typeBinding != null ? this.type(typeBinding) : Symbols.unknownType;
    }

    @Nullable
    ITypeBinding resolveType(String name) {
        int dimensions = 0;
        int end = name.length() - 1;
        while (name.charAt(end) == ']') {
            end -= 2;
            ++dimensions;
        }
        ITypeBinding typeBinding = this.ast.resolveWellKnownType(name = name.substring(0, end + 1));
        if (typeBinding == null && (typeBinding = ASTUtils.resolveType(this.ast, name)) == null) {
            return null;
        }
        return dimensions == 0 ? typeBinding : typeBinding.createArrayType(dimensions);
    }

    IAnnotationBinding[] resolvePackageAnnotations(String packageName) {
        try {
            Method methodGetBindingResolver = this.ast.getClass().getDeclaredMethod("getBindingResolver", new Class[0]);
            methodGetBindingResolver.setAccessible(true);
            Object bindingResolver = methodGetBindingResolver.invoke((Object)this.ast, new Object[0]);
            Method methodLookupEnvironment = bindingResolver.getClass().getDeclaredMethod("lookupEnvironment", new Class[0]);
            methodLookupEnvironment.setAccessible(true);
            LookupEnvironment lookupEnvironment = (LookupEnvironment)methodLookupEnvironment.invoke(bindingResolver, new Object[0]);
            NameEnvironmentAnswer answer = lookupEnvironment.nameEnvironment.findType(TypeConstants.PACKAGE_INFO_NAME, CharOperation.splitOn((char)'.', (char[])packageName.toCharArray()));
            if (answer == null) {
                return new IAnnotationBinding[0];
            }
            IBinaryType type = answer.getBinaryType();
            if (type == null) {
                return new IAnnotationBinding[0];
            }
            IBinaryAnnotation[] binaryAnnotations = type.getAnnotations();
            AnnotationBinding[] binaryInstances = BinaryTypeBinding.createAnnotations((IBinaryAnnotation[])binaryAnnotations, (LookupEnvironment)lookupEnvironment, (char[][][])type.getMissingTypeNames());
            AnnotationBinding[] allInstances = AnnotationBinding.addStandardAnnotations((AnnotationBinding[])binaryInstances, (long)type.getTagBits(), (LookupEnvironment)lookupEnvironment);
            Method methodGetAnnotationInstance = bindingResolver.getClass().getDeclaredMethod("getAnnotationInstance", AnnotationBinding.class);
            methodGetAnnotationInstance.setAccessible(true);
            IAnnotationBinding[] domInstances = new IAnnotationBinding[allInstances.length];
            for (int i = 0; i < allInstances.length; ++i) {
                domInstances[i] = (IAnnotationBinding)methodGetAnnotationInstance.invoke(bindingResolver, allInstances[i]);
            }
            return domInstances;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static String signature(IMethodBinding methodBinding) {
        try {
            Field fieldBinding = Class.forName("org.eclipse.jdt.core.dom.MethodBinding").getDeclaredField("binding");
            fieldBinding.setAccessible(true);
            Method methodSignature = MethodBinding.class.getMethod("signature", new Class[0]);
            methodSignature.setAccessible(true);
            char[] signature = (char[])methodSignature.invoke(fieldBinding.get(methodBinding), new Object[0]);
            return new String(signature);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

