/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.model.JSema;
import org.sonar.java.resolve.AnnotationValueResolve;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;

final class JSymbolMetadata
implements SymbolMetadata {
    private final JSema sema;
    private final IAnnotationBinding[] annotationBindings;

    JSymbolMetadata(JSema sema, IAnnotationBinding[] annotationBindings) {
        this.sema = Objects.requireNonNull(sema);
        this.annotationBindings = annotationBindings;
    }

    JSymbolMetadata(JSema sema, IAnnotationBinding[] typeAnnotationBindings, IAnnotationBinding[] annotationBindings) {
        this.sema = Objects.requireNonNull(sema);
        this.annotationBindings = new IAnnotationBinding[typeAnnotationBindings.length + annotationBindings.length];
        System.arraycopy(typeAnnotationBindings, 0, this.annotationBindings, 0, typeAnnotationBindings.length);
        System.arraycopy(annotationBindings, 0, this.annotationBindings, typeAnnotationBindings.length, annotationBindings.length);
    }

    @Override
    public List<SymbolMetadata.AnnotationInstance> annotations() {
        return Arrays.stream(this.annotationBindings).map(this.sema::annotation).collect(Collectors.toList());
    }

    @Override
    public final boolean isAnnotatedWith(String fullyQualifiedName) {
        for (SymbolMetadata.AnnotationInstance a : this.annotations()) {
            if (!a.symbol().type().is(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public final List<SymbolMetadata.AnnotationValue> valuesForAnnotation(String fullyQualifiedNameOfAnnotation) {
        for (SymbolMetadata.AnnotationInstance a : this.annotations()) {
            if (!a.symbol().type().is(fullyQualifiedNameOfAnnotation)) continue;
            return a.values();
        }
        return null;
    }

    static final class JAnnotationInstance
    implements SymbolMetadata.AnnotationInstance {
        private final JSema sema;
        private final IAnnotationBinding annotationBinding;

        JAnnotationInstance(JSema sema, IAnnotationBinding annotationBinding) {
            this.sema = sema;
            this.annotationBinding = annotationBinding;
        }

        @Override
        public Symbol symbol() {
            return this.sema.typeSymbol(this.annotationBinding.getAnnotationType());
        }

        @Override
        public List<SymbolMetadata.AnnotationValue> values() {
            ArrayList<SymbolMetadata.AnnotationValue> r = new ArrayList<SymbolMetadata.AnnotationValue>();
            for (IMemberValuePairBinding pair : this.annotationBinding.getDeclaredMemberValuePairs()) {
                r.add(new AnnotationValueResolve(pair.getName(), this.convertAnnotationValue(pair.getValue())));
            }
            return r;
        }

        private Object convertAnnotationValue(Object value) {
            if (value instanceof IVariableBinding) {
                return this.sema.variableSymbol((IVariableBinding)value);
            }
            if (value instanceof ITypeBinding) {
                return this.sema.typeSymbol((ITypeBinding)value);
            }
            if (value instanceof IAnnotationBinding) {
                return this.sema.annotation((IAnnotationBinding)value);
            }
            if (value instanceof Object[]) {
                Object[] a = (Object[])value;
                Object[] result = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    result[i] = this.convertAnnotationValue(a[i]);
                }
                return result;
            }
            return value;
        }
    }
}

