/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;

public class TypeParameterTreeImpl
extends JavaTree
implements TypeParameterTree {
    private IdentifierTreeImpl identifier;
    @Nullable
    private final SyntaxToken extendsToken;
    private final BoundListTreeImpl bounds;
    @Nullable
    ITypeBinding typeBinding;

    public TypeParameterTreeImpl(IdentifierTreeImpl identifier) {
        super(Tree.Kind.TYPE_PARAMETER);
        this.identifier = identifier;
        this.extendsToken = null;
        this.bounds = BoundListTreeImpl.emptyList();
    }

    public TypeParameterTreeImpl(InternalSyntaxToken extendsToken, BoundListTreeImpl bounds) {
        super(Tree.Kind.TYPE_PARAMETER);
        this.extendsToken = extendsToken;
        this.bounds = bounds;
    }

    public TypeParameterTreeImpl complete(IdentifierTreeImpl identifier) {
        Preconditions.checkState((this.identifier == null ? 1 : 0) != 0);
        this.identifier = identifier;
        return this;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParameter(this);
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public SyntaxToken extendToken() {
        return this.extendsToken;
    }

    @Override
    public ListTree<Tree> bounds() {
        return this.bounds;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TYPE_PARAMETER;
    }

    @Override
    public Iterable<Tree> children() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)this.identifier);
        if (this.extendsToken != null) {
            builder.add((Object)this.extendsToken);
            builder.add((Object)this.bounds);
        }
        return builder.build();
    }

    public Symbol symbol() {
        return this.typeBinding != null ? this.root.sema.typeSymbol(this.typeBinding) : Symbols.unknownSymbol;
    }
}

