/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Lists;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ArrayAccessExpressionTreeImpl
extends AssessableExpressionTree
implements ArrayAccessExpressionTree {
    private ExpressionTree expression;
    private final ArrayDimensionTree dimension;

    public ArrayAccessExpressionTreeImpl(ArrayDimensionTree dimension) {
        super(Tree.Kind.ARRAY_ACCESS_EXPRESSION);
        this.dimension = dimension;
    }

    public ArrayAccessExpressionTreeImpl complete(ExpressionTree expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.ARRAY_ACCESS_EXPRESSION;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayAccessExpression(this);
    }

    @Override
    public ArrayDimensionTree dimension() {
        return this.dimension;
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.expression, this.dimension});
    }
}

