/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Lists;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ConditionalExpressionTreeImpl
extends AssessableExpressionTree
implements ConditionalExpressionTree {
    private ExpressionTree condition;
    private final InternalSyntaxToken queryToken;
    private final ExpressionTree trueExpression;
    private final InternalSyntaxToken colonToken;
    private final ExpressionTree falseExpression;

    public ConditionalExpressionTreeImpl(InternalSyntaxToken queryToken, ExpressionTree trueExpression, InternalSyntaxToken colonToken, ExpressionTree falseExpression) {
        super(Tree.Kind.CONDITIONAL_EXPRESSION);
        this.queryToken = queryToken;
        this.trueExpression = trueExpression;
        this.colonToken = colonToken;
        this.falseExpression = falseExpression;
    }

    public ConditionalExpressionTreeImpl complete(ExpressionTree condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.CONDITIONAL_EXPRESSION;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken questionToken() {
        return this.queryToken;
    }

    @Override
    public ExpressionTree trueExpression() {
        return this.trueExpression;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public ExpressionTree falseExpression() {
        return this.falseExpression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.condition, this.queryToken, this.trueExpression, this.colonToken, this.falseExpression});
    }
}

