/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationStateTable;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;

public class RelationalSymbolicValue
extends BinarySymbolicValue {
    private static final int MAX_ITERATIONS = 10000;
    private static final int MAX_DEDUCED_RELATIONS = 100000;
    final Kind kind;

    public RelationalSymbolicValue(Kind kind) {
        this.kind = kind;
    }

    @VisibleForTesting
    RelationalSymbolicValue(Kind kind, SymbolicValue leftOp, SymbolicValue rightOp) {
        this.kind = kind;
        this.leftOp = leftOp;
        this.rightOp = rightOp;
    }

    @Override
    public List<ProgramState> setConstraint(ProgramState initialProgramState, BooleanConstraint booleanConstraint) {
        return this.setConstraint(initialProgramState, booleanConstraint, new HashSet<RelationalSymbolicValue>(initialProgramState.knownRelations()));
    }

    @Override
    protected List<ProgramState> setConstraint(ProgramState initialProgramState, Constraint constraint, Set<RelationalSymbolicValue> knownRelations) {
        if (constraint == BooleanConstraint.FALSE) {
            return this.inverse().setConstraint(initialProgramState, BooleanConstraint.TRUE, knownRelations);
        }
        if (constraint != BooleanConstraint.TRUE) {
            return this.setConstraint(initialProgramState, constraint);
        }
        if (knownRelations.contains(this)) {
            return Collections.singletonList(initialProgramState);
        }
        HashSet<RelationalSymbolicValue> newRelations = new HashSet<RelationalSymbolicValue>();
        newRelations.add(this);
        newRelations.addAll(this.transitiveRelations(knownRelations));
        boolean unfulfilled = newRelations.stream().map(r -> r.resolveRelationState(knownRelations)).anyMatch(RelationState.UNFULFILLED::equals);
        if (unfulfilled) {
            return Collections.emptyList();
        }
        knownRelations.add(this);
        return RelationalSymbolicValue.getNewProgramStates(initialProgramState, newRelations, knownRelations);
    }

    private static List<ProgramState> getNewProgramStates(ProgramState initialProgramState, Set<RelationalSymbolicValue> newRelations, Set<RelationalSymbolicValue> knownRelations) {
        ArrayList<ProgramState> programStates = new ArrayList<ProgramState>();
        programStates.add(initialProgramState);
        for (RelationalSymbolicValue relationalSymbolicValue : newRelations) {
            ArrayList<ProgramState> intermediateStates = new ArrayList<ProgramState>();
            for (ProgramState programState : programStates) {
                intermediateStates.addAll(relationalSymbolicValue.copyAllConstraints(programState, knownRelations));
            }
            programStates = intermediateStates;
        }
        return programStates;
    }

    RelationalSymbolicValue inverse() {
        return new RelationalSymbolicValue(this.kind.inverse(), this.leftOp, this.rightOp);
    }

    private List<ProgramState> copyAllConstraints(ProgramState initialState, Set<RelationalSymbolicValue> knownRelations) {
        ProgramState programState = initialState;
        if (programState.canReach(this.leftOp) || programState.canReach(this.rightOp)) {
            programState = programState.addConstraint(this, BooleanConstraint.TRUE);
        }
        ArrayList<ProgramState> results = new ArrayList<ProgramState>();
        List<ProgramState> copiedConstraints = this.copyConstraintFromTo(this.leftOp, this.rightOp, programState, knownRelations);
        if (Kind.METHOD_EQUALS == this.kind || Kind.NOT_METHOD_EQUALS == this.kind) {
            copiedConstraints = this.addNullConstraintsForBooleanWrapper(programState, copiedConstraints);
        }
        for (ProgramState ps : copiedConstraints) {
            List<ProgramState> copiedConstraintsRightToLeft = this.copyConstraintFromTo(this.rightOp, this.leftOp, ps, knownRelations);
            if (copiedConstraintsRightToLeft.size() == 1 && copiedConstraintsRightToLeft.get(0).equals(programState)) {
                results.add(programState.addConstraint(this, BooleanConstraint.TRUE));
                continue;
            }
            results.addAll(copiedConstraintsRightToLeft);
        }
        return results;
    }

    private List<ProgramState> addNullConstraintsForBooleanWrapper(ProgramState initialProgramState, List<ProgramState> copiedConstraints) {
        BooleanConstraint leftConstraint = initialProgramState.getConstraint(this.leftOp, BooleanConstraint.class);
        BooleanConstraint rightConstraint = initialProgramState.getConstraint(this.rightOp, BooleanConstraint.class);
        if (leftConstraint != null && rightConstraint == null && !this.isEquality()) {
            List nullConstraints = copiedConstraints.stream().flatMap(ps -> this.rightOp.setConstraint((ProgramState)ps, ObjectConstraint.NULL).stream()).map(ps -> ps.removeConstraintsOnDomain(this.rightOp, BooleanConstraint.class)).collect(Collectors.toList());
            return ImmutableList.builder().addAll(copiedConstraints).addAll(nullConstraints).build();
        }
        return copiedConstraints;
    }

    private List<ProgramState> copyConstraintFromTo(SymbolicValue from, SymbolicValue to, ProgramState programState, Set<RelationalSymbolicValue> knownRelations) {
        ArrayList<ProgramState> states = new ArrayList<ProgramState>();
        states.add(programState);
        ConstraintsByDomain leftConstraints = programState.getConstraints(from);
        if (leftConstraints == null) {
            return states;
        }
        leftConstraints.forEach((d, c) -> {
            Constraint constraint = c.copyOver(this.kind);
            if (constraint != null) {
                List<ProgramState> newStates = RelationalSymbolicValue.applyConstraint(constraint, to, states, knownRelations);
                states.clear();
                states.addAll(newStates);
            }
        });
        return states;
    }

    private static List<ProgramState> applyConstraint(Constraint constraint, SymbolicValue to, List<ProgramState> states, Set<RelationalSymbolicValue> knownRelations) {
        ArrayList<ProgramState> newStates = new ArrayList<ProgramState>();
        states.forEach(state -> newStates.addAll(to.setConstraint((ProgramState)state, constraint, knownRelations)));
        return newStates;
    }

    @VisibleForTesting
    RelationState resolveRelationState(Set<RelationalSymbolicValue> knownRelations) {
        if (this.hasSameOperand()) {
            return this.relationStateForSameOperand();
        }
        return knownRelations.stream().map(r -> r.implies(this)).filter(RelationState::isDetermined).findAny().orElse(RelationState.UNDETERMINED);
    }

    private RelationState relationStateForSameOperand() {
        switch (this.kind) {
            case EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case METHOD_EQUALS: {
                return RelationState.FULFILLED;
            }
            case NOT_EQUAL: 
            case LESS_THAN: 
            case NOT_METHOD_EQUALS: {
                return RelationState.UNFULFILLED;
            }
        }
        throw new IllegalStateException("Unknown resolution for same operand " + this);
    }

    private RelationState implies(RelationalSymbolicValue relation) {
        if (this.equals(relation)) {
            return RelationState.FULFILLED;
        }
        if (this.inverse().equals(relation)) {
            return RelationState.UNFULFILLED;
        }
        if (this.hasSameOperandsAs(relation)) {
            return RelationStateTable.solveRelation(this.kind, relation.kind);
        }
        return RelationState.UNDETERMINED;
    }

    @VisibleForTesting
    Set<RelationalSymbolicValue> transitiveRelations(Set<RelationalSymbolicValue> knownRelations) {
        HashSet<RelationalSymbolicValue> newRelations = new HashSet<RelationalSymbolicValue>();
        ArrayDeque<RelationalSymbolicValue> workList = new ArrayDeque<RelationalSymbolicValue>();
        int iterations = 0;
        workList.add(this);
        while (!workList.isEmpty()) {
            int relationSize = newRelations.size() * knownRelations.size();
            if (relationSize > 100000 || iterations > 10000) {
                throw new TransitiveRelationExceededException("Used relations: " + relationSize + ". Iterations " + iterations);
            }
            ++iterations;
            RelationalSymbolicValue relation = (RelationalSymbolicValue)workList.pop();
            for (RelationalSymbolicValue knownRelation : knownRelations) {
                RelationalSymbolicValue r = relation.deduceTransitiveOrSimplified(knownRelation);
                if (r == null || knownRelations.contains(r) || !newRelations.add(r)) continue;
                workList.add(r);
            }
        }
        return newRelations;
    }

    @VisibleForTesting
    RelationalSymbolicValue deduceTransitiveOrSimplified(RelationalSymbolicValue other) {
        RelationalSymbolicValue result = this.simplify(other);
        if (result != null) {
            return result;
        }
        return this.combineTransitively(other);
    }

    @CheckForNull
    private RelationalSymbolicValue simplify(RelationalSymbolicValue other) {
        if (this.kind == Kind.GREATER_THAN_OR_EQUAL && other.kind == Kind.GREATER_THAN_OR_EQUAL && this.hasSameOperandsAs(other) && !this.equals(other)) {
            return new RelationalSymbolicValue(Kind.EQUAL, this.leftOp, this.rightOp);
        }
        return null;
    }

    @VisibleForTesting
    boolean potentiallyTransitiveWith(RelationalSymbolicValue other) {
        if (this.hasSameOperand() || other.hasSameOperand()) {
            return false;
        }
        return (this.hasOperand(other.leftOp) || this.hasOperand(other.rightOp)) && !this.hasSameOperandsAs(other);
    }

    @CheckForNull
    private RelationalSymbolicValue combineTransitively(RelationalSymbolicValue other) {
        if (!this.potentiallyTransitiveWith(other)) {
            return null;
        }
        RelationalSymbolicValue transitive = this.combineTransitivelyOneWay(other);
        if (transitive != null) {
            return transitive;
        }
        return other.combineTransitivelyOneWay(this);
    }

    @CheckForNull
    private RelationalSymbolicValue combineTransitivelyOneWay(RelationalSymbolicValue other) {
        RelationalSymbolicValue transitive = this.equalityTransitiveBuilder(other);
        if (transitive != null) {
            return transitive;
        }
        transitive = this.lessThanTransitiveBuilder(other);
        if (transitive != null) {
            return transitive;
        }
        return this.greaterThanEqualTransitiveBuilder(other);
    }

    @CheckForNull
    private RelationalSymbolicValue equalityTransitiveBuilder(RelationalSymbolicValue other) {
        if (!this.isEquality() || this.kind == Kind.METHOD_EQUALS && other.kind == Kind.EQUAL) {
            return null;
        }
        return new RelationalSymbolicValue(other.kind, this.hasOperand(other.leftOp) ? this.differentOperand(other) : other.leftOp, this.hasOperand(other.leftOp) ? other.rightOp : this.differentOperand(other));
    }

    @CheckForNull
    private RelationalSymbolicValue lessThanTransitiveBuilder(RelationalSymbolicValue other) {
        if (this.kind != Kind.LESS_THAN) {
            return null;
        }
        if (other.kind == Kind.LESS_THAN) {
            if (this.rightOp.equals(other.leftOp)) {
                return new RelationalSymbolicValue(Kind.LESS_THAN, this.leftOp, other.rightOp);
            }
            if (this.leftOp.equals(other.rightOp)) {
                return new RelationalSymbolicValue(Kind.LESS_THAN, other.leftOp, this.rightOp);
            }
        }
        if (other.kind == Kind.GREATER_THAN_OR_EQUAL) {
            if (this.rightOp.equals(other.rightOp)) {
                return new RelationalSymbolicValue(Kind.LESS_THAN, this.leftOp, other.leftOp);
            }
            if (this.leftOp.equals(other.leftOp)) {
                return new RelationalSymbolicValue(Kind.LESS_THAN, other.rightOp, this.rightOp);
            }
        }
        return null;
    }

    @CheckForNull
    private RelationalSymbolicValue greaterThanEqualTransitiveBuilder(RelationalSymbolicValue other) {
        if (this.kind == Kind.GREATER_THAN_OR_EQUAL && other.kind == Kind.GREATER_THAN_OR_EQUAL && this.rightOp.equals(other.leftOp)) {
            return new RelationalSymbolicValue(Kind.GREATER_THAN_OR_EQUAL, this.leftOp, other.rightOp);
        }
        return null;
    }

    private boolean hasSameOperand() {
        return this.leftOp.equals(this.rightOp);
    }

    private boolean hasOperand(SymbolicValue operand) {
        return this.leftOp.equals(operand) || this.rightOp.equals(operand);
    }

    private boolean hasSameOperandsAs(RelationalSymbolicValue other) {
        return this.leftOp.equals(other.leftOp) && this.rightOp.equals(other.rightOp) || this.leftOp.equals(other.rightOp) && this.rightOp.equals(other.leftOp);
    }

    @VisibleForTesting
    SymbolicValue differentOperand(RelationalSymbolicValue other) {
        Preconditions.checkState((boolean)this.potentiallyTransitiveWith(other), (String)"%s is not in transitive relationship with %s", (Object)this, (Object)other);
        return other.hasOperand(this.leftOp) ? this.rightOp : this.leftOp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationalSymbolicValue that = (RelationalSymbolicValue)o;
        if (this.kind != that.kind) {
            return false;
        }
        if (this.leftOp.equals(that.leftOp) && this.rightOp.equals(that.rightOp)) {
            return true;
        }
        return this.isCommutative() && this.leftOp.equals(that.rightOp) && this.rightOp.equals(that.leftOp);
    }

    private boolean isCommutative() {
        switch (this.kind) {
            case EQUAL: 
            case NOT_EQUAL: 
            case METHOD_EQUALS: 
            case NOT_METHOD_EQUALS: {
                return true;
            }
        }
        return false;
    }

    public boolean isEquality() {
        return this.kind == Kind.EQUAL || this.kind == Kind.METHOD_EQUALS;
    }

    @Override
    public int hashCode() {
        return this.kind.hashCode() + this.leftOp.hashCode() + this.rightOp.hashCode();
    }

    @Override
    public String toString() {
        return this.leftOp.toString() + RelationalSymbolicValue.symbolToString(this.leftSymbol) + this.kind.operand + this.rightOp.toString() + RelationalSymbolicValue.symbolToString(this.rightSymbol);
    }

    private static String symbolToString(@Nullable Symbol symbol) {
        return symbol != null ? "(" + symbol.toString() + ")" : "";
    }

    @VisibleForTesting
    public Kind kind() {
        return this.kind;
    }

    public static class TransitiveRelationExceededException
    extends RuntimeException {
        public TransitiveRelationExceededException(String msg) {
            super("Number of transitive relations exceeded!" + msg);
        }
    }

    public static enum Kind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        METHOD_EQUALS(".EQ."),
        NOT_METHOD_EQUALS(".NE.");

        final String operand;

        private Kind(String operand) {
            this.operand = operand;
        }

        Kind inverse() {
            switch (this) {
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case METHOD_EQUALS: {
                    return NOT_METHOD_EQUALS;
                }
                case NOT_METHOD_EQUALS: {
                    return METHOD_EQUALS;
                }
            }
            throw new IllegalStateException("Unsupported relation!");
        }
    }
}

