/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.se.BytecodeEGWalker;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.checks.DivisionByZeroCheck;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.ExceptionalCheckBasedYield;
import org.sonar.java.se.xproc.ExceptionalYield;
import org.sonar.java.se.xproc.HappyPathYield;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.semantic.Type;

public class MethodBehavior {
    private boolean varArgs;
    private final int arity;
    final Set<MethodYield> yields;
    private final List<SymbolicValue> parameters;
    private final String signature;
    private boolean complete = false;
    private boolean visited = false;
    private List<String> declaredExceptions;

    public MethodBehavior(String signature, boolean varArgs) {
        this.signature = signature;
        this.yields = new LinkedHashSet<MethodYield>();
        this.parameters = new ArrayList<SymbolicValue>();
        this.varArgs = varArgs;
        this.arity = org.objectweb.asm.Type.getArgumentTypes((String)signature.substring(signature.indexOf(40))).length;
        this.declaredExceptions = Collections.emptyList();
    }

    public MethodBehavior(String signature) {
        this(signature, false);
    }

    public void createYield(ExplodedGraph.Node node) {
        this.createYield(node, true);
    }

    public void createYield(ExplodedGraph.Node node, boolean storeNodeForReporting) {
        MethodYield yield;
        ExplodedGraph.Node nodeForYield = null;
        if (storeNodeForReporting) {
            nodeForYield = node;
        }
        boolean expectReturnValue = !this.isConstructor() && !this.isVoidMethod();
        SymbolicValue resultSV = node.programState.exitValue();
        if (resultSV == null && expectReturnValue || resultSV instanceof SymbolicValue.ExceptionalSymbolicValue) {
            ExceptionalYield exceptionalYield = new ExceptionalYield(nodeForYield, this);
            if (resultSV != null) {
                Type type = ((SymbolicValue.ExceptionalSymbolicValue)resultSV).exceptionType();
                String typeName = null;
                while (type != null && type.symbol().owner().isMethodSymbol()) {
                    type = type.symbol().superClass();
                }
                if (type != null) {
                    typeName = type.fullyQualifiedName();
                }
                exceptionalYield.setExceptionType(typeName);
            }
            yield = exceptionalYield;
        } else {
            HappyPathYield happyPathYield = new HappyPathYield(nodeForYield, this);
            if (expectReturnValue) {
                ConstraintsByDomain cleanup = MethodBehavior.cleanup(node.programState.getConstraints(resultSV), org.objectweb.asm.Type.getReturnType((String)this.signature.substring(this.signature.indexOf(40))));
                if (cleanup.isEmpty()) {
                    cleanup = null;
                }
                happyPathYield.setResult(this.parameters.indexOf(resultSV), cleanup);
            }
            yield = happyPathYield;
        }
        this.addParameterConstraints(node, yield);
        this.yields.add(yield);
    }

    private void addParameterConstraints(ExplodedGraph.Node node, MethodYield yield) {
        int index = 0;
        for (SymbolicValue parameter : this.parameters) {
            ConstraintsByDomain constraints = node.programState.getConstraints(parameter);
            if (constraints == null) {
                constraints = ConstraintsByDomain.empty();
            } else {
                org.objectweb.asm.Type[] argumentTypes = org.objectweb.asm.Type.getArgumentTypes((String)this.signature.substring(this.signature.indexOf(40)));
                constraints = MethodBehavior.cleanup(constraints, argumentTypes[index]);
            }
            yield.parametersConstraints.add(constraints);
            ++index;
        }
    }

    private static ConstraintsByDomain cleanup(@Nullable ConstraintsByDomain constraints, org.objectweb.asm.Type argumentType) {
        if (constraints == null || constraints.isEmpty()) {
            return ConstraintsByDomain.empty();
        }
        ConstraintsByDomain result = constraints.remove(BytecodeEGWalker.StackValueCategoryConstraint.class);
        result = argumentType.getSort() == 1 ? result.remove(DivisionByZeroCheck.ZeroConstraint.class) : result.remove(BooleanConstraint.class);
        return result;
    }

    public ExceptionalYield createExceptionalCheckBasedYield(SymbolicValue target, ExplodedGraph.Node node, String exceptionType, SECheck check) {
        ExceptionalCheckBasedYield yield = new ExceptionalCheckBasedYield(target, exceptionType, check.getClass(), node, this);
        this.addParameterConstraints(node, yield);
        this.yields.add(yield);
        return yield;
    }

    public boolean isMethodVarArgs() {
        return this.varArgs;
    }

    public int methodArity() {
        return this.arity;
    }

    private boolean isVoidMethod() {
        return org.objectweb.asm.Type.getReturnType((String)this.signature.substring(this.signature.indexOf(40))) == org.objectweb.asm.Type.VOID_TYPE;
    }

    private boolean isConstructor() {
        return this.signature.contains("<init>");
    }

    public List<MethodYield> yields() {
        return ImmutableList.builder().addAll(this.yields).build();
    }

    public Stream<ExceptionalYield> exceptionalPathYields() {
        return this.yields.stream().filter(y -> y instanceof ExceptionalYield).map(ExceptionalYield.class::cast);
    }

    public Stream<HappyPathYield> happyPathYields() {
        return this.yields.stream().filter(y -> y instanceof HappyPathYield).map(HappyPathYield.class::cast);
    }

    public void addParameter(SymbolicValue sv) {
        this.parameters.add(sv);
    }

    public List<SymbolicValue> parameters() {
        return this.parameters;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void completed() {
        this.complete = true;
        this.visited = true;
        this.reduceYields();
    }

    private void reduceYields() {
        int sizeBeforeReduction;
        Set<HappyPathYield> happyPathYields = this.happyPathYields().filter(y -> y.resultIndex() == -1).collect(Collectors.toCollection(LinkedHashSet::new));
        this.yields.removeAll(happyPathYields);
        Set<HappyPathYield> newYields = happyPathYields;
        do {
            sizeBeforeReduction = newYields.size();
        } while ((newYields = this.reduce(newYields)).size() < sizeBeforeReduction);
        this.yields.addAll(newYields);
    }

    private Set<HappyPathYield> reduce(Set<HappyPathYield> yields) {
        LinkedList<HappyPathYield> yieldsToReduce = new LinkedList<HappyPathYield>(yields);
        LinkedHashSet<HappyPathYield> newYields = new LinkedHashSet<HappyPathYield>();
        while (!yieldsToReduce.isEmpty()) {
            HappyPathYield yield1 = yieldsToReduce.removeFirst();
            HappyPathYield reduced = null;
            ListIterator iterator = yieldsToReduce.listIterator();
            while (iterator.hasNext()) {
                HappyPathYield yield2 = (HappyPathYield)iterator.next();
                reduced = this.reduce(yield1, yield2);
                if (reduced == null) continue;
                newYields.add(reduced);
                iterator.remove();
                break;
            }
            if (reduced != null) continue;
            newYields.add(yield1);
        }
        return newYields;
    }

    @CheckForNull
    private HappyPathYield reduce(HappyPathYield yield1, HappyPathYield yield2) {
        Optional<Integer> onlyConstraintDifferenceIndex = MethodBehavior.getOnlyConstraintDifferenceIndex(yield1, yield2);
        if (!onlyConstraintDifferenceIndex.isPresent()) {
            return null;
        }
        int constraintDifferenceIndex = onlyConstraintDifferenceIndex.get();
        HappyPathYield reducedYield = new HappyPathYield(this);
        reducedYield.parametersConstraints = new ArrayList(yield1.parametersConstraints);
        reducedYield.setResult(yield1.resultIndex(), yield1.resultConstraint());
        if (constraintDifferenceIndex == yield1.parametersConstraints.size()) {
            if (MethodBehavior.isIrreducible(yield1.resultConstraint()) || MethodBehavior.isIrreducible(yield2.resultConstraint())) {
                return null;
            }
            reducedYield.setResult(-1, null);
        } else {
            reducedYield.parametersConstraints.set(constraintDifferenceIndex, ConstraintsByDomain.empty());
        }
        return reducedYield;
    }

    private static Optional<Integer> getOnlyConstraintDifferenceIndex(HappyPathYield yield1, HappyPathYield yield2) {
        ArrayList<ConstraintsByDomain> constraints1 = new ArrayList<ConstraintsByDomain>(yield1.parametersConstraints);
        constraints1.add(yield1.resultConstraint());
        ArrayList<ConstraintsByDomain> constraints2 = new ArrayList<ConstraintsByDomain>(yield2.parametersConstraints);
        constraints2.add(yield2.resultConstraint());
        ArrayList<Integer> diff = new ArrayList<Integer>();
        for (int i = 0; i < constraints1.size(); ++i) {
            if (Objects.equals(constraints1.get(i), constraints2.get(i))) continue;
            diff.add(i);
        }
        if (diff.size() != 1) {
            return Optional.empty();
        }
        return Optional.of((Integer)diff.get(0));
    }

    private static boolean isIrreducible(@Nullable ConstraintsByDomain constraints) {
        return constraints != null && (constraints.hasConstraint(ObjectConstraint.NULL) || constraints.hasConstraint(DivisionByZeroCheck.ZeroConstraint.ZERO));
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void visited() {
        this.visited = true;
    }

    public String signature() {
        return this.signature;
    }

    public void setVarArgs(boolean varArgs) {
        this.varArgs = varArgs;
    }

    public List<String> getDeclaredExceptions() {
        return this.declaredExceptions;
    }

    public void setDeclaredExceptions(List<String> declaredExceptions) {
        this.declaredExceptions = declaredExceptions;
    }
}

