/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.time.Clock;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class ExecutionTimeReport {
    private static final Logger LOG = Loggers.get(ExecutionTimeReport.class);
    private static final int MAX_REPORTED_FILES = 10;
    private static final long MIN_REPORTED_ANALYSIS_TIME_MS = 1000L;
    private static final long MIN_TOTAL_ANALYSIS_TIME_TO_REPORT_MS = 20000L;
    private static final Comparator<ExecutionTime> ORDER_BY_ANALYSIS_TIME_DESCENDING_AND_FILE_ASCENDING = (a, b) -> {
        int compare = Long.compare(((ExecutionTime)b).analysisTime, ((ExecutionTime)a).analysisTime);
        return compare != 0 ? compare : ((ExecutionTime)a).file.compareTo(((ExecutionTime)b).file);
    };
    private final LinkedList<ExecutionTime> recordedOrderedExecutionTime = new LinkedList();
    private long minRecordedOrderedExecutionTime = 1000L;
    private final Clock clock;
    private final long analysisStartTimeMS;
    private String currentFile;
    private long currentFileStartTimeMS;

    public ExecutionTimeReport(Clock clock) {
        this.clock = clock;
        this.analysisStartTimeMS = clock.millis();
    }

    public void start(String currentFile) {
        this.currentFile = currentFile;
        this.currentFileStartTimeMS = this.clock.millis();
    }

    public void end() {
        long currentAnalysisTime = this.clock.millis() - this.currentFileStartTimeMS;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Analysis time of " + this.currentFile + " (" + currentAnalysisTime + "ms)");
        } else if (currentAnalysisTime >= 1000L && LOG.isDebugEnabled()) {
            LOG.debug("Analysis time of " + this.currentFile + " (" + currentAnalysisTime + "ms)");
        }
        if (currentAnalysisTime >= this.minRecordedOrderedExecutionTime) {
            this.recordedOrderedExecutionTime.add(new ExecutionTime(this.currentFile, currentAnalysisTime));
            this.recordedOrderedExecutionTime.sort(ORDER_BY_ANALYSIS_TIME_DESCENDING_AND_FILE_ASCENDING);
            if (this.recordedOrderedExecutionTime.size() > 10) {
                this.recordedOrderedExecutionTime.removeLast();
                this.minRecordedOrderedExecutionTime = this.recordedOrderedExecutionTime.stream().mapToLong(e -> ((ExecutionTime)e).analysisTime).min().orElse(1000L);
            }
        }
        this.currentFile = null;
    }

    public void report() {
        long analysisEndTimeMS;
        if (this.currentFile != null) {
            this.end();
        }
        if ((analysisEndTimeMS = this.clock.millis() - this.analysisStartTimeMS) >= 20000L && !this.recordedOrderedExecutionTime.isEmpty()) {
            LOG.info("Slowest analyzed files:" + System.lineSeparator() + this.toString());
        }
    }

    public String toString() {
        return this.recordedOrderedExecutionTime.stream().map(e -> "    " + ((ExecutionTime)e).file + " (" + ((ExecutionTime)e).analysisTime + "ms)").collect(Collectors.joining(System.lineSeparator()));
    }

    private static class ExecutionTime {
        private final String file;
        private final long analysisTime;

        public ExecutionTime(String file, long analysisTime) {
            this.file = file;
            this.analysisTime = analysisTime;
        }
    }
}

