/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.sonar.sslr.api.RecognitionException;
import java.io.InterruptedIOException;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.ExecutionTimeReport;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JParser;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.analyzer.commons.ProgressReport;

public class JavaAstScanner {
    private static final Logger LOG = Loggers.get(JavaAstScanner.class);
    private static final String LOG_ERROR_STACKOVERFLOW = "A stack overflow error occurred while analyzing file: '%s'";
    private static final String LOG_ERROR_UNABLE_TO_PARSE_FILE = "Unable to parse source file : '%s'";
    private static final String LOG_WARN_MISCONFIGURED_JAVA_VERSION = "Analyzing '%s' file with misconfigured Java version. Please check that property '%s' is correctly configured (currently set to: %d) or exclude 'module-info.java' files from analysis. Such files only exist in Java9+ projects.";
    private final SonarComponents sonarComponents;
    private VisitorsBridge visitor;
    private boolean reportedMisconfiguredVersion = false;

    public JavaAstScanner(@Nullable SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<? extends InputFile> inputFiles) {
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Iterable)StreamSupport.stream(inputFiles.spliterator(), false).map(InputFile::toString).collect(Collectors.toList()));
        boolean successfullyCompleted = false;
        boolean cancelled = false;
        ExecutionTimeReport executionTimeReport = new ExecutionTimeReport(Clock.systemUTC());
        try {
            for (InputFile inputFile : inputFiles) {
                if (this.analysisCancelled()) {
                    cancelled = true;
                    break;
                }
                executionTimeReport.start(inputFile.toString());
                this.simpleScan(inputFile);
                executionTimeReport.end();
                progressReport.nextFile();
            }
            successfullyCompleted = !cancelled;
        }
        finally {
            if (successfullyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
            executionTimeReport.report();
            this.visitor.endOfAnalysis();
            this.logUndefinedTypes();
        }
    }

    private void logUndefinedTypes() {
        if (this.sonarComponents != null) {
            this.sonarComponents.logUndefinedTypes();
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    private void simpleScan(InputFile inputFile) {
        this.visitor.setCurrentFile(inputFile);
        try {
            String version;
            JavaVersion javaVersion = this.visitor.getJavaVersion();
            if (javaVersion == null || javaVersion.asInt() < 0) {
                version = "15";
            } else if ("module-info.java".equals(inputFile.filename()) && javaVersion.asInt() <= 8) {
                this.logMisconfiguredVersion(inputFile, javaVersion);
                version = "15";
            } else {
                version = Integer.toString(javaVersion.asInt());
            }
            JavaTree.CompilationUnitTreeImpl ast = (JavaTree.CompilationUnitTreeImpl)JParser.parse(version, inputFile.filename(), inputFile.contents(), this.visitor.getClasspath());
            this.visitor.visitFile(ast);
            this.collectUndefinedTypes(ast.sema.undefinedTypes());
            ast.sema.cleanupEnvironment();
        }
        catch (RecognitionException e) {
            JavaAstScanner.checkInterrupted((Exception)((Object)e));
            LOG.error(String.format(LOG_ERROR_UNABLE_TO_PARSE_FILE, inputFile));
            LOG.error(e.getMessage());
            this.parseErrorWalkAndVisit(e, inputFile);
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            JavaAstScanner.checkInterrupted(e);
            this.interruptIfFailFast(e, inputFile);
        }
        catch (StackOverflowError error) {
            LOG.error(String.format(LOG_ERROR_STACKOVERFLOW, inputFile), (Throwable)error);
            throw error;
        }
    }

    private void collectUndefinedTypes(Set<String> undefinedTypes) {
        if (this.sonarComponents != null) {
            this.sonarComponents.collectUndefinedTypes(undefinedTypes);
        }
    }

    void logMisconfiguredVersion(InputFile inputFile, JavaVersion javaVersion) {
        if (!this.reportedMisconfiguredVersion) {
            LOG.warn(String.format(LOG_WARN_MISCONFIGURED_JAVA_VERSION, inputFile, "sonar.java.source", javaVersion.asInt()));
            this.reportedMisconfiguredVersion = true;
        }
    }

    private void interruptIfFailFast(Exception e, InputFile inputFile) {
        if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e);
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, InputFile inputFile) {
        try {
            this.visitor.processRecognitionException(e, inputFile);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e2);
        }
    }

    private static String getAnalysisExceptionMessage(InputFile file) {
        return String.format("Unable to analyze file : '%s'", file);
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile file, VisitorsBridge visitorsBridge) {
        JavaAstScanner.scanSingleFileForTests(file, visitorsBridge, new JavaVersionImpl(), null);
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile inputFile, VisitorsBridge visitorsBridge, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents) {
        JavaAstScanner astScanner = new JavaAstScanner(sonarComponents);
        visitorsBridge.setJavaVersion(javaVersion);
        astScanner.setVisitorBridge(visitorsBridge);
        astScanner.scan(Collections.singleton(inputFile));
    }
}

