/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.classpath.JavaSdkUtil;
import org.sonar.java.collections.CollectionUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public abstract class AbstractClasspath {
    private static final String SEPARATOR = ",";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final Logger LOG = Loggers.get(AbstractClasspath.class);
    protected final Configuration settings;
    protected final FileSystem fs;
    private final InputFile.Type fileType;
    private static final Path[] STANDARD_CLASSES_DIRS = new Path[]{Paths.get("target", "classes"), Paths.get("target", "test-classes")};
    protected final List<File> binaries;
    protected final List<File> elements;
    protected boolean validateLibraries;
    protected boolean initialized;

    protected AbstractClasspath(Configuration settings, FileSystem fs, InputFile.Type fileType) {
        this.settings = settings;
        this.fs = fs;
        this.fileType = fileType;
        this.binaries = new ArrayList<File>();
        this.elements = new ArrayList<File>();
        this.initialized = false;
    }

    protected List<File> getJdkJars() {
        List<File> jdkClassesRoots = this.settings.get("sonar.java.jdkHome").flatMap(AbstractClasspath::existingDirectoryOrLog).map(File::toPath).map(JavaSdkUtil::getJdkClassesRoots).orElse(Collections.emptyList());
        AbstractClasspath.logResolvedFiles("sonar.java.jdkHome", jdkClassesRoots);
        return jdkClassesRoots;
    }

    static void logResolvedFiles(String property, Collection<File> files) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Property '%s' resolved with:%n%s", property, files.stream().map(File::getAbsolutePath).collect(Collectors.joining(SEPARATOR + System.lineSeparator(), "[", "]"))));
        }
    }

    private static Optional<File> existingDirectoryOrLog(String path) {
        LOG.debug("Property '{}' set with: {}", (Object)"sonar.java.jdkHome", (Object)path);
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            String warning = "Invalid value for '%s' property, defaulting to runtime JDK.%nConfigured location does not exists: '%s'";
            LOG.warn(String.format(warning, "sonar.java.jdkHome", file.getAbsolutePath()));
            return Optional.empty();
        }
        return Optional.of(file);
    }

    protected abstract void init();

    public abstract void logSuspiciousEmptyLibraries();

    protected Set<File> getFilesFromProperty(String property) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        String fileList = this.settings.get(property).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)fileList)) {
            Iterable fileNames = Arrays.stream(fileList.split(SEPARATOR)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            File baseDir = this.fs.baseDir();
            boolean hasJavaSources = this.hasJavaSources();
            boolean validateLibs = this.validateLibraries;
            boolean isLibraryProperty = property.endsWith("libraries");
            for (String pathPattern : fileNames) {
                Set<File> libraryFilesForPattern = this.getFilesForPattern(baseDir.toPath(), pathPattern, isLibraryProperty);
                if (this.validateLibraries && libraryFilesForPattern.isEmpty() && hasJavaSources) {
                    LOG.error("Invalid value for '" + property + "' property.");
                    String message = "No files nor directories matching '" + pathPattern + "'";
                    throw new IllegalStateException(message);
                }
                this.validateLibraries = validateLibs;
                result.addAll(libraryFilesForPattern);
            }
        }
        return result;
    }

    protected boolean hasJavaSources() {
        return this.fs.hasFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(this.fileType)));
    }

    protected boolean hasMoreThanOneJavaFile() {
        return CollectionUtils.size(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(this.fileType)))) > 1;
    }

    private Set<File> getFilesForPattern(Path baseDir, String pathPattern, boolean libraryProperty) {
        try {
            Path filePath = AbstractClasspath.resolvePath(baseDir, pathPattern);
            File file = filePath.toFile();
            if (file.isFile()) {
                return this.getMatchingFile(pathPattern, file);
            }
            if (file.isDirectory()) {
                return AbstractClasspath.getMatchesInDir(filePath, libraryProperty);
            }
        }
        catch (IOException | InvalidPathException filePath) {
            // empty catch block
        }
        String dirPath = AbstractClasspath.sanitizeWildcards(pathPattern);
        String fileNamePattern = pathPattern;
        int lastPathSeparator = Math.max(dirPath.lastIndexOf(47), dirPath.lastIndexOf(92));
        if (lastPathSeparator == -1) {
            dirPath = ".";
        } else {
            dirPath = pathPattern.substring(0, lastPathSeparator);
            fileNamePattern = pathPattern.substring(lastPathSeparator + 1);
        }
        Path dir = AbstractClasspath.resolvePath(baseDir, dirPath);
        return AbstractClasspath.getFilesInDir(dir, fileNamePattern, libraryProperty);
    }

    private static Set<File> getFilesInDir(Path dir, String fileNamePattern, boolean libraryProperty) {
        if (!dir.toFile().isDirectory()) {
            return Collections.emptySet();
        }
        try {
            if (libraryProperty) {
                return AbstractClasspath.getMatchingLibraries(fileNamePattern, dir);
            }
            return AbstractClasspath.getMatchingDirs(fileNamePattern, dir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String sanitizeWildcards(String pathPattern) {
        int wildcardIndex = pathPattern.indexOf(42);
        if (wildcardIndex >= 0) {
            return pathPattern.substring(0, wildcardIndex);
        }
        return pathPattern;
    }

    private Set<File> getMatchingFile(String pathPattern, File file) {
        if (pathPattern.endsWith(".jar") || pathPattern.endsWith(".zip") || pathPattern.endsWith(".aar")) {
            return Collections.singleton(file);
        }
        LOG.debug("File " + file.getAbsolutePath() + " was ignored from java classpath");
        this.validateLibraries = false;
        return Collections.emptySet();
    }

    private static Set<File> getMatchingDirs(String pattern, Path dir) throws IOException {
        if (!StringUtils.isEmpty((CharSequence)pattern)) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher(AbstractClasspath.getGlob(dir, pattern));
            return new DirFinder().find(dir, matcher);
        }
        return Collections.singleton(dir.toFile());
    }

    private static Set<File> getMatchesInDir(Path dirPath, boolean isLibraryProperty) throws IOException {
        if (isLibraryProperty) {
            for (Path end : STANDARD_CLASSES_DIRS) {
                if (!dirPath.endsWith(end)) continue;
                return Collections.singleton(dirPath.toFile());
            }
            Set<File> matches = new LibraryFinder().find(dirPath, p -> true);
            matches.add(dirPath.toFile());
            return matches;
        }
        return Collections.singleton(dirPath.toFile());
    }

    private static String separatorsToUnix(String path) {
        return path.replace('\\', '/');
    }

    private static String getGlob(Path dir, String pattern) {
        return "glob:" + AbstractClasspath.separatorsToUnix(dir.toString()) + '/' + AbstractClasspath.separatorsToUnix(pattern);
    }

    private static Set<File> getMatchingLibraries(String pattern, Path dir) throws IOException {
        LinkedHashSet<File> matches = new LinkedHashSet<File>();
        Set<File> dirs = AbstractClasspath.getMatchingDirs(pattern, dir);
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(AbstractClasspath.getGlob(dir, pattern));
        for (File d : dirs) {
            matches.addAll(AbstractClasspath.getLibs(d.toPath()));
        }
        matches.addAll(dirs);
        matches.addAll(new LibraryFinder().find(dir, matcher));
        if (pattern.startsWith("**/")) {
            matches.addAll(new LibraryFinder().find(dir, FileSystems.getDefault().getPathMatcher(AbstractClasspath.getGlob(dir, pattern.substring(3)))));
        }
        return matches;
    }

    private static List<File> getLibs(Path dir) throws IOException {
        DirectoryStream.Filter<Path> filter = path -> {
            String name = path.getFileName().toString();
            return name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".aar");
        };
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, filter);){
            stream.forEach(p -> files.add(p.toFile()));
        }
        return files;
    }

    private static Path resolvePath(Path baseDir, String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        if (!filePath.isAbsolute()) {
            filePath = baseDir.resolve(fileName);
        }
        return filePath.normalize();
    }

    public List<File> getElements() {
        this.init();
        return this.elements;
    }

    public List<File> getBinaryDirs() {
        this.init();
        return this.binaries;
    }

    private static class LibraryFinder
    extends AbstractFileFinder {
        private LibraryFinder() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            String name = file.getFileName().toString();
            if ((name.endsWith(".jar") || name.endsWith(".zip")) && this.matcher.matches(file)) {
                this.matchedFiles.add(file.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DirFinder
    extends AbstractFileFinder {
        private DirFinder() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.matcher.matches(dir)) {
                this.matchedFiles.add(dir.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static abstract class AbstractFileFinder
    extends SimpleFileVisitor<Path> {
        protected Set<File> matchedFiles = new LinkedHashSet<File>();
        protected PathMatcher matcher;

        private AbstractFileFinder() {
        }

        Set<File> find(Path dir, PathMatcher matcher) throws IOException {
            this.matcher = matcher;
            Files.walkFileTree(dir, this);
            return this.matchedFiles;
        }
    }
}

