/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JLabelSymbol;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class IdentifierTreeImpl
extends AssessableExpressionTree
implements IdentifierTree,
JavaTree.AnnotatedTypeTree {
    private final InternalSyntaxToken nameToken;
    private List<AnnotationTree> annotations;
    public IBinding binding;
    public JLabelSymbol labelSymbol;

    public IdentifierTreeImpl(InternalSyntaxToken nameToken) {
        this.nameToken = Objects.requireNonNull(nameToken);
        this.annotations = Collections.emptyList();
    }

    @Override
    public void complete(List<AnnotationTree> annotations) {
        this.annotations = Objects.requireNonNull(annotations);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.IDENTIFIER;
    }

    @Override
    public SyntaxToken identifierToken() {
        return this.nameToken;
    }

    @Override
    public String name() {
        return this.identifierToken().text();
    }

    @Override
    public Symbol symbol() {
        if (this.binding != null) {
            switch (this.binding.getKind()) {
                case 2: {
                    return this.root.sema.typeSymbol((ITypeBinding)this.binding);
                }
                case 4: {
                    return this.root.sema.methodSymbol((IMethodBinding)this.binding);
                }
                case 3: {
                    return this.root.sema.variableSymbol((IVariableBinding)this.binding);
                }
                case 1: {
                    return this.root.sema.packageSymbol((IPackageBinding)this.binding);
                }
            }
        }
        if (this.labelSymbol != null) {
            return this.labelSymbol;
        }
        return Symbols.unknownSymbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIdentifier(this);
    }

    public String toString() {
        return this.name();
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(this.annotations, Collections.singletonList(this.nameToken));
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }
}

