/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.NoSuchElementException;
import org.sonar.java.regex.ast.SourceCharacter;

public class CharacterBuffer {
    private static final int RESIZE_FACTOR = 2;
    private SourceCharacter[] contents;
    private int startIndex = 0;
    private int size = 0;

    public CharacterBuffer(int initialCapacity) {
        this.contents = new SourceCharacter[initialCapacity];
    }

    public SourceCharacter get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " for buffer of size " + this.size + ".");
        }
        return this.contents[(this.startIndex + index) % this.contents.length];
    }

    public void add(SourceCharacter character) {
        if (this.size + 1 == this.contents.length) {
            this.resize(this.contents.length * 2);
        }
        this.contents[(this.startIndex + this.size) % this.contents.length] = character;
        ++this.size;
    }

    public void removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("Trying to delete from empty buffer.");
        }
        ++this.startIndex;
        if (this.startIndex == this.contents.length) {
            this.startIndex = 0;
        }
        --this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void resize(int newCapacity) {
        SourceCharacter[] newContents = new SourceCharacter[newCapacity];
        System.arraycopy(this.contents, this.startIndex, newContents, 0, this.contents.length - this.startIndex);
        System.arraycopy(this.contents, 0, newContents, this.contents.length - this.startIndex, this.startIndex);
        this.contents = newContents;
        this.startIndex = 0;
    }
}

