/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.regex.CharacterParser;
import org.sonar.java.regex.JavaCharacterParser;
import org.sonar.java.regex.RegexDialect;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.plugins.java.api.tree.LiteralTree;

public class JavaRegexSource
implements RegexSource {
    private final String sourceText;
    private final TextSpanTracker indexToTextSpan = new TextSpanTracker();

    public JavaRegexSource(List<LiteralTree> stringLiterals) {
        StringBuilder sb = new StringBuilder();
        for (LiteralTree literal : stringLiterals) {
            String text = JavaRegexSource.getString(literal);
            sb.append(text);
            this.indexToTextSpan.addLiteral(literal, text.length());
        }
        this.sourceText = sb.toString();
    }

    @Override
    public String getSourceText() {
        return this.sourceText;
    }

    public List<AnalyzerMessage.TextSpan> textSpansFor(IndexRange range) {
        ArrayList<AnalyzerMessage.TextSpan> result = new ArrayList<AnalyzerMessage.TextSpan>();
        TextSpanEntry startEntry = this.indexToTextSpan.entryAtIndex(range.getBeginningOffset());
        if (range.getBeginningOffset() < 0) {
            startEntry = this.indexToTextSpan.entryAtIndex(0);
        }
        int startOffset = range.getBeginningOffset() - startEntry.startIndex;
        TextSpanEntry endEntry = this.indexToTextSpan.entryBeforeIndex(range.getEndingOffset());
        if (range.getEndingOffset() <= 0) {
            endEntry = startEntry;
        }
        int endOffset = range.getEndingOffset() - endEntry.startIndex;
        AnalyzerMessage.TextSpan startSpan = startEntry.textSpan;
        AnalyzerMessage.TextSpan endSpan = endEntry.textSpan;
        if (startSpan == endSpan) {
            result.add(new AnalyzerMessage.TextSpan(startSpan.startLine, startSpan.startCharacter + startOffset, startSpan.endLine, startSpan.startCharacter + endOffset));
        } else {
            result.add(new AnalyzerMessage.TextSpan(startSpan.startLine, startSpan.startCharacter + startOffset, startSpan.endLine, startSpan.endCharacter));
            int indexAfterStartSpan = startEntry.startIndex + startSpan.endCharacter - startSpan.startCharacter;
            result.addAll(this.indexToTextSpan.textSpansBetween(indexAfterStartSpan, endEntry.startIndex));
            result.add(new AnalyzerMessage.TextSpan(endSpan.startLine, endSpan.startCharacter, endSpan.endLine, endSpan.startCharacter + endOffset));
        }
        return result;
    }

    @Override
    public CharacterParser createCharacterParser() {
        return new JavaCharacterParser(this);
    }

    @Override
    public RegexDialect dialect() {
        return RegexDialect.JAVA;
    }

    private static String getString(LiteralTree literal) {
        return literal.asConstant(String.class).orElseThrow(() -> new IllegalArgumentException("Only string literals allowed"));
    }

    private static class TextSpanEntry {
        final int startIndex;
        final AnalyzerMessage.TextSpan textSpan;

        TextSpanEntry(Map.Entry<Integer, AnalyzerMessage.TextSpan> entry) {
            this.startIndex = entry.getKey();
            this.textSpan = entry.getValue();
        }
    }

    private static class TextSpanTracker {
        final NavigableMap<Integer, AnalyzerMessage.TextSpan> indexToTextSpan = new TreeMap<Integer, AnalyzerMessage.TextSpan>();
        int index = 0;

        private TextSpanTracker() {
        }

        void addLiteral(LiteralTree literal, int length) {
            AnalyzerMessage.TextSpan literalSpan = AnalyzerMessage.textSpanFor(literal);
            this.indexToTextSpan.put(this.index, new AnalyzerMessage.TextSpan(literalSpan.startLine, literalSpan.startCharacter + 1, literalSpan.endLine, literalSpan.endCharacter - 1));
            this.index += length;
        }

        @Nullable
        TextSpanEntry entryAtIndex(Integer index) {
            return this.entry(this.indexToTextSpan.floorEntry(index));
        }

        @Nullable
        TextSpanEntry entryBeforeIndex(Integer index) {
            return this.entry(this.indexToTextSpan.lowerEntry(index));
        }

        @Nullable
        TextSpanEntry entry(@Nullable Map.Entry<Integer, AnalyzerMessage.TextSpan> e) {
            if (e == null) {
                return null;
            }
            return new TextSpanEntry(e);
        }

        Collection<AnalyzerMessage.TextSpan> textSpansBetween(Integer startIndex, Integer endIndex) {
            return this.indexToTextSpan.subMap(startIndex, endIndex).values();
        }
    }
}

