/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.Collections;
import java.util.List;
import org.sonar.java.regex.SyntaxError;
import org.sonar.java.regex.ast.FinalState;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.OpeningQuote;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.StartState;

public class RegexParseResult {
    private final RegexTree result;
    private final List<SyntaxError> syntaxErrors;
    private final boolean containsComments;
    private final StartState startState;
    private final FinalState finalState;

    public RegexParseResult(RegexTree result, StartState startState, FinalState finalState, List<SyntaxError> syntaxErrors, boolean containsComments) {
        this.result = result;
        this.startState = startState;
        this.finalState = finalState;
        this.syntaxErrors = Collections.unmodifiableList(syntaxErrors);
        this.containsComments = containsComments;
    }

    public RegexTree getResult() {
        return this.result;
    }

    public FlagSet getInitialFlags() {
        return this.startState.activeFlags();
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public boolean hasSyntaxErrors() {
        return !this.syntaxErrors.isEmpty();
    }

    public boolean containsComments() {
        return this.containsComments;
    }

    public RegexSyntaxElement openingQuote() {
        return new OpeningQuote(this.result.getSource());
    }

    public FinalState getFinalState() {
        return this.finalState;
    }

    public StartState getStartState() {
        return this.startState;
    }
}

