/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.regex.RegexLexer;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.SyntaxError;
import org.sonar.java.regex.ast.AtomicGroupTree;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.BoundaryTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.CharacterClassElementTree;
import org.sonar.java.regex.ast.CharacterClassIntersectionTree;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.CharacterClassUnionTree;
import org.sonar.java.regex.ast.CharacterRangeTree;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.CurlyBraceQuantifier;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.DotTree;
import org.sonar.java.regex.ast.EscapedCharacterClassTree;
import org.sonar.java.regex.ast.FinalState;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.MiscEscapeSequenceTree;
import org.sonar.java.regex.ast.NonCapturingGroupTree;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexToken;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.java.regex.ast.SimpleQuantifier;
import org.sonar.java.regex.ast.SourceCharacter;
import org.sonar.java.regex.ast.StartState;

public class RegexParser {
    private static final Logger LOG = Loggers.get(RegexParser.class);
    private static final String HEX_DIGIT = "hexadecimal digit";
    private final RegexSource source;
    private final RegexLexer characters;
    private FlagSet activeFlags;
    private final List<BackReferenceTree> backReferences = new ArrayList<BackReferenceTree>();
    private final Map<String, CapturingGroupTree> capturingGroups = new HashMap<String, CapturingGroupTree>();
    private final List<SyntaxError> errors = new ArrayList<SyntaxError>();
    private int groupNumber = 1;

    public RegexParser(RegexSource source, FlagSet initialFlags) {
        this.source = source;
        this.characters = source.createLexer();
        this.characters.setFreeSpacingMode(initialFlags.contains(4));
        this.activeFlags = initialFlags;
    }

    public RegexParseResult parse() {
        RegexTree result;
        FlagSet initialFlags = this.activeFlags;
        ArrayList<RegexTree> results = new ArrayList<RegexTree>();
        do {
            result = this.parseDisjunction();
            results.add(result);
            if (!this.characters.isNotAtEnd()) continue;
            this.error("Unexpected '" + this.characters.getCurrent().getCharacter() + "'");
            this.characters.moveNext();
        } while (this.characters.isNotAtEnd());
        if (this.characters.isInQuotingMode()) {
            this.expected("'\\E'");
        }
        result = RegexParser.combineTrees(results, (range, elements) -> new SequenceTree(this.source, range, elements, initialFlags));
        StartState startState = new StartState(result, initialFlags);
        FinalState finalState = new FinalState(this.activeFlags);
        result.setContinuation(finalState);
        this.backReferences.forEach(reference -> reference.setGroup(this.capturingGroups.get(reference.groupName())));
        return new RegexParseResult(result, startState, finalState, this.errors, this.characters.hasComments());
    }

    private RegexTree parseDisjunction() {
        FlagSet disjunctionFlags = this.activeFlags;
        ArrayList<RegexTree> alternatives = new ArrayList<RegexTree>();
        ArrayList<SourceCharacter> orOperators = new ArrayList<SourceCharacter>();
        RegexTree first = this.parseSequence();
        alternatives.add(first);
        while (this.characters.currentIs('|')) {
            orOperators.add(this.characters.getCurrent());
            this.characters.moveNext();
            RegexTree next = this.parseSequence();
            alternatives.add(next);
        }
        return RegexParser.combineTrees(alternatives, (range, elements) -> new DisjunctionTree(this.source, range, elements, orOperators, disjunctionFlags));
    }

    private RegexTree parseSequence() {
        FlagSet sequenceFlags = this.activeFlags;
        ArrayList<RegexTree> elements = new ArrayList<RegexTree>();
        RegexTree element = this.parseRepetition();
        while (element != null) {
            elements.add(element);
            element = this.parseRepetition();
        }
        if (elements.isEmpty()) {
            int index = this.characters.getCurrentStartIndex();
            return new SequenceTree(this.source, new IndexRange(index, index), elements, sequenceFlags);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new SequenceTree(this.source, range, items, sequenceFlags));
    }

    @CheckForNull
    private RegexTree parseRepetition() {
        FlagSet repetitionFlags = this.activeFlags;
        RegexTree element = this.parsePrimaryExpression();
        if (this.characters.isInQuotingMode()) {
            return element;
        }
        Quantifier quantifier = this.parseQuantifier();
        if (element == null) {
            if (quantifier != null) {
                this.errors.add(new SyntaxError(quantifier, "Unexpected quantifier '" + quantifier.getText() + "'"));
            }
            return null;
        }
        if (quantifier == null) {
            return element;
        }
        return new RepetitionTree(this.source, element.getRange().merge(quantifier.getRange()), element, quantifier, repetitionFlags);
    }

    @CheckForNull
    private Quantifier parseQuantifier() {
        SimpleQuantifier.Kind kind;
        switch (this.characters.getCurrentChar()) {
            case 42: {
                kind = SimpleQuantifier.Kind.STAR;
                break;
            }
            case 43: {
                kind = SimpleQuantifier.Kind.PLUS;
                break;
            }
            case 63: {
                kind = SimpleQuantifier.Kind.QUESTION_MARK;
                break;
            }
            case 123: {
                return this.parseCurlyBraceQuantifier();
            }
            default: {
                return null;
            }
        }
        SourceCharacter current = this.characters.getCurrent();
        this.characters.moveNext();
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = current.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new SimpleQuantifier(this.source, range, modifier, kind);
    }

    CurlyBraceQuantifier parseCurlyBraceQuantifier() {
        SourceCharacter openingBrace = this.characters.getCurrent();
        this.characters.moveNext();
        RegexToken lowerBound = this.parseInteger();
        if (lowerBound == null) {
            this.expected("integer");
            return null;
        }
        RegexToken comma = null;
        RegexToken upperBound = null;
        if (this.characters.currentIs(',')) {
            comma = new RegexToken(this.source, this.characters.getCurrent().getRange());
            this.characters.moveNext();
            upperBound = this.parseInteger();
        }
        if (this.characters.currentIs('}')) {
            this.characters.moveNext();
        } else if (comma == null) {
            this.expected("',' or '}'");
        } else if (upperBound == null) {
            this.expected("integer or '}'");
        } else {
            this.expected("'}'");
        }
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = openingBrace.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CurlyBraceQuantifier(this.source, range, modifier, lowerBound, comma, upperBound);
    }

    Quantifier.Modifier parseQuantifierModifier() {
        switch (this.characters.getCurrentChar()) {
            case 43: {
                this.characters.moveNext();
                return Quantifier.Modifier.POSSESSIVE;
            }
            case 63: {
                this.characters.moveNext();
                return Quantifier.Modifier.RELUCTANT;
            }
        }
        return Quantifier.Modifier.GREEDY;
    }

    @CheckForNull
    private RegexToken parseInteger() {
        int startIndex = this.characters.getCurrentStartIndex();
        if (!RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            return null;
        }
        while (RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            this.characters.moveNext();
        }
        IndexRange range = new IndexRange(startIndex, this.characters.getCurrentStartIndex());
        return new RegexToken(this.source, range);
    }

    @CheckForNull
    private RegexTree parsePrimaryExpression() {
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readCharacter();
        }
        switch (this.characters.getCurrentChar()) {
            case 40: {
                return this.parseGroup();
            }
            case 92: {
                return this.parseEscapeSequence();
            }
            case 91: {
                return this.parseCharacterClass();
            }
            case 46: {
                DotTree tree = new DotTree(this.source, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return tree;
            }
            case 94: {
                BoundaryTree lineStart = new BoundaryTree(this.source, BoundaryTree.Type.LINE_START, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return lineStart;
            }
            case 36: {
                BoundaryTree lineEnd = new BoundaryTree(this.source, BoundaryTree.Type.LINE_END, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return lineEnd;
            }
        }
        if (RegexParser.isPlainTextCharacter(this.characters.getCurrentChar())) {
            return this.readCharacter();
        }
        return null;
    }

    private CharacterTree readCharacter() {
        SourceCharacter character = this.characters.getCurrent();
        this.characters.moveNext();
        return this.characterTree(character);
    }

    private GroupTree parseGroup() {
        SourceCharacter openingParen = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.currentIs("?=")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<=")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?!")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<!")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?>")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> new AtomicGroupTree(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<")) {
            this.characters.moveNext(2);
            String name = this.parseGroupName();
            if (this.characters.currentIs('>')) {
                this.characters.moveNext();
            } else {
                this.expected("'>'");
            }
            return this.finishGroup(openingParen, this.newCapturingGroup(name));
        }
        if (this.characters.currentIs("?")) {
            return this.parseNonCapturingGroup(openingParen);
        }
        return this.finishGroup(openingParen, this.newCapturingGroup(null));
    }

    private GroupConstructor newCapturingGroup(@Nullable String name) {
        int index = this.groupNumber++;
        return (range, inner) -> this.index(new CapturingGroupTree(this.source, range, name, index, inner, this.activeFlags));
    }

    private String parseGroupName() {
        StringBuilder sb = new StringBuilder();
        while (this.characters.isNotAtEnd() && !this.characters.currentIs('>')) {
            sb.append(this.characters.getCurrent().getCharacter());
            this.characters.moveNext();
        }
        String name = sb.toString();
        if (name.isEmpty()) {
            this.expected("a name for the group");
        }
        return name;
    }

    private GroupTree parseNonCapturingGroup(SourceCharacter openingParen) {
        FlagSet disabledFlags;
        this.characters.moveNext();
        FlagSet enabledFlags = this.parseFlags();
        if (this.characters.currentIs('-')) {
            this.characters.moveNext();
            disabledFlags = this.parseFlags();
        } else {
            disabledFlags = new FlagSet();
        }
        boolean previousFreeSpacingMode = this.characters.getFreeSpacingMode();
        if (disabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(false);
        } else if (enabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(true);
        }
        FlagSet previousFlags = this.activeFlags;
        if (!enabledFlags.isEmpty() || !disabledFlags.isEmpty()) {
            this.activeFlags = new FlagSet(this.activeFlags);
            this.activeFlags.addAll(enabledFlags);
            this.activeFlags.removeAll(disabledFlags);
        }
        if (this.characters.currentIs(')')) {
            SourceCharacter closingParen = this.characters.getCurrent();
            this.characters.moveNext();
            IndexRange range2 = openingParen.getRange().merge(closingParen.getRange());
            return new NonCapturingGroupTree(this.source, range2, enabledFlags, disabledFlags, null, this.activeFlags);
        }
        if (this.characters.currentIs(':')) {
            this.characters.moveNext();
        } else {
            this.expected("flag or ':' or ')'");
        }
        GroupTree group = this.finishGroup(previousFreeSpacingMode, openingParen, (range, inner) -> new NonCapturingGroupTree(this.source, range, enabledFlags, disabledFlags, inner, this.activeFlags));
        this.activeFlags = previousFlags;
        return group;
    }

    private FlagSet parseFlags() {
        Integer flag;
        FlagSet flags = new FlagSet();
        while (this.characters.isNotAtEnd() && (flag = RegexParser.parseFlag(this.characters.getCurrent().getCharacter())) != null) {
            flags.add(flag, this.characters.getCurrent());
            this.characters.moveNext();
        }
        return flags;
    }

    @CheckForNull
    private static Integer parseFlag(char ch) {
        switch (ch) {
            case 'i': {
                return 2;
            }
            case 'd': {
                return 1;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'u': {
                return 64;
            }
            case 'x': {
                return 4;
            }
            case 'U': {
                return 256;
            }
        }
        return null;
    }

    private GroupTree finishGroup(SourceCharacter openingParen, GroupConstructor groupConstructor) {
        return this.finishGroup(this.characters.getFreeSpacingMode(), openingParen, groupConstructor);
    }

    private GroupTree finishGroup(boolean previousFreeSpacingMode, SourceCharacter openingParen, GroupConstructor groupConstructor) {
        FlagSet previousFlagSet = this.activeFlags;
        RegexTree inner = this.parseDisjunction();
        this.activeFlags = previousFlagSet;
        this.characters.setFreeSpacingMode(previousFreeSpacingMode);
        if (this.characters.currentIs(')')) {
            this.characters.moveNext();
        } else {
            this.expected("')'");
        }
        IndexRange range = openingParen.getRange().extendTo(this.characters.getCurrentStartIndex());
        return groupConstructor.construct(range, inner);
    }

    private RegexTree parseEscapeSequence() {
        SourceCharacter backslash = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.characterTree(backslash);
        }
        SourceCharacter character = this.characters.getCurrent();
        switch (character.getCharacter()) {
            case 'P': 
            case 'p': {
                return this.parseEscapedProperty(backslash);
            }
            case '0': {
                return this.parseOctalEscape(backslash);
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumericalBackReference(backslash);
            }
            case 'k': {
                return this.parseNamedBackReference(backslash);
            }
            case 'A': 
            case 'B': 
            case 'G': 
            case 'Z': 
            case 'b': 
            case 'z': {
                return this.parseBoundary(backslash);
            }
            case 'D': 
            case 'H': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 's': 
            case 'v': 
            case 'w': {
                return this.parseEscapedCharacterClass(backslash);
            }
            case 'u': {
                return this.parseUnicodeEscape(backslash);
            }
            case 'x': {
                return this.parseHexEscape(backslash);
            }
            case 'a': 
            case 'e': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                this.characters.moveNext();
                char c = RegexParser.simpleEscapeToCharacter(character.getCharacter());
                IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
                return this.characterTree(new SourceCharacter(this.source, range, c, true));
            }
            case 'c': {
                return this.parseControlSequence(backslash);
            }
            case 'N': {
                return this.parseNamedUnicodeCharacter(backslash);
            }
            case 'R': 
            case 'X': {
                this.characters.moveNext();
                return new MiscEscapeSequenceTree(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), this.activeFlags);
            }
            case 'E': {
                this.error("\\E used without \\Q");
            }
        }
        this.characters.moveNext();
        return new CharacterTree(this.source, backslash.getRange().merge(character.getRange()), character.getCharacter(), character.isEscapeSequence(), this.activeFlags);
    }

    private RegexTree parseNamedUnicodeCharacter(SourceCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a Unicode character name", content -> new MiscEscapeSequenceTree(this.source, backslash.getRange().merge(((EscapedSequenceDataHolder)content).closer.getRange()), this.activeFlags));
    }

    private RegexTree parseControlSequence(SourceCharacter backslash) {
        SourceCharacter c = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.characterTree(c);
        }
        char controlCharacter = (char)(0x40 ^ this.characters.getCurrentChar());
        this.characters.moveNext();
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.characterTree(new SourceCharacter(this.source, range, controlCharacter, true));
    }

    private static char simpleEscapeToCharacter(char escapeCharacter) {
        switch (escapeCharacter) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        throw new IllegalArgumentException("Unsupported argument for simpleEscapeToCharacter: " + escapeCharacter);
    }

    private RegexTree parseUnicodeEscape(SourceCharacter backslash) {
        this.characters.moveNext();
        char codeUnit = (char)this.parseFixedAmountOfHexDigits(4);
        return this.characterTree(new SourceCharacter(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), codeUnit, true));
    }

    private RegexTree parseHexEscape(SourceCharacter backslash) {
        this.characters.moveNext();
        int codePoint = 0;
        if (this.characters.currentIs('{')) {
            this.characters.moveNext();
            if (!RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                this.expected(HEX_DIGIT);
            }
            while (RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                codePoint *= 16;
                codePoint += this.parseHexDigit();
            }
            if (this.characters.currentIs('}')) {
                this.characters.moveNext();
            } else {
                this.expected("hexadecimal digit or '}'");
            }
        } else {
            codePoint = this.parseFixedAmountOfHexDigits(2);
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        CharacterTree tree = new CharacterTree(this.source, range, codePoint, true, this.activeFlags);
        if (!Character.isValidCodePoint(codePoint)) {
            this.errors.add(new SyntaxError(tree, "Invalid Unicode code point"));
        }
        return tree;
    }

    private int parseFixedAmountOfHexDigits(int amount) {
        int i;
        int result = 0;
        for (i = 0; i < amount && RegexParser.isHexDigit(this.characters.getCurrentChar()); ++i) {
            result = (char)(result * 16);
            result = (char)(result + this.parseHexDigit());
        }
        if (i < amount) {
            this.expected(HEX_DIGIT);
        }
        return result;
    }

    private int parseHexDigit() {
        int value = Integer.parseInt("" + this.characters.getCurrent().getCharacter(), 16);
        this.characters.moveNext();
        return value;
    }

    private RegexTree parseEscapedCharacterClass(SourceCharacter backslash) {
        EscapedCharacterClassTree result = new EscapedCharacterClassTree(this.source, backslash, this.characters.getCurrent(), this.activeFlags);
        this.characters.moveNext();
        return result;
    }

    private RegexTree parseEscapedProperty(SourceCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a property name", dh -> new EscapedCharacterClassTree(this.source, backslash, ((EscapedSequenceDataHolder)dh).marker, ((EscapedSequenceDataHolder)dh).opener, ((EscapedSequenceDataHolder)dh).closer, this.activeFlags));
    }

    private RegexTree parseNamedBackReference(SourceCharacter backslash) {
        return this.parseEscapedSequence('<', '>', "a group name", dh -> this.collect(new BackReferenceTree(this.source, backslash, ((EscapedSequenceDataHolder)dh).marker, ((EscapedSequenceDataHolder)dh).opener, ((EscapedSequenceDataHolder)dh).closer, this.activeFlags)));
    }

    private BackReferenceTree collect(BackReferenceTree backReference) {
        this.backReferences.add(backReference);
        return backReference;
    }

    private CapturingGroupTree index(CapturingGroupTree capturingGroup) {
        this.capturingGroups.put(Integer.toString(capturingGroup.getGroupNumber()), capturingGroup);
        capturingGroup.getName().ifPresent(name -> this.capturingGroups.put((String)name, capturingGroup));
        return capturingGroup;
    }

    private RegexTree parseEscapedSequence(char opener, char closer, String expected, Function<EscapedSequenceDataHolder, RegexTree> builder) {
        SourceCharacter marker = this.characters.getCurrent();
        this.characters.moveNext();
        if (!this.characters.currentIs(opener)) {
            this.expected("'" + opener + "'");
            return this.characterTree(marker);
        }
        SourceCharacter openerChar = this.characters.getCurrent();
        boolean atLeastOneChar = false;
        do {
            this.characters.moveNext();
            if (this.characters.isAtEnd()) {
                this.expected(atLeastOneChar ? "'" + closer + "'" : expected);
                return this.characterTree(openerChar);
            }
            if (!atLeastOneChar && this.characters.currentIs(closer)) {
                this.expected(expected);
                return this.characterTree(openerChar);
            }
            atLeastOneChar = true;
        } while (!this.characters.currentIs(closer));
        SourceCharacter closerChar = this.characters.getCurrent();
        this.characters.moveNext();
        return builder.apply(new EscapedSequenceDataHolder(marker, openerChar, closerChar));
    }

    private RegexTree parseNumericalBackReference(SourceCharacter backslash) {
        SourceCharacter firstDigit;
        SourceCharacter lastDigit = firstDigit = this.characters.getCurrent();
        int referenceNumber = firstDigit.getCharacter() - 48;
        do {
            boolean matchingGroupExistsAtThisPoint;
            this.characters.moveNext();
            if (this.characters.isAtEnd()) continue;
            SourceCharacter currentChar = this.characters.getCurrent();
            char asChar = currentChar.getCharacter();
            int newReferenceNumber = referenceNumber * 10 + (asChar - 48);
            boolean bl = matchingGroupExistsAtThisPoint = newReferenceNumber < this.groupNumber;
            if (!RegexParser.isAsciiDigit(asChar) || !matchingGroupExistsAtThisPoint) break;
            lastDigit = currentChar;
            referenceNumber = newReferenceNumber;
        } while (!this.characters.isAtEnd());
        return this.collect(new BackReferenceTree(this.source, backslash, null, firstDigit, lastDigit, this.activeFlags));
    }

    private RegexTree parseOctalEscape(SourceCharacter backslash) {
        int newValue;
        int i;
        this.characters.moveNext();
        char byteValue = '\u0000';
        for (i = 0; i < 3 && RegexParser.isOctalDigit(this.characters.getCurrentChar()) && (newValue = byteValue * 8 + this.characters.getCurrentChar() - 48) <= 255; ++i) {
            byteValue = (char)newValue;
            this.characters.moveNext();
        }
        if (i == 0) {
            this.expected("octal digit");
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.characterTree(new SourceCharacter(this.source, range, byteValue, true));
    }

    private RegexTree parseBoundary(SourceCharacter backslash) {
        if (this.characters.currentIs("b{")) {
            return this.parseEscapedSequence('{', '}', "an Unicode extended grapheme cluster", dh -> new BoundaryTree(this.source, BoundaryTree.Type.UNICODE_EXTENDED_GRAPHEME_CLUSTER, backslash.getRange().merge(((EscapedSequenceDataHolder)dh).closer.getRange()), this.activeFlags));
        }
        SourceCharacter boundary = this.characters.getCurrent();
        this.characters.moveNext();
        return new BoundaryTree(this.source, BoundaryTree.Type.forKey(boundary.getCharacter()), backslash.getRange().merge(boundary.getRange()), this.activeFlags);
    }

    private CharacterClassTree parseCharacterClass() {
        SourceCharacter openingBracket = this.characters.getCurrent();
        this.characters.moveNext();
        boolean negated = false;
        if (this.characters.currentIs('^')) {
            this.characters.moveNext();
            negated = true;
        }
        CharacterClassElementTree contents = this.parseCharacterClassIntersection();
        if (this.characters.currentIs(']')) {
            this.characters.moveNext();
        } else {
            this.expected("']'");
        }
        IndexRange range = openingBracket.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CharacterClassTree(this.source, range, openingBracket, negated, contents, this.activeFlags);
    }

    private CharacterClassElementTree parseCharacterClassIntersection() {
        FlagSet characterClassFlags = this.activeFlags;
        ArrayList<CharacterClassElementTree> elements = new ArrayList<CharacterClassElementTree>();
        ArrayList<RegexToken> andOperators = new ArrayList<RegexToken>();
        elements.add(this.parseCharacterClassUnion(true));
        while (this.characters.currentIs("&&")) {
            SourceCharacter firstAnd = this.characters.getCurrent();
            this.characters.moveNext();
            SourceCharacter secondAnd = this.characters.getCurrent();
            this.characters.moveNext();
            andOperators.add(new RegexToken(this.source, firstAnd.getRange().merge(secondAnd.getRange())));
            elements.add(this.parseCharacterClassUnion(false));
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassIntersectionTree(this.source, range, items, andOperators, characterClassFlags));
    }

    private CharacterClassElementTree parseCharacterClassUnion(boolean isAtBeginning) {
        FlagSet characterClassFlags = this.activeFlags;
        ArrayList<CharacterClassElementTree> elements = new ArrayList<CharacterClassElementTree>();
        CharacterClassElementTree element = this.parseCharacterClassElement(isAtBeginning);
        while (element != null) {
            elements.add(element);
            element = this.parseCharacterClassElement(false);
        }
        if (elements.isEmpty()) {
            IndexRange range2 = new IndexRange(this.characters.getCurrentStartIndex(), this.characters.getCurrentStartIndex());
            return new CharacterClassUnionTree(this.source, range2, elements, characterClassFlags);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassUnionTree(this.source, range, items, characterClassFlags));
    }

    @CheckForNull
    private CharacterClassElementTree parseCharacterClassElement(boolean isAtBeginning) {
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readCharacter();
        }
        if (this.characters.isAtEnd() || this.characters.currentIs("&&")) {
            return null;
        }
        SourceCharacter startCharacter = this.characters.getCurrent();
        switch (startCharacter.getCharacter()) {
            case '\\': {
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.CHARACTER)) {
                    return this.parseCharacterRange((CharacterTree)escape);
                }
                if (escape instanceof CharacterClassElementTree) {
                    return (CharacterClassElementTree)((Object)escape);
                }
                this.errors.add(new SyntaxError(escape, "Invalid escape sequence inside character class"));
                return this.characterTree(new SourceCharacter(this.source, escape.getRange(), 'x'));
            }
            case '[': {
                return this.parseCharacterClass();
            }
            case ']': {
                if (isAtBeginning) {
                    this.characters.moveNext();
                    return this.parseCharacterRange(this.characterTree(startCharacter));
                }
                return null;
            }
        }
        this.characters.moveNext();
        return this.parseCharacterRange(this.characterTree(startCharacter));
    }

    private CharacterClassElementTree parseCharacterRange(CharacterTree startCharacter) {
        if (this.characters.currentIs('-') && !this.characters.isInQuotingMode()) {
            int lookAhead = this.characters.lookAhead(1);
            if (lookAhead == -1 || lookAhead == 93) {
                return startCharacter;
            }
            if (lookAhead == 92) {
                this.characters.moveNext();
                SourceCharacter backslash = this.characters.getCurrent();
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.CHARACTER)) {
                    return this.characterRange(startCharacter, (CharacterTree)escape);
                }
                this.expected("simple character", escape);
                return this.characterRange(startCharacter, this.characterTree(backslash));
            }
            this.characters.moveNext();
            SourceCharacter endCharacter = this.characters.getCurrent();
            this.characters.moveNext();
            return this.characterRange(startCharacter, this.characterTree(endCharacter));
        }
        return startCharacter;
    }

    private CharacterTree characterTree(SourceCharacter character) {
        char c1 = character.getCharacter();
        if (Character.isHighSurrogate(c1)) {
            char c2 = (char)this.characters.getCurrentChar();
            if (c2 == '\\') {
                this.characters.moveNext(2);
                int codePoint = this.parseFixedAmountOfHexDigits(4);
                IndexRange newRange = new IndexRange(character.getRange().getBeginningOffset(), character.getRange().getEndingOffset() + 1);
                return new CharacterTree(character.getSource(), newRange, Character.toCodePoint(c1, (char)codePoint), true, this.activeFlags);
            }
            if (Character.isLowSurrogate(c2)) {
                this.characters.moveNext();
                IndexRange newRange = new IndexRange(character.getRange().getBeginningOffset(), character.getRange().getEndingOffset() + 1);
                return new CharacterTree(character.getSource(), newRange, Character.toCodePoint(c1, c2), true, this.activeFlags);
            }
            LOG.warn("Couldn't parse '{}{}', two high surrogate characters in a row. Please check your encoding.", (Object)Character.valueOf(c1), (Object)Character.valueOf(c2));
        }
        return new CharacterTree(this.source, character.getRange(), character.getCharacter(), character.isEscapeSequence(), this.activeFlags);
    }

    private CharacterRangeTree characterRange(CharacterTree startCharacter, CharacterTree endCharacter) {
        IndexRange range = startCharacter.getRange().merge(endCharacter.getRange());
        CharacterRangeTree characterRange = new CharacterRangeTree(this.source, range, startCharacter, endCharacter, this.activeFlags);
        if (startCharacter.codePointOrUnit() > endCharacter.codePointOrUnit()) {
            this.errors.add(new SyntaxError(characterRange, "Illegal character range"));
        }
        return characterRange;
    }

    private void expected(String expectedToken, String actual) {
        this.error("Expected " + expectedToken + ", but found " + actual);
    }

    private void expected(String expectedToken, RegexSyntaxElement actual) {
        this.expected(expectedToken, "'" + actual.getText() + "'");
    }

    private void expected(String expectedToken) {
        String actual = this.characters.isAtEnd() ? "the end of the regex" : "'" + this.characters.getCurrent().getCharacter() + "'";
        this.expected(expectedToken, actual);
    }

    private void error(String message) {
        IndexRange range = this.characters.getCurrentIndexRange();
        RegexToken offendingToken = new RegexToken(this.source, range);
        this.errors.add(new SyntaxError(offendingToken, message));
    }

    private static <T extends RegexSyntaxElement> T combineTrees(List<T> elements, TreeConstructor<T> treeConstructor) {
        if (elements.size() == 1) {
            return (T)((RegexSyntaxElement)elements.get(0));
        }
        IndexRange range = ((RegexSyntaxElement)elements.get(0)).getRange().merge(((RegexSyntaxElement)elements.get(elements.size() - 1)).getRange());
        return (T)((RegexSyntaxElement)treeConstructor.construct(range, elements));
    }

    private static boolean isAsciiDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHexDigit(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static boolean isPlainTextCharacter(int c) {
        switch (c) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 123: 
            case 124: {
                return false;
            }
        }
        return true;
    }

    private static interface GroupConstructor {
        public GroupTree construct(IndexRange var1, RegexTree var2);
    }

    private static interface TreeConstructor<T> {
        public T construct(IndexRange var1, List<T> var2);
    }

    private static final class EscapedSequenceDataHolder {
        private final SourceCharacter marker;
        private final SourceCharacter opener;
        private final SourceCharacter closer;

        private EscapedSequenceDataHolder(SourceCharacter marker, SourceCharacter opener, SourceCharacter closer) {
            this.marker = marker;
            this.opener = opener;
            this.closer = closer;
        }
    }
}

