/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.EndOfCapturingGroupState;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class CapturingGroupTree
extends GroupTree {
    @Nullable
    private final String name;
    private final int groupNumber;

    public CapturingGroupTree(RegexSource source, IndexRange range, @Nullable String name, int groupNumber, RegexTree element, FlagSet activeFlags) {
        super(source, RegexTree.Kind.CAPTURING_GROUP, element, range, activeFlags);
        this.name = name;
        this.groupNumber = groupNumber;
        element.setContinuation(new EndOfCapturingGroupState(this, activeFlags));
    }

    @Override
    public void setContinuation(AutomatonState continuation) {
        this.setContinuation(continuation, null);
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitCapturingGroup(this);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    @Override
    @Nonnull
    public RegexTree getElement() {
        return this.element;
    }
}

