/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.Nonnull;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.CharacterClassElementTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class CharacterTree
extends RegexTree
implements CharacterClassElementTree {
    private final int codePoint;
    private final boolean isEscapeSequence;

    public CharacterTree(RegexSource source, IndexRange range, int codePoint, boolean isEscapeSequence, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.codePoint = codePoint;
        this.isEscapeSequence = isEscapeSequence;
    }

    public int codePointOrUnit() {
        return this.codePoint;
    }

    public boolean isEscapeSequence() {
        return this.isEscapeSequence;
    }

    public String characterAsString() {
        return String.valueOf(Character.toChars(this.codePoint));
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitCharacter(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.CHARACTER;
    }

    @Override
    @Nonnull
    public CharacterClassElementTree.Kind characterClassElementKind() {
        return CharacterClassElementTree.Kind.PLAIN_CHARACTER;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.CHARACTER;
    }
}

