/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.CharacterClassElementTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;
import org.sonar.java.regex.ast.SourceCharacter;

public class EscapedCharacterClassTree
extends RegexTree
implements CharacterClassElementTree {
    private final char type;
    @Nullable
    private final String property;

    private EscapedCharacterClassTree(RegexSource source, IndexRange range, SourceCharacter marker, @Nullable String property, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.type = marker.getCharacter();
        this.property = property;
    }

    public EscapedCharacterClassTree(RegexSource source, SourceCharacter backslash, SourceCharacter marker, SourceCharacter openingCurlyBrace, SourceCharacter closingCurlyBrace, FlagSet activeFlags) {
        this(source, backslash.getRange().merge(closingCurlyBrace.getRange()), marker, source.substringAt(new IndexRange(openingCurlyBrace.getRange().getBeginningOffset() + 1, closingCurlyBrace.getRange().getBeginningOffset())), activeFlags);
        if (!this.isProperty()) {
            throw new IllegalArgumentException("Only \\p can have a property string");
        }
    }

    public EscapedCharacterClassTree(RegexSource source, SourceCharacter backslash, SourceCharacter marker, FlagSet activeFlags) {
        this(source, backslash.getRange().merge(marker.getRange()), marker, null, activeFlags);
        if (this.isProperty()) {
            throw new IllegalArgumentException("\\p needs a property string");
        }
    }

    @Override
    @Nonnull
    public CharacterClassElementTree.Kind characterClassElementKind() {
        return CharacterClassElementTree.Kind.ESCAPED_CHARACTER_CLASS;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitEscapedCharacterClass(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.ESCAPED_CHARACTER_CLASS;
    }

    public boolean isNegation() {
        return Character.isUpperCase(this.type);
    }

    public boolean isProperty() {
        return Character.toLowerCase(this.getType()) == 'p';
    }

    @Nullable
    public String property() {
        return this.property;
    }

    public char getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.CHARACTER;
    }
}

