/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.EndOfLookaroundState;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.NegationState;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;
import org.sonar.java.regex.ast.StartOfLookBehindState;

public class LookAroundTree
extends GroupTree {
    private final Polarity polarity;
    private final Direction direction;
    private AutomatonState inner;

    public LookAroundTree(RegexSource source, IndexRange range, Polarity polarity, Direction direction, RegexTree element, FlagSet activeFlags) {
        super(source, RegexTree.Kind.LOOK_AROUND, element, range, activeFlags);
        this.polarity = polarity;
        this.direction = direction;
        element.setContinuation(new EndOfLookaroundState(this, activeFlags));
        AutomatonState automatonState = this.inner = polarity == Polarity.NEGATIVE ? new NegationState(element, activeFlags) : element;
        if (direction == Direction.BEHIND) {
            this.inner = new StartOfLookBehindState(this.inner, activeFlags);
        }
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitLookAround(this);
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Override
    @Nonnull
    public RegexTree getElement() {
        return this.element;
    }

    @Override
    public void setContinuation(AutomatonState continuation) {
        this.setContinuation(continuation, null);
    }

    @Override
    @Nonnull
    public List<AutomatonState> successors() {
        return Arrays.asList(this.inner, this.continuation());
    }

    public static LookAroundTree positiveLookAhead(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.AHEAD, element, activeFlags);
    }

    public static LookAroundTree negativeLookAhead(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.AHEAD, element, activeFlags);
    }

    public static LookAroundTree positiveLookBehind(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.BEHIND, element, activeFlags);
    }

    public static LookAroundTree negativeLookBehind(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.BEHIND, element, activeFlags);
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }

    public static enum Direction {
        AHEAD,
        BEHIND;

    }
}

