/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.java.regex.RegexSource;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.BranchState;
import org.sonar.java.regex.ast.EndOfRepetitionState;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class RepetitionTree
extends RegexTree {
    private final RegexTree element;
    private final Quantifier quantifier;

    public RepetitionTree(RegexSource source, IndexRange range, RegexTree element, Quantifier quantifier, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.element = element;
        this.quantifier = quantifier;
    }

    public RegexTree getElement() {
        return this.element;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public boolean isPossessive() {
        return this.quantifier.getModifier() == Quantifier.Modifier.POSSESSIVE;
    }

    public boolean isReluctant() {
        return this.quantifier.getModifier() == Quantifier.Modifier.RELUCTANT;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitRepetition(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.REPETITION;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Nonnull
    public List<AutomatonState> successors() {
        if (this.quantifier.getMinimumRepetitions() == 0) {
            Integer max = this.quantifier.getMaximumRepetitions();
            if (max != null && max == 0) {
                return Collections.singletonList(this.continuation());
            }
            return this.flipIfReluctant(this.element, this.continuation());
        }
        return Collections.singletonList(this.element);
    }

    @Override
    public void setContinuation(AutomatonState continuation) {
        continuation = new EndOfRepetitionState(this, continuation);
        super.setContinuation(continuation);
        int min = this.quantifier.getMinimumRepetitions();
        Integer max = this.quantifier.getMaximumRepetitions();
        if (max != null && max == 1) {
            this.element.setContinuation(continuation);
        } else if (min >= 1) {
            this.element.setContinuation(new BranchState(this, this.flipIfReluctant(this, continuation), this.activeFlags()));
        } else {
            this.element.setContinuation(this);
        }
    }

    private List<AutomatonState> flipIfReluctant(AutomatonState tree1, AutomatonState tree2) {
        if (this.quantifier.getModifier() == Quantifier.Modifier.RELUCTANT) {
            return Arrays.asList(tree2, tree1);
        }
        return Arrays.asList(tree1, tree2);
    }
}

