/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import java.util.Collections;
import java.util.List;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexToken;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class CharacterClassIntersectionTree
extends RegexTree {
    private final List<RegexTree> characterClasses;
    private final List<RegexToken> andOperators;

    public CharacterClassIntersectionTree(RegexSource source, IndexRange range, List<RegexTree> characterClasses, List<RegexToken> andOperators) {
        super(source, range);
        this.characterClasses = Collections.unmodifiableList(characterClasses);
        this.andOperators = Collections.unmodifiableList(andOperators);
    }

    public List<RegexTree> getCharacterClasses() {
        return this.characterClasses;
    }

    public List<RegexToken> getAndOperators() {
        return this.andOperators;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitCharacterClassIntersection(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.CHARACTER_CLASS_INTERSECTION;
    }
}

