/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.collections.PStack;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.checks.CustomUnclosedResourcesCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.StreamConsumedCheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class ProgramState {
    private static final Set<Class<? extends Constraint>> NON_DISPOSABLE_CONSTRAINTS = ImmutableSet.of(UnclosedResourcesCheck.ResourceConstraint.class, CustomUnclosedResourcesCheck.CustomResourceConstraint.class, LocksNotUnlockedCheck.LockConstraint.class, StreamConsumedCheck.StreamPipelineConstraint.class);
    private Set<RelationalSymbolicValue> knownRelations;
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState(PCollections.emptyMap(), PCollections.emptyMap(), PCollections.emptyMap().put(SymbolicValue.NULL_LITERAL, ConstraintsByDomain.empty().put(ObjectConstraint.NULL)).put(SymbolicValue.TRUE_LITERAL, ConstraintsByDomain.empty().put(BooleanConstraint.TRUE).put(ObjectConstraint.NOT_NULL)).put(SymbolicValue.FALSE_LITERAL, ConstraintsByDomain.empty().put(BooleanConstraint.FALSE).put(ObjectConstraint.NOT_NULL)), PCollections.emptyMap(), PCollections.emptyStack(), null);
    private final PMap<ProgramPoint, Integer> visitedPoints;
    private final PStack<SymbolicValueSymbol> stack;
    private final PMap<SymbolicValue, Integer> references;
    private SymbolicValue exitSymbolicValue;
    final PMap<Symbol, SymbolicValue> values;
    final PMap<Integer, SymbolicValue> valuesByIndex;
    final PMap<SymbolicValue, ConstraintsByDomain> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<Integer, SymbolicValue> valuesByIndex, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, ConstraintsByDomain> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValueSymbol> stack, SymbolicValue exitSymbolicValue) {
        this.values = values;
        this.valuesByIndex = valuesByIndex;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.constraintSize = 3;
    }

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, ConstraintsByDomain> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValueSymbol> stack, SymbolicValue exitSymbolicValue) {
        this.values = values;
        this.valuesByIndex = PCollections.emptyMap();
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.constraintSize = 3;
    }

    private ProgramState(ProgramState ps, PStack<SymbolicValueSymbol> newStack) {
        this.values = ps.values;
        this.valuesByIndex = ps.valuesByIndex;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = newStack;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, ConstraintsByDomain> newConstraints) {
        this.values = ps.values;
        this.valuesByIndex = ps.valuesByIndex;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = ps.stack;
    }

    public ProgramState stackValue(SymbolicValue sv) {
        return new ProgramState(this, this.stack.push(new SymbolicValueSymbol(sv, null)));
    }

    public ProgramState stackValue(SymbolicValue sv, @Nullable Symbol symbol) {
        return new ProgramState(this, this.stack.push(new SymbolicValueSymbol(sv, symbol)));
    }

    ProgramState clearStack() {
        return this.stack.isEmpty() ? this : new ProgramState(this, PCollections.emptyStack());
    }

    public Pop unstackValue(int nbElements) {
        if (nbElements == 0 || this.stack.isEmpty()) {
            return new Pop(this, Collections.emptyList());
        }
        PStack<SymbolicValueSymbol> newStack = this.stack;
        ArrayList<SymbolicValueSymbol> result = new ArrayList<SymbolicValueSymbol>();
        for (int i = 0; i < nbElements && !newStack.isEmpty(); ++i) {
            result.add(newStack.peek());
            newStack = newStack.pop();
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    @CheckForNull
    public SymbolicValue peekValue() {
        return this.stack.isEmpty() ? null : this.stack.peek().sv;
    }

    public SymbolicValueSymbol peekValueSymbol() {
        return this.stack.peek();
    }

    public SymbolicValue peekValue(int i) {
        return this.stack.peek((int)i).sv;
    }

    public List<SymbolicValue> peekValues(int n) {
        return this.peekValuesAndSymbols(n).stream().map(SymbolicValueSymbol::symbolicValue).collect(Collectors.toList());
    }

    public List<SymbolicValueSymbol> peekValuesAndSymbols(int n) {
        ImmutableList.Builder result = ImmutableList.builder();
        PStack<SymbolicValueSymbol> tmpStack = this.stack;
        for (int i = 0; i < n; ++i) {
            result.add((Object)tmpStack.peek());
            tmpStack = tmpStack.pop();
        }
        return result.build();
    }

    public int numberOfTimeVisited(ProgramPoint programPoint) {
        Integer count = this.visitedPoints.get(programPoint);
        return count == null ? 0 : count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.exitSymbolicValue, that.exitSymbolicValue) && Objects.equals(this.stack, that.stack);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "} { " + this.stack.toString() + " }";
    }

    public ProgramState addConstraintTransitively(SymbolicValue symbolicValue, Constraint constraint) {
        List transitiveSymbolicValues = this.knownRelations().stream().filter(rsv -> rsv.isEquality() && (rsv.getLeftOp() == symbolicValue || rsv.getRightOp() == symbolicValue)).map(rsv -> rsv.getLeftOp() == symbolicValue ? rsv.getRightOp() : rsv.getLeftOp()).collect(Collectors.toList());
        ProgramState ps = this.addConstraint(symbolicValue, constraint);
        for (SymbolicValue sv : transitiveSymbolicValues) {
            ps = ps.addConstraint(sv, constraint);
        }
        return ps;
    }

    public Set<RelationalSymbolicValue> knownRelations() {
        if (this.knownRelations == null) {
            this.knownRelations = Collections.unmodifiableSet(this.getValuesWithConstraints(BooleanConstraint.TRUE).stream().filter(RelationalSymbolicValue.class::isInstance).map(RelationalSymbolicValue.class::cast).collect(Collectors.toSet()));
        }
        return this.knownRelations;
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Constraint constraint) {
        Preconditions.checkState((!(symbolicValue instanceof RelationalSymbolicValue) || constraint != BooleanConstraint.FALSE ? 1 : 0) != 0, (String)"Relations stored in PS should always use TRUE constraint. SV: %s", (Object)symbolicValue);
        ConstraintsByDomain constraintsForSV = this.constraints.get(symbolicValue);
        if (constraintsForSV == null) {
            constraintsForSV = ConstraintsByDomain.empty();
        }
        return this.addConstraints(symbolicValue, constraintsForSV.put(constraint));
    }

    public ProgramState addConstraints(SymbolicValue symbolicValue, ConstraintsByDomain constraintsForSV) {
        PMap<SymbolicValue, ConstraintsByDomain> newConstraints = this.constraints.put(symbolicValue, constraintsForSV);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, newConstraints);
        }
        return this;
    }

    public ProgramState removeConstraintsOnDomain(SymbolicValue sv, Class<? extends Constraint> domain) {
        ConstraintsByDomain svConstraint = this.constraints.get(sv);
        if (svConstraint == null) {
            return this;
        }
        ConstraintsByDomain newConstraintForSv = svConstraint.remove(domain);
        if (newConstraintForSv.isEmpty()) {
            return new ProgramState(this, this.constraints.remove(sv));
        }
        return this.addConstraints(sv, newConstraintForSv);
    }

    @VisibleForTesting
    public ProgramState put(int index, SymbolicValue value) {
        SymbolicValue sv = this.valuesByIndex.get(index);
        if (sv == null || sv != value) {
            return new ProgramState(this.values, this.valuesByIndex.put(index, value), this.references, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
        }
        return this;
    }

    @VisibleForTesting
    public ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown() || ProgramState.isVolatileField(symbol)) {
            return this;
        }
        SymbolicValue oldValue = this.values.get(symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap<Symbol, SymbolicValue> newValues = this.values.put(symbol, value);
            return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
        }
        return this;
    }

    private static boolean isVolatileField(Symbol symbol) {
        return ProgramState.isField(symbol) && symbol.isVolatile();
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        Objects.requireNonNull(value);
        return givenReferences.put(sv, value - 1);
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        if (value == null) {
            return givenReferences.put(sv, 1);
        }
        return givenReferences.put(sv, value + 1);
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Constraint constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !NON_DISPOSABLE_CONSTRAINTS.contains(constraint.getClass()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable ConstraintsByDomain constraints) {
        if (!SymbolicValue.isDisposable(symbolicValue)) return false;
        if (constraints == null) return true;
        if (!NON_DISPOSABLE_CONSTRAINTS.stream().map(constraints::get).allMatch(Objects::isNull)) return false;
        return true;
    }

    private static boolean inStack(PStack<SymbolicValueSymbol> stack, SymbolicValue symbolicValue) {
        return stack.anyMatch(valueSymbol -> valueSymbol.sv.equals(symbolicValue) || valueSymbol.sv.references(symbolicValue));
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public ProgramState cleanupDeadSymbols(final Set<Symbol> liveVariables, final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<Symbol, SymbolicValue> {
            boolean newProgramState = false;
            PMap<Symbol, SymbolicValue> newValues;
            PMap<SymbolicValue, Integer> newReferences;
            PMap<SymbolicValue, ConstraintsByDomain> newConstraints;

            CleanAction() {
                this.newValues = ProgramState.this.values;
                this.newReferences = ProgramState.this.references;
                this.newConstraints = ProgramState.this.constraints;
            }

            @Override
            public void accept(Symbol symbol, SymbolicValue symbolicValue) {
                if (ProgramState.isLocalVariable(symbol) && !liveVariables.contains(symbol) && !protectedSymbolicValues.contains(symbolicValue)) {
                    this.newProgramState = true;
                    this.newValues = this.newValues.remove(symbol);
                    this.newReferences = ProgramState.decreaseReference(this.newReferences, symbolicValue);
                    if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, this.newConstraints.get(symbolicValue)) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newConstraints = this.newConstraints.remove(symbolicValue);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.values.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(cleanAction.newValues, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    public ProgramState cleanupConstraints(final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<SymbolicValue, ConstraintsByDomain> {
            boolean newProgramState = false;
            PMap<SymbolicValue, ConstraintsByDomain> newConstraints;
            PMap<SymbolicValue, Integer> newReferences;

            CleanAction() {
                this.newConstraints = ProgramState.this.constraints;
                this.newReferences = ProgramState.this.references;
            }

            @Override
            public void accept(SymbolicValue symbolicValue, ConstraintsByDomain constraintPMap) {
                constraintPMap.forEach((domain, constraint) -> {
                    if (!protectedSymbolicValues.contains(symbolicValue) && !ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, constraint) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newProgramState = true;
                        ConstraintsByDomain removed = this.newConstraints.get(symbolicValue).remove((Class<? extends Constraint>)domain);
                        this.newConstraints = removed.isEmpty() ? this.newConstraints.remove(symbolicValue) : this.newConstraints.put(symbolicValue, removed);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                });
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.constraints.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(this.values, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    ProgramState resetFieldValues(ConstraintManager constraintManager, boolean resetOnlyStaticFields) {
        ArrayList fields = new ArrayList();
        this.values.forEach((symbol, symbolicValue) -> {
            if (ProgramState.isField(symbol) && !symbol.isFinal() && (symbol.isStatic() || !resetOnlyStaticFields)) {
                fields.add(symbol);
            }
        });
        ProgramState newProgramState = this;
        for (Symbol field : fields) {
            newProgramState = newProgramState.put(field, constraintManager.createDefaultSymbolicValue());
        }
        return newProgramState;
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = references.get(symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.valuesByIndex, this.references, this.constraints, this.visitedPoints.put(programPoint, nbOfVisit), this.stack, this.exitSymbolicValue);
    }

    @Nullable
    public ConstraintsByDomain getConstraints(SymbolicValue sv) {
        return this.constraints.get(sv);
    }

    @CheckForNull
    public <T extends Constraint> T getConstraint(SymbolicValue sv, Class<T> domain) {
        ConstraintsByDomain classConstraintPMap = this.constraints.get(sv);
        if (classConstraintPMap == null) {
            return null;
        }
        return (T)classConstraintPMap.get(domain);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(int index) {
        return this.valuesByIndex.get(index);
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return this.values.get(symbol);
    }

    public List<SymbolicValue> getValuesWithConstraints(Constraint constraint) {
        ArrayList<SymbolicValue> result = new ArrayList<SymbolicValue>();
        this.constraints.forEach((symbolicValue, constraintByDomain) -> {
            Constraint find = constraintByDomain.get(constraint.getClass());
            if (constraint.equals(find)) {
                result.add((SymbolicValue)symbolicValue);
            }
        });
        return result;
    }

    public void storeExitValue() {
        this.exitSymbolicValue = this.peekValue();
    }

    @CheckForNull
    public SymbolicValue exitValue() {
        return this.exitSymbolicValue;
    }

    public boolean exitingOnRuntimeException() {
        if (this.exitSymbolicValue instanceof SymbolicValue.ExceptionalSymbolicValue) {
            Type exceptionType = ((SymbolicValue.ExceptionalSymbolicValue)this.exitSymbolicValue).exceptionType();
            return exceptionType == null || exceptionType.isUnknown() || exceptionType.isSubtypeOf("java.lang.RuntimeException");
        }
        return false;
    }

    Set<LearnedConstraint> learnedConstraints(ProgramState parent) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.constraints.forEach((sv, pmap) -> pmap.forEach((domain, c) -> {
            if (!c.equals(parent.getConstraint((SymbolicValue)sv, (Class)domain))) {
                result.add((Object)new LearnedConstraint((SymbolicValue)sv, (Constraint)c));
            }
        }));
        return result.build();
    }

    Set<LearnedAssociation> learnedAssociations(ProgramState parent) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.values.forEach((s, sv) -> {
            if (parent.getValue((Symbol)s) != sv) {
                result.add((Object)new LearnedAssociation((SymbolicValue)sv, (Symbol)s));
            }
        });
        return result.build();
    }

    public static class SymbolicValueSymbol {
        final SymbolicValue sv;
        @Nullable
        final Symbol symbol;

        public SymbolicValueSymbol(SymbolicValue sv, @Nullable Symbol symbol) {
            this.sv = sv;
            this.symbol = symbol;
        }

        public SymbolicValue symbolicValue() {
            return this.sv;
        }

        public Symbol symbol() {
            return this.symbol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymbolicValueSymbol that = (SymbolicValueSymbol)o;
            return Objects.equals(this.sv, that.sv);
        }

        public int hashCode() {
            return Objects.hash(this.sv);
        }

        public String toString() {
            return this.symbol == null ? this.sv.toString() : this.symbol.toString() + "->" + this.sv.toString();
        }
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;
        public final List<SymbolicValueSymbol> valuesAndSymbols;

        public Pop(ProgramState programState, List<SymbolicValueSymbol> result) {
            this.state = programState;
            this.values = result.stream().map(SymbolicValueSymbol::symbolicValue).collect(Collectors.toList());
            this.valuesAndSymbols = result;
        }
    }
}

