/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.xproc.ExceptionalYield;
import org.sonar.java.se.xproc.HappyPathYield;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;

public class MethodBehaviorJsonAdapter
implements JsonSerializer<MethodBehavior>,
JsonDeserializer<MethodBehavior> {
    private static final String JSON_THROWN_EXCEPTION = "exception";
    private static final String JSON_RESULT_CONSTRAINTS = "resultConstraint";
    private static final String JSON_RESULT_INDEX = "resultIndex";
    private static final String JSON_PARAMETERS_CONSTRAINTS = "parametersConstraints";
    private static final String JSON_DECLARED_EXCEPTIONS = "declaredExceptions";
    private static final String JSON_VARARGS = "varArgs";
    private static final String JSON_SIGNATURE = "signature";
    private static final String JSON_YIELDS = "yields";

    private MethodBehaviorJsonAdapter() {
    }

    public static Gson gson() {
        return new GsonBuilder().registerTypeAdapter(MethodBehavior.class, (Object)new MethodBehaviorJsonAdapter()).serializeNulls().setPrettyPrinting().create();
    }

    public MethodBehavior deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject jsonMB = (JsonObject)json;
        MethodBehavior mb = new MethodBehavior(jsonMB.get(JSON_SIGNATURE).getAsString(), jsonMB.get(JSON_VARARGS).getAsBoolean());
        ArrayList<String> declaredExceptions = new ArrayList<String>();
        jsonMB.get(JSON_DECLARED_EXCEPTIONS).getAsJsonArray().forEach(exception -> declaredExceptions.add(exception.getAsString()));
        mb.setDeclaredExceptions(declaredExceptions);
        jsonMB.get(JSON_YIELDS).getAsJsonArray().forEach(yield -> mb.addYield(MethodBehaviorJsonAdapter.yieldsFromJson(mb, (JsonObject)yield)));
        mb.completed();
        return mb;
    }

    private static MethodYield yieldsFromJson(MethodBehavior behavior, JsonObject methodYield) {
        MethodYield result;
        if (methodYield.has(JSON_THROWN_EXCEPTION)) {
            ExceptionalYield exceptionalYield = new ExceptionalYield(behavior);
            exceptionalYield.setExceptionType(methodYield.get(JSON_THROWN_EXCEPTION).getAsString());
            result = exceptionalYield;
        } else {
            HappyPathYield happyPathYield = new HappyPathYield(behavior);
            happyPathYield.setResult(methodYield.get(JSON_RESULT_INDEX).getAsInt(), MethodBehaviorJsonAdapter.constraintsByDomainFromJson(methodYield.get(JSON_RESULT_CONSTRAINTS)));
            result = happyPathYield;
        }
        result.parametersConstraints.addAll(MethodBehaviorJsonAdapter.constraintsFromJson(behavior.methodArity(), methodYield.get(JSON_PARAMETERS_CONSTRAINTS).getAsJsonArray()));
        return result;
    }

    private static List<ConstraintsByDomain> constraintsFromJson(int arity, JsonArray parameterConstraints) {
        ArrayList<ConstraintsByDomain> parametersConstraintsByDomain = new ArrayList<ConstraintsByDomain>(arity);
        parameterConstraints.forEach(constraint -> parametersConstraintsByDomain.add(MethodBehaviorJsonAdapter.constraintsByDomainFromJson(constraint)));
        return parametersConstraintsByDomain;
    }

    @CheckForNull
    private static ConstraintsByDomain constraintsByDomainFromJson(JsonElement jsonConstraintsByDomain) {
        if (jsonConstraintsByDomain.isJsonNull()) {
            return null;
        }
        JsonArray constraintsByDomainJsonArray = jsonConstraintsByDomain.getAsJsonArray();
        ConstraintsByDomain constraintsByDomain = ConstraintsByDomain.empty();
        for (int i = 0; i < constraintsByDomainJsonArray.size(); ++i) {
            Enum constraint;
            String constraintAsString;
            switch (constraintAsString = constraintsByDomainJsonArray.get(i).getAsString()) {
                case "NULL": 
                case "NOT_NULL": {
                    constraint = ObjectConstraint.valueOf(constraintAsString);
                    break;
                }
                case "TRUE": 
                case "FALSE": {
                    constraint = BooleanConstraint.valueOf(constraintAsString);
                    break;
                }
                default: {
                    String msg = String.format("Unsupported constraint \"%s\". Only \"TRUE\", \"FALSE\", \"NULL\", and \"NOT_NULL\" are supported.", constraintAsString);
                    throw new IllegalStateException(msg);
                }
            }
            constraintsByDomain = constraintsByDomain.put((Constraint)((Object)constraint));
        }
        return constraintsByDomain;
    }

    public JsonElement serialize(MethodBehavior src, Type typeOfSrc, JsonSerializationContext context) {
        Preconditions.checkState((boolean)src.isComplete());
        JsonObject mb = new JsonObject();
        mb.addProperty(JSON_SIGNATURE, src.signature());
        mb.addProperty(JSON_VARARGS, Boolean.valueOf(src.isMethodVarArgs()));
        List<String> declaredExceptions = src.getDeclaredExceptions();
        JsonArray jsonDeclaredExceptions = new JsonArray(declaredExceptions.size());
        declaredExceptions.forEach(arg_0 -> ((JsonArray)jsonDeclaredExceptions).add(arg_0));
        mb.add(JSON_DECLARED_EXCEPTIONS, (JsonElement)jsonDeclaredExceptions);
        List<MethodYield> yields = src.yields();
        JsonArray jsonYields = new JsonArray(yields.size());
        yields.forEach(my -> jsonYields.add(MethodBehaviorJsonAdapter.toJson(my, src.methodArity())));
        mb.add(JSON_YIELDS, (JsonElement)jsonYields);
        return mb;
    }

    private static JsonElement toJson(MethodYield methodYield, int arity) {
        JsonObject yield = new JsonObject();
        JsonArray jsonParameterConstraints = new JsonArray();
        for (int i = 0; i < arity; ++i) {
            jsonParameterConstraints.add(MethodBehaviorJsonAdapter.toJson(methodYield.parametersConstraints.get(i)));
        }
        yield.add(JSON_PARAMETERS_CONSTRAINTS, (JsonElement)jsonParameterConstraints);
        if (methodYield instanceof HappyPathYield) {
            HappyPathYield happyPathYield = (HappyPathYield)methodYield;
            yield.addProperty(JSON_RESULT_INDEX, (Number)happyPathYield.resultIndex());
            yield.add(JSON_RESULT_CONSTRAINTS, MethodBehaviorJsonAdapter.toJson(happyPathYield.resultConstraint()));
        } else if (methodYield instanceof ExceptionalYield) {
            ExceptionalYield exceptionalYield = (ExceptionalYield)methodYield;
            yield.addProperty(JSON_THROWN_EXCEPTION, exceptionalYield.getExceptionType());
        } else {
            throw new IllegalStateException("Hardcoded yields should only be HappyPathYield or ExceptionalYield.");
        }
        return yield;
    }

    private static JsonElement toJson(@Nullable ConstraintsByDomain constraints) {
        if (constraints == null) {
            return JsonNull.INSTANCE;
        }
        JsonArray jsonConstraints = new JsonArray();
        constraints.forEach((domain, constraint) -> {
            if (constraint instanceof ObjectConstraint || constraint instanceof BooleanConstraint) {
                jsonConstraints.add(constraint.toString());
            }
        });
        return jsonConstraints;
    }
}

