/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.AnalysisProgress;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JParserConfig;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaVersion;

public class JavaAstScanner {
    private static final Logger LOG = Loggers.get(JavaAstScanner.class);
    private static final String LOG_ERROR_STACKOVERFLOW = "A stack overflow error occurred while analyzing file: '%s'";
    private static final String LOG_ERROR_UNABLE_TO_PARSE_FILE = "Unable to parse source file : '%s'";
    private static final String LOG_WARN_MISCONFIGURED_JAVA_VERSION = "Analyzing '%s' file with misconfigured Java version. Please check that property '%s' is correctly configured (currently set to: %d) or exclude 'module-info.java' files from analysis. Such files only exist in Java9+ projects.";
    private final SonarComponents sonarComponents;
    private VisitorsBridge visitor;
    private boolean reportedMisconfiguredVersion = false;

    public JavaAstScanner(@Nullable SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
    }

    public List<File> getClasspath() {
        return this.visitor.getClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<? extends InputFile> inputFiles) {
        List filesNames = this.filterModuleInfo(inputFiles).collect(Collectors.toList());
        AnalysisProgress analysisProgress = new AnalysisProgress(filesNames.size());
        try {
            JParserConfig.Mode.FILE_BY_FILE.create(JParserConfig.effectiveJavaVersion(this.visitor.getJavaVersion()), this.visitor.getClasspath()).parse(filesNames, this::analysisCancelled, analysisProgress, (i, r) -> this.simpleScan((InputFile)i, (JParserConfig.Result)r, JavaAstScanner::cleanUpAst));
        }
        finally {
            this.endOfAnalysis();
        }
    }

    public <T extends InputFile> Stream<T> filterModuleInfo(Iterable<T> inputFiles) {
        JavaVersion javaVersion = this.visitor.getJavaVersion();
        return StreamSupport.stream(inputFiles.spliterator(), false).filter(file -> {
            if ("module-info.java".equals(file.filename()) && !javaVersion.isNotSet() && javaVersion.asInt() <= 8) {
                this.logMisconfiguredVersion("module-info.java", javaVersion);
                return false;
            }
            return true;
        });
    }

    public void endOfAnalysis() {
        this.visitor.endOfAnalysis();
        this.logUndefinedTypes();
    }

    private void logUndefinedTypes() {
        if (this.sonarComponents != null) {
            this.sonarComponents.logUndefinedTypes();
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    public void simpleScan(InputFile inputFile, JParserConfig.Result result, Consumer<JavaTree.CompilationUnitTreeImpl> cleanUp) {
        this.visitor.setCurrentFile(inputFile);
        try {
            JavaTree.CompilationUnitTreeImpl ast = result.get();
            this.visitor.visitFile(ast, this.sonarComponents != null && this.sonarComponents.fileCanBeSkipped(inputFile));
            this.collectUndefinedTypes(ast.sema.undefinedTypes());
            cleanUp.accept(ast);
        }
        catch (RecognitionException e) {
            this.checkInterrupted((Exception)((Object)e));
            LOG.error(String.format(LOG_ERROR_UNABLE_TO_PARSE_FILE, inputFile));
            LOG.error(e.getMessage());
            this.parseErrorWalkAndVisit(e, inputFile);
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            this.checkInterrupted(e);
            this.interruptIfFailFast(e, inputFile);
        }
        catch (StackOverflowError error) {
            LOG.error(String.format(LOG_ERROR_STACKOVERFLOW, inputFile), (Throwable)error);
            throw error;
        }
    }

    private static void cleanUpAst(JavaTree.CompilationUnitTreeImpl ast) {
        ast.sema.getEnvironmentCleaner().run();
    }

    private void collectUndefinedTypes(Set<JProblem> undefinedTypes) {
        if (this.sonarComponents != null) {
            this.sonarComponents.collectUndefinedTypes(undefinedTypes);
        }
    }

    void logMisconfiguredVersion(String inputFile, JavaVersion javaVersion) {
        if (!this.reportedMisconfiguredVersion) {
            LOG.warn(String.format(LOG_WARN_MISCONFIGURED_JAVA_VERSION, inputFile, "sonar.java.source", javaVersion.asInt()));
            this.reportedMisconfiguredVersion = true;
        }
    }

    private void interruptIfFailFast(Exception e, InputFile inputFile) {
        if (this.shouldFailAnalysis()) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e);
        }
    }

    public boolean shouldFailAnalysis() {
        return this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException();
    }

    public void checkInterrupted(Exception e) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException || cause instanceof CancellationException || this.analysisCancelled()) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, InputFile inputFile) {
        try {
            this.visitor.processRecognitionException(e, inputFile);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e2);
        }
    }

    private static String getAnalysisExceptionMessage(InputFile file) {
        return String.format("Unable to analyze file : '%s'", file);
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile file, VisitorsBridge visitorsBridge) {
        JavaAstScanner.scanSingleFileForTests(file, visitorsBridge, new JavaVersionImpl(), null);
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile inputFile, VisitorsBridge visitorsBridge, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents) {
        JavaAstScanner astScanner = new JavaAstScanner(sonarComponents);
        visitorsBridge.setJavaVersion(javaVersion);
        astScanner.setVisitorBridge(visitorsBridge);
        astScanner.scan(Collections.singleton(inputFile));
    }
}

