/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.reporting;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.java.Preconditions;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Range;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class AnalyzerMessage {
    private final JavaCheck check;
    private final InputComponent inputComponent;
    private final String message;
    private final int cost;
    @Nullable
    private TextSpan textSpan;
    public final List<List<AnalyzerMessage>> flows = new ArrayList<List<AnalyzerMessage>>();

    public AnalyzerMessage(JavaCheck check, InputComponent inputComponent, int line, String message, int cost) {
        this(check, inputComponent, line > 0 ? new TextSpan(line) : null, message, cost);
    }

    public AnalyzerMessage(JavaCheck check, InputComponent inputComponent, @Nullable TextSpan textSpan, String message, int cost) {
        this.check = check;
        this.inputComponent = inputComponent;
        this.message = message;
        this.cost = cost;
        this.textSpan = textSpan;
    }

    public JavaCheck getCheck() {
        return this.check;
    }

    public InputComponent getInputComponent() {
        return this.inputComponent;
    }

    @Nullable
    public TextSpan primaryLocation() {
        return this.textSpan;
    }

    @Nullable
    public Integer getLine() {
        return this.textSpan == null ? null : Integer.valueOf(this.textSpan.startLine);
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Double getCost() {
        return this.cost > 0 ? Double.valueOf(this.cost) : null;
    }

    public static TextSpan textSpanFor(Tree syntaxNode) {
        Tree nonEmptyTree = AnalyzerMessage.getNonEmptyTree(syntaxNode);
        return AnalyzerMessage.textSpanBetween(nonEmptyTree.firstToken(), nonEmptyTree.lastToken());
    }

    public static TextSpan textSpanBetween(Tree startTree, Tree endTree) {
        return AnalyzerMessage.textSpanBetween(startTree, true, endTree, true);
    }

    public static TextSpan textSpanBetween(Tree startTree, boolean includeStart, Tree endTree, boolean includeEnd) {
        TextSpan start = AnalyzerMessage.textSpanFor(startTree);
        TextSpan end = AnalyzerMessage.textSpanFor(endTree);
        return new TextSpan(includeStart ? start.startLine : start.endLine, includeStart ? start.startCharacter : start.endCharacter, includeEnd ? end.endLine : end.startLine, includeEnd ? end.endCharacter : end.startCharacter);
    }

    private static TextSpan textSpanBetween(SyntaxToken firstSyntaxToken, SyntaxToken lastSyntaxToken) {
        Range first = firstSyntaxToken.range();
        Range last = lastSyntaxToken.range();
        TextSpan location = new TextSpan(first.start().line(), first.start().columnOffset(), last.end().line(), last.end().columnOffset());
        AnalyzerMessage.checkLocation(firstSyntaxToken, location);
        return location;
    }

    private static void checkLocation(SyntaxToken firstSyntaxToken, TextSpan location) {
        Preconditions.checkState(!location.isEmpty(), "Invalid issue location: Text span is empty when trying reporting on (l:%s, c:%s).", firstSyntaxToken.range().start().line(), firstSyntaxToken.range().start().column());
    }

    private static Tree getNonEmptyTree(Tree tree) {
        if (tree.firstToken() != null) {
            return tree;
        }
        Tree parent = tree.parent();
        if (parent != null) {
            return AnalyzerMessage.getNonEmptyTree(parent);
        }
        throw new IllegalStateException("Trying to report on an empty tree with no parent");
    }

    public String toString() {
        return String.format("'%s' in %s:%d", this.message, this.inputComponent, this.getLine());
    }

    public static final class TextSpan {
        public final int startLine;
        public final int startCharacter;
        public final int endLine;
        public final int endCharacter;

        public TextSpan(int line) {
            this(line, -1, line, -1);
        }

        public TextSpan(int startLine, int startCharacter, int endLine, int endCharacter) {
            this.startLine = startLine;
            this.startCharacter = startCharacter;
            this.endLine = endLine;
            this.endCharacter = endCharacter;
        }

        public String toString() {
            return "(" + this.startLine + ":" + this.startCharacter + ")-(" + this.endLine + ":" + this.endCharacter + ")";
        }

        public boolean onLine() {
            return this.startCharacter == -1;
        }

        public boolean isEmpty() {
            return this.startLine == this.endLine && this.startCharacter == this.endCharacter;
        }

        public int hashCode() {
            int prime = 27;
            int result = 1;
            result = prime * result + this.startLine;
            result = prime * result + this.startCharacter;
            result = prime * result + this.endLine;
            result = prime * result + this.endCharacter;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TextSpan)) {
                return false;
            }
            TextSpan other = (TextSpan)obj;
            return this.startLine == other.startLine && this.startCharacter == other.startCharacter && this.endLine == other.endLine && this.endCharacter == other.endCharacter;
        }
    }
}

