/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.caching;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.caching.CacheReadException;
import org.sonar.plugins.java.api.caching.JavaReadCache;

public class JavaReadCacheImpl
implements JavaReadCache {
    private static final Logger LOG = Loggers.get(JavaReadCacheImpl.class);
    private ReadCache readCache;

    public JavaReadCacheImpl(ReadCache readCache) {
        this.readCache = readCache;
    }

    @Override
    public InputStream read(String key) {
        return this.readCache.read(key);
    }

    @Override
    @CheckForNull
    public byte[] readBytes(String key) {
        if (this.readCache.contains(key)) {
            byte[] byArray;
            block9: {
                InputStream in = this.read(key);
                try {
                    byArray = in.readAllBytes();
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CacheReadException(String.format("Unable to read data for key '%s'", key), e);
                    }
                }
                in.close();
            }
            return byArray;
        }
        LOG.trace(() -> String.format("Cache miss for key '%s'", key));
        return null;
    }

    @Override
    public boolean contains(String key) {
        return this.readCache.contains(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaReadCacheImpl that = (JavaReadCacheImpl)o;
        return Objects.equals(this.readCache, that.readCache);
    }

    public int hashCode() {
        return Objects.hash(this.readCache);
    }
}

