/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class ModifiersUtils {
    private ModifiersUtils() {
    }

    public static boolean hasModifier(ModifiersTree modifiers, Modifier expectedModifier) {
        return ModifiersUtils.findModifier(modifiers, expectedModifier).isPresent();
    }

    @CheckForNull
    public static ModifierKeywordTree getModifier(ModifiersTree modifiers, Modifier expectedModifier) {
        return ModifiersUtils.findModifier(modifiers, expectedModifier).orElse(null);
    }

    public static Optional<ModifierKeywordTree> findModifier(ModifiersTree modifiersTree, Modifier expectedModifier) {
        return modifiersTree.modifiers().stream().filter(modifierKeywordTree -> modifierKeywordTree.modifier() == expectedModifier).findAny();
    }

    public static List<AnnotationTree> getAnnotations(Tree tree) {
        if (tree.kind() == Tree.Kind.VARIABLE) {
            return ((VariableTree)tree).modifiers().annotations();
        }
        if (tree instanceof MethodTree) {
            return ((MethodTree)tree).modifiers().annotations();
        }
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).modifiers().annotations();
        }
        if (tree.kind() == Tree.Kind.PACKAGE) {
            return ((PackageDeclarationTree)tree).annotations();
        }
        return Collections.emptyList();
    }
}

