/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.java.regex.JavaAnalyzerRegexSource;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public interface RegexCheck
extends JavaCheck {

    public static class RegexIssueLocation {
        private static final String CONTINUATION_MESSAGE = "Continuing here";
        private final List<AnalyzerMessage.TextSpan> locations;
        private final String message;

        public RegexIssueLocation(RegexSyntaxElement tree, String message) {
            this.locations = ((JavaAnalyzerRegexSource)tree.getSource()).textSpansFor(tree.getRange());
            this.message = message;
        }

        public RegexIssueLocation(List<RegexSyntaxElement> trees, String message) {
            this.locations = RegexIssueLocation.textSpansFromRegexSyntaxElements(trees);
            this.message = message;
        }

        public static RegexIssueLocation fromCommonsRegexIssueLocation(org.sonarsource.analyzer.commons.regex.RegexIssueLocation location) {
            return new RegexIssueLocation(location.syntaxElements(), location.message());
        }

        private RegexIssueLocation(AnalyzerMessage.TextSpan location, String message) {
            this.locations = Collections.singletonList(location);
            this.message = message;
        }

        public List<AnalyzerMessage.TextSpan> locations() {
            return this.locations;
        }

        public String message() {
            return this.message;
        }

        public List<RegexIssueLocation> toSingleLocationItems() {
            if (this.locations.size() == 1) {
                return Collections.singletonList(this);
            }
            return Stream.concat(Stream.of(new RegexIssueLocation(this.locations.get(0), this.message)), this.locations.stream().skip(1L).map(loc -> new RegexIssueLocation((AnalyzerMessage.TextSpan)loc, CONTINUATION_MESSAGE))).collect(Collectors.toList());
        }

        private static List<AnalyzerMessage.TextSpan> textSpansFromRegexSyntaxElements(List<RegexSyntaxElement> trees) {
            JavaAnalyzerRegexSource source = (JavaAnalyzerRegexSource)trees.get(0).getSource();
            ArrayList<AnalyzerMessage.TextSpan> locations = new ArrayList<AnalyzerMessage.TextSpan>();
            IndexRange current = null;
            for (RegexSyntaxElement tree : trees) {
                if (current == null) {
                    current = tree.getRange();
                    continue;
                }
                if (tree.getRange().getBeginningOffset() == current.getEndingOffset()) {
                    current = new IndexRange(current.getBeginningOffset(), tree.getRange().getEndingOffset());
                    continue;
                }
                locations.addAll(source.textSpansFor(current));
                current = tree.getRange();
            }
            if (current != null) {
                locations.addAll(source.textSpansFor(current));
            }
            return locations;
        }
    }
}

