/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.model.DefaultInputFileScannerContext;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Sema;
import org.sonar.java.regex.RegexCache;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.FluentReporting;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.SourceMap;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class DefaultJavaFileScannerContext
extends DefaultInputFileScannerContext
implements JavaFileScannerContext,
RegexScannerContext,
FluentReporting {
    private final JavaTree.CompilationUnitTreeImpl tree;
    private final boolean semanticEnabled;
    private final ComplexityVisitor complexityVisitor;
    private final RegexCache regexCache;
    private final boolean fileParsed;
    private List<String> lines = null;
    private String content;

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed, boolean inAndroidContext, @Nullable CacheContext cacheContext) {
        super(sonarComponents, inputFile, javaVersion, inAndroidContext, cacheContext);
        this.tree = (JavaTree.CompilationUnitTreeImpl)tree;
        this.semanticEnabled = semanticModel != null;
        this.complexityVisitor = new ComplexityVisitor();
        this.regexCache = new RegexCache();
        this.fileParsed = fileParsed;
    }

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed, boolean inAndroidContext) {
        this(tree, inputFile, semanticModel, sonarComponents, javaVersion, fileParsed, inAndroidContext, null);
    }

    @Override
    public CompilationUnitTree getTree() {
        return this.tree;
    }

    @Override
    @Nullable
    public Object getSemanticModel() {
        if (!this.semanticEnabled) {
            return null;
        }
        return this.tree.sema;
    }

    @Override
    public boolean fileParsed() {
        return this.fileParsed;
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        this.reportIssue(javaCheck, tree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(RegexCheck regexCheck, RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        ArrayList<RegexCheck.RegexIssueLocation> completedSecondaries = new ArrayList<RegexCheck.RegexIssueLocation>();
        List<RegexCheck.RegexIssueLocation> mainLocations = new RegexCheck.RegexIssueLocation(regexTree, message).toSingleLocationItems();
        if (mainLocations.size() > 1) {
            mainLocations.subList(1, mainLocations.size()).stream().forEach(completedSecondaries::add);
        }
        completedSecondaries.addAll(secondaries);
        this.reportIssue(regexCheck, mainLocations.get(0).locations().get(0), message, cost, completedSecondaries);
    }

    @Override
    public void reportIssue(RegexCheck regexCheck, Tree javaSyntaxElement, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        this.reportIssue(regexCheck, AnalyzerMessage.textSpanFor(javaSyntaxElement), message, cost, secondaries);
    }

    private void reportIssue(RegexCheck regexCheck, AnalyzerMessage.TextSpan mainLocation, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        ArrayList secondariesAsFlows = new ArrayList();
        secondaries.stream().flatMap(regexIssueLocation -> regexIssueLocation.toSingleLocationItems().stream()).map(Collections::singletonList).forEach(secondariesAsFlows::add);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)regexCheck, (InputComponent)this.inputFile, mainLocation, message, cost != null ? cost : 0);
        DefaultJavaFileScannerContext.completeAnalyzerMessageWithFlows(analyzerMessage, secondariesAsFlows, ril -> ril.locations().get(0), RegexCheck.RegexIssueLocation::message);
        this.reportIssue(analyzerMessage);
    }

    @Override
    public RegexParseResult regexForLiterals(FlagSet initialFlags, LiteralTree ... stringLiterals) {
        return this.regexCache.getRegexForLiterals(initialFlags, stringLiterals);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssueWithFlow(javaCheck, syntaxNode, message, flows, cost);
    }

    @Override
    public void reportIssueWithFlow(JavaCheck javaCheck, Tree syntaxNode, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, syntaxNode, null, message, flows, cost));
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        this.reportIssue(javaCheck, startTree, endTree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, endTree, message, flows, cost));
    }

    @Override
    public List<String> getFileLines() {
        if (this.lines == null) {
            this.lines = Collections.unmodifiableList(this.sonarComponents.fileLines(this.inputFile));
        }
        return this.lines;
    }

    @Override
    public String getFileContent() {
        if (this.content == null) {
            this.content = this.sonarComponents.inputFileContents(this.inputFile);
        }
        return this.content;
    }

    public AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, String message) {
        return DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, null, message, Collections.emptyList(), null);
    }

    protected static AnalyzerMessage createAnalyzerMessage(InputFile inputFile, JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        AnalyzerMessage.TextSpan location = endTree != null ? AnalyzerMessage.textSpanBetween(startTree, endTree) : AnalyzerMessage.textSpanFor(startTree);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, (InputComponent)inputFile, location, message, cost != null ? cost : 0);
        DefaultJavaFileScannerContext.completeAnalyzerMessageWithFlows(analyzerMessage, flows, loc -> AnalyzerMessage.textSpanFor(loc.syntaxNode), loc -> loc.msg);
        return analyzerMessage;
    }

    private static <L> void completeAnalyzerMessageWithFlows(AnalyzerMessage analyzerMessage, Iterable<List<L>> flows, Function<L, AnalyzerMessage.TextSpan> flowItemLocationProdivder, Function<L, String> flowItemMessageProvider) {
        JavaCheck check = analyzerMessage.getCheck();
        InputComponent component = analyzerMessage.getInputComponent();
        for (List<L> flow : flows) {
            List sonarqubeFlow = flow.stream().map(l -> new AnalyzerMessage(check, component, (AnalyzerMessage.TextSpan)flowItemLocationProdivder.apply(l), (String)flowItemMessageProvider.apply(l), 0)).collect(Collectors.toList());
            analyzerMessage.flows.add(sonarqubeFlow);
        }
    }

    @Override
    public List<Tree> getComplexityNodes(Tree tree) {
        return this.complexityVisitor.getNodes(tree);
    }

    protected static void throwIfEndOfAnalysisCheck(JavaCheck javaCheck) {
        if (javaCheck instanceof EndOfAnalysis) {
            throw new UnsupportedOperationException("EndOfAnalysisCheck must only call reportIssue with AnalyzerMessage and must never pass a Tree reference.");
        }
    }

    @Override
    public Optional<SourceMap> sourceMap() {
        if (this.inputFile instanceof GeneratedFile) {
            return Optional.of(((GeneratedFile)this.inputFile).sourceMap());
        }
        return Optional.empty();
    }

    @Override
    public FluentReporting.JavaIssueBuilder newIssue() {
        return new InternalJavaIssueBuilder(this.inputFile, this.sonarComponents);
    }
}

