/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbol;
import org.sonar.java.model.JVariableSymbol;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.VariableTree;

final class JMethodSymbol
extends JSymbol
implements Symbol.MethodSymbol {
    private List<Type> parameterTypes;
    private List<Symbol> parameters;
    private Symbol.TypeSymbol returnType;
    private List<Type> thrownTypes;
    private List<Symbol.MethodSymbol> overriddenSymbols;
    private final String signature = this.methodBinding().getDeclaringClass().getBinaryName() + "#" + this.name() + ASTUtils.signature(this.methodBinding().getMethodDeclaration());

    JMethodSymbol(JSema sema, IMethodBinding methodBinding) {
        super(sema, (IBinding)methodBinding);
    }

    IMethodBinding methodBinding() {
        return (IMethodBinding)this.binding;
    }

    @Override
    public List<Type> parameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.sema.types(this.methodBinding().getParameterTypes());
        }
        return this.parameterTypes;
    }

    @Override
    public List<Symbol> declarationParameters() {
        if (this.parameters == null) {
            MethodTree declaration = this.declaration();
            if (declaration != null) {
                this.parameters = declaration.parameters().stream().map(VariableTree::symbol).collect(Collectors.toList());
            } else {
                this.parameters = new ArrayList<Symbol>();
                IMethodBinding methodBinding = this.methodBinding();
                ITypeBinding[] parameterTypeBindings = methodBinding.getParameterTypes();
                for (int i = 0; i < parameterTypeBindings.length; ++i) {
                    this.parameters.add(new JVariableSymbol.ParameterPlaceholderSymbol(i, this.sema, methodBinding.getMethodDeclaration(), parameterTypeBindings[i]));
                }
            }
        }
        return this.parameters;
    }

    @Override
    public Symbol.TypeSymbol returnType() {
        if (this.returnType == null) {
            ITypeBinding methodBindingReturnType = this.methodBinding().getReturnType();
            if (methodBindingReturnType == null) {
                return Symbols.unknownTypeSymbol;
            }
            this.returnType = this.sema.typeSymbol(methodBindingReturnType);
        }
        return this.returnType;
    }

    @Override
    public List<Type> thrownTypes() {
        if (this.thrownTypes == null) {
            this.thrownTypes = this.sema.types(this.methodBinding().getExceptionTypes());
        }
        return this.thrownTypes;
    }

    @Override
    public List<Symbol.MethodSymbol> overriddenSymbols() {
        if (this.overriddenSymbols == null) {
            this.overriddenSymbols = this.findOverriddenSymbols();
        }
        return this.overriddenSymbols;
    }

    private List<Symbol.MethodSymbol> findOverriddenSymbols() {
        LinkedHashSet<Symbol.MethodSymbol> results = new LinkedHashSet<Symbol.MethodSymbol>();
        IMethodBinding methodBinding = this.methodBinding();
        this.findOverridesInParentTypes(results, arg_0 -> ((IMethodBinding)methodBinding).overrides(arg_0), methodBinding.getDeclaringClass());
        return new ArrayList<Symbol.MethodSymbol>(results);
    }

    @VisibleForTesting
    void findOverridesInParentTypes(Collection<Symbol.MethodSymbol> accumulator, Predicate<IMethodBinding> overridesCondition, ITypeBinding type) {
        if (type.isInterface()) {
            this.findOverridesInTypes(accumulator, overridesCondition, this.sema.resolveType("java.lang.Object"));
        } else if (!"java.lang.Object".equals(type.getQualifiedName())) {
            this.findOverridesInTypes(accumulator, overridesCondition, type.getSuperclass());
        }
        this.findOverridesInTypes(accumulator, overridesCondition, type.getInterfaces());
    }

    private void findOverridesInTypes(Collection<Symbol.MethodSymbol> accumulator, Predicate<IMethodBinding> overridesCondition, ITypeBinding ... types) {
        for (ITypeBinding type : types) {
            if (type == null) continue;
            Stream.of(type.getDeclaredMethods()).filter(overridesCondition).findFirst().map(this.sema::methodSymbol).ifPresent(accumulator::add);
            this.findOverridesInParentTypes(accumulator, overridesCondition, type);
        }
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    @Nullable
    public MethodTree declaration() {
        return (MethodTree)super.declaration();
    }
}

