/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.reporting;

import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.location.Range;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class JavaTextEdit {
    private final AnalyzerMessage.TextSpan textSpan;
    private final String replacement;

    private JavaTextEdit(AnalyzerMessage.TextSpan textSpan, String replacement) {
        this.textSpan = textSpan;
        this.replacement = replacement;
    }

    public AnalyzerMessage.TextSpan getTextSpan() {
        return this.textSpan;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public static JavaTextEdit removeTree(Tree tree) {
        return JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanFor(tree));
    }

    public static JavaTextEdit removeTextSpan(AnalyzerMessage.TextSpan textSpan) {
        return new JavaTextEdit(textSpan, "");
    }

    public static JavaTextEdit removeBetweenTree(Tree startTree, Tree endTree) {
        return JavaTextEdit.replaceBetweenTree(startTree, endTree, "");
    }

    public static JavaTextEdit replaceTree(Tree tree, String replacement) {
        return JavaTextEdit.replaceTextSpan(AnalyzerMessage.textSpanFor(tree), replacement);
    }

    public static JavaTextEdit replaceBetweenTree(Tree startTree, Tree endTree, String replacement) {
        return JavaTextEdit.replaceTextSpan(AnalyzerMessage.textSpanBetween(startTree, endTree), replacement);
    }

    public static JavaTextEdit replaceTextSpan(AnalyzerMessage.TextSpan textSpan, String replacement) {
        return new JavaTextEdit(textSpan, replacement);
    }

    public static JavaTextEdit insertAfterTree(Tree tree, String addition) {
        SyntaxToken lastToken = tree.lastToken();
        if (lastToken == null) {
            throw new IllegalStateException("Trying to insert a quick fix after a Tree without token.");
        }
        Range lastRange = lastToken.range();
        return JavaTextEdit.insertAtPosition(lastRange.end().line(), lastRange.end().columnOffset(), addition);
    }

    public static JavaTextEdit insertBeforeTree(Tree tree, String addition) {
        SyntaxToken firstToken = tree.firstToken();
        if (firstToken == null) {
            throw new IllegalStateException("Trying to insert a quick fix before a Tree without token.");
        }
        Range firstRange = firstToken.range();
        return JavaTextEdit.insertAtPosition(firstRange.start().line(), firstRange.start().columnOffset(), addition);
    }

    public static JavaTextEdit insertAtPosition(int line, int column, String addition) {
        return new JavaTextEdit(JavaTextEdit.position(line, column), addition);
    }

    public static AnalyzerMessage.TextSpan position(int line, int column) {
        return JavaTextEdit.textSpan(line, column, line, column);
    }

    public static AnalyzerMessage.TextSpan textSpan(int startLine, int startColumn, int endLine, int endColumn) {
        return new AnalyzerMessage.TextSpan(startLine, startColumn, endLine, endColumn);
    }
}

