/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.sonar.java.model.JMethodSymbol;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JType;
import org.sonar.java.model.JTypeSymbol;
import org.sonar.java.model.JVariableSymbol;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.TypeParameterTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

public final class JUtils {
    private static final Map<String, String> WRAPPER_TO_PRIMITIVE = MapBuilder.newMap().put((Object)"java.lang.Byte", (Object)"byte").put((Object)"java.lang.Character", (Object)"char").put((Object)"java.lang.Short", (Object)"short").put((Object)"java.lang.Integer", (Object)"int").put((Object)"java.lang.Long", (Object)"long").put((Object)"java.lang.Float", (Object)"float").put((Object)"java.lang.Double", (Object)"double").put((Object)"java.lang.Boolean", (Object)"boolean").build();
    private static final Map<String, String> PRIMITIVE_TO_WRAPPER = MapBuilder.newMap().put((Object)"byte", (Object)"java.lang.Byte").put((Object)"char", (Object)"java.lang.Character").put((Object)"short", (Object)"java.lang.Short").put((Object)"int", (Object)"java.lang.Integer").put((Object)"long", (Object)"java.lang.Long").put((Object)"float", (Object)"java.lang.Float").put((Object)"double", (Object)"java.lang.Double").put((Object)"boolean", (Object)"java.lang.Boolean").build();

    private JUtils() {
    }

    public static boolean isPrimitiveWrapper(Type type) {
        return type.isClass() && WRAPPER_TO_PRIMITIVE.containsKey(type.fullyQualifiedName());
    }

    public static Type wrapTypeIfPrimitive(Type type) {
        Type wrapped = JUtils.primitiveWrapperType(type);
        return Objects.requireNonNullElse(wrapped, type);
    }

    @Nullable
    public static Type primitiveWrapperType(Type type) {
        String name = PRIMITIVE_TO_WRAPPER.get(type.fullyQualifiedName());
        if (name == null) {
            return null;
        }
        JSema sema = ((JType)type).sema;
        return sema.type(sema.resolveType(name));
    }

    @Nullable
    public static Type primitiveType(Type type) {
        String name = WRAPPER_TO_PRIMITIVE.get(type.fullyQualifiedName());
        if (name == null) {
            return null;
        }
        JSema sema = ((JType)type).sema;
        return sema.type(sema.resolveType(name));
    }

    public static boolean isNullType(Type type) {
        return !type.isUnknown() && ((JType)type).typeBinding.isNullType();
    }

    public static boolean isIntersectionType(Type type) {
        return !type.isUnknown() && ((JType)type).typeBinding.isIntersectionType();
    }

    public static boolean isTypeVar(Type type) {
        return !type.isUnknown() && ((JType)type).typeBinding.isTypeVariable();
    }

    public static boolean isAnnotation(Symbol.TypeSymbol typeSymbol) {
        return !typeSymbol.isUnknown() && ((JTypeSymbol)typeSymbol).typeBinding().isAnnotation();
    }

    public static boolean isEffectivelyFinal(Symbol.VariableSymbol variableSymbol) {
        return variableSymbol instanceof JVariableSymbol && ((IVariableBinding)((JVariableSymbol)variableSymbol).binding).isEffectivelyFinal();
    }

    public static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public static boolean isParameter(Symbol symbol) {
        if (symbol instanceof JTypeSymbol.SpecialField) {
            return false;
        }
        return symbol.isVariableSymbol() && (symbol instanceof JVariableSymbol.ParameterPlaceholderSymbol || ((IVariableBinding)((JVariableSymbol)symbol).binding).isParameter());
    }

    public static Optional<Object> constantValue(Symbol.VariableSymbol symbol) {
        if (!(symbol.isFinal() && symbol.isStatic() && symbol instanceof JVariableSymbol)) {
            return Optional.empty();
        }
        Object c = ((IVariableBinding)((JVariableSymbol)symbol).binding).getConstantValue();
        if (c instanceof Short) {
            c = (int)((Short)c).shortValue();
        } else if (c instanceof Byte) {
            c = (int)((Byte)c).byteValue();
        } else if (c instanceof Character) {
            c = (int)((Character)c).charValue();
        }
        return Optional.ofNullable(c);
    }

    public static Set<Type> superTypes(Symbol.TypeSymbol typeSymbol) {
        if (typeSymbol.isUnknown()) {
            return Collections.emptySet();
        }
        HashSet<Type> result = new HashSet<Type>();
        JUtils.collectSuperTypes(result, ((JTypeSymbol)typeSymbol).sema, ((JTypeSymbol)typeSymbol).typeBinding());
        return result;
    }

    private static void collectSuperTypes(Set<Type> result, JSema sema, ITypeBinding typeBinding) {
        ITypeBinding s = typeBinding.getSuperclass();
        if (s != null) {
            result.add(sema.type(s));
            JUtils.collectSuperTypes(result, sema, s);
        }
        for (ITypeBinding i : typeBinding.getInterfaces()) {
            result.add(sema.type(i));
            JUtils.collectSuperTypes(result, sema, i);
        }
    }

    public static Symbol.TypeSymbol outermostClass(Symbol.TypeSymbol typeSymbol) {
        Symbol symbol = typeSymbol;
        Symbol.TypeSymbol result = null;
        while (!symbol.isPackageSymbol()) {
            result = symbol;
            symbol = symbol.owner();
        }
        return result;
    }

    public static Symbol getPackage(Symbol symbol) {
        while (!symbol.isPackageSymbol()) {
            symbol = symbol.owner();
        }
        return symbol;
    }

    public static boolean isVarArgsMethod(Symbol.MethodSymbol method) {
        return !method.isUnknown() && ((JMethodSymbol)method).methodBinding().isVarargs();
    }

    public static boolean isSynchronizedMethod(Symbol.MethodSymbol method) {
        return !method.isUnknown() && Modifier.isSynchronized((int)((JMethodSymbol)method).binding.getModifiers());
    }

    public static boolean isNativeMethod(Symbol.MethodSymbol method) {
        return !method.isUnknown() && Modifier.isNative((int)((JMethodSymbol)method).binding.getModifiers());
    }

    public static boolean isDefaultMethod(Symbol.MethodSymbol method) {
        return !method.isUnknown() && Modifier.isDefault((int)((JMethodSymbol)method).binding.getModifiers());
    }

    @Nullable
    public static Object defaultValue(Symbol.MethodSymbol method) {
        if (method.isUnknown()) {
            return null;
        }
        return ((JMethodSymbol)method).methodBinding().getDefaultValue();
    }

    public static boolean isOverridable(Symbol.MethodSymbol method) {
        return !method.isUnknown() && !method.isPrivate() && !method.isStatic() && !method.isFinal() && !method.owner().isFinal();
    }

    public static boolean isParametrizedMethod(Symbol.MethodSymbol method) {
        if (method.isUnknown()) {
            return false;
        }
        return ((JMethodSymbol)method).methodBinding().isParameterizedMethod() || ((JMethodSymbol)method).methodBinding().isGenericMethod();
    }

    public static boolean isRawType(Type type) {
        if (type.isUnknown()) {
            return false;
        }
        JType t = (JType)type;
        return t.typeBinding.isRawType();
    }

    public static Type declaringType(Type type) {
        if (type.isUnknown()) {
            return type;
        }
        JType t = (JType)type;
        return t.sema.type(t.typeBinding.getTypeDeclaration());
    }

    public static Set<Type> directSuperTypes(Type type) {
        if (type.isUnknown()) {
            return Collections.emptySet();
        }
        HashSet<Type> result = new HashSet<Type>();
        JType t = (JType)type;
        ITypeBinding superclass = t.typeBinding.getSuperclass();
        if (superclass != null) {
            result.add(t.sema.type(superclass));
        }
        for (ITypeBinding i : t.typeBinding.getInterfaces()) {
            result.add(t.sema.type(i));
        }
        return result;
    }

    @Nullable
    public static Symbol enclosingClass(Tree t) {
        while (t != null) {
            if (t.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE)) {
                return ((ClassTree)t).symbol();
            }
            t = t.parent();
        }
        return null;
    }

    @Nullable
    public static Symbol importTreeSymbol(ImportTree tree) {
        return ((JavaTree.ImportTreeImpl)tree).symbol();
    }

    public static Symbol typeParameterTreeSymbol(TypeParameterTree tree) {
        return ((TypeParameterTreeImpl)tree).symbol();
    }

    public static SymbolMetadata parameterAnnotations(Symbol.MethodSymbol method, int param) {
        if (method.isUnknown()) {
            return Symbols.EMPTY_METADATA;
        }
        return method.declarationParameters().get(param).metadata();
    }

    public static boolean hasUnknownTypeInHierarchy(Symbol.MethodSymbol symbol) {
        Symbol owner = symbol.owner();
        if (owner == null || !owner.isTypeSymbol()) {
            return true;
        }
        return JUtils.hasUnknownTypeInHierarchy((Symbol.TypeSymbol)owner);
    }

    public static boolean hasUnknownTypeInHierarchy(Symbol.TypeSymbol typeSymbol) {
        if (typeSymbol.isUnknown()) {
            return true;
        }
        if (typeSymbol.interfaces().stream().map(Type::symbol).anyMatch(JUtils::hasUnknownTypeInHierarchy)) {
            return true;
        }
        Type superClass = typeSymbol.superClass();
        if (superClass == null) {
            return false;
        }
        return JUtils.hasUnknownTypeInHierarchy(superClass.symbol());
    }
}

