/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.java.SonarComponents;
import org.sonar.java.caching.CacheContextImpl;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.ModuleScannerContext;
import org.sonar.plugins.java.api.caching.CacheContext;

public class DefaultModuleScannerContext
implements ModuleScannerContext {
    protected final SonarComponents sonarComponents;
    protected final JavaVersion javaVersion;
    protected final boolean inAndroidContext;
    protected final CacheContext cacheContext;

    public DefaultModuleScannerContext(@Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean inAndroidContext, @Nullable CacheContext cacheContext) {
        this.sonarComponents = sonarComponents;
        this.javaVersion = javaVersion;
        this.inAndroidContext = inAndroidContext;
        this.cacheContext = cacheContext != null ? cacheContext : CacheContextImpl.of(sonarComponents != null ? sonarComponents.context() : null);
    }

    @Override
    public void addIssueOnProject(JavaCheck check, String message) {
        this.sonarComponents.addIssue(this.getProject(), check, -1, message, 0);
    }

    @Override
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean inAndroidContext() {
        return this.inAndroidContext;
    }

    @Override
    public InputComponent getProject() {
        return this.sonarComponents.project();
    }

    @Override
    public File getWorkingDirectory() {
        return this.sonarComponents.projectLevelWorkDir();
    }

    @Override
    public CacheContext getCacheContext() {
        return this.cacheContext;
    }

    public void reportIssue(AnalyzerMessage message) {
        this.sonarComponents.reportIssue(message);
    }

    @Override
    public File getRootProjectWorkingDirectory() {
        return this.sonarComponents.projectLevelWorkDir();
    }

    @Override
    public String getModuleKey() {
        return this.sonarComponents.getModuleKey();
    }
}

