/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbol;
import org.sonar.java.model.JSymbolMetadata;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.VariableTree;

final class JVariableSymbol
extends JSymbol
implements Symbol.VariableSymbol {
    private boolean constantValueComputed = false;
    private Optional<Object> constantValue;

    JVariableSymbol(JSema sema, IVariableBinding variableBinding) {
        super(sema, (IBinding)variableBinding);
    }

    @Override
    @Nullable
    public VariableTree declaration() {
        return (VariableTree)super.declaration();
    }

    @Override
    public boolean isEffectivelyFinal() {
        return ((IVariableBinding)this.binding).isEffectivelyFinal();
    }

    @Override
    public Optional<Object> constantValue() {
        if (!this.constantValueComputed) {
            this.constantValueComputed = true;
            if (!this.isFinal() || !this.isStatic()) {
                this.constantValue = Optional.empty();
            } else {
                Object c = ((IVariableBinding)this.binding).getConstantValue();
                if (c instanceof Short) {
                    c = (int)((Short)c).shortValue();
                } else if (c instanceof Byte) {
                    c = (int)((Byte)c).byteValue();
                } else if (c instanceof Character) {
                    c = (int)((Character)c).charValue();
                }
                this.constantValue = Optional.ofNullable(c);
            }
        }
        return this.constantValue;
    }

    @Override
    public boolean isLocalVariable() {
        Symbol owner = this.owner();
        return owner != null && owner.isMethodSymbol();
    }

    @Override
    public boolean isParameter() {
        return ((IVariableBinding)this.binding).isParameter();
    }

    static class ParameterPlaceholderSymbol
    extends Symbols.DefaultSymbol
    implements Symbol.VariableSymbol {
        private final String name;
        private final Symbol owner;
        private final Type type;
        private final JSymbolMetadata metadata;

        ParameterPlaceholderSymbol(int index, JSema sema, IMethodBinding owner, ITypeBinding typeBinding) {
            this.name = "arg" + index;
            this.owner = sema.methodSymbol(owner);
            this.type = sema.type(typeBinding);
            this.metadata = new JSymbolMetadata(sema, this, typeBinding.getTypeAnnotations(), owner.getParameterAnnotations(index));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Symbol owner() {
            return this.owner;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public Symbol.TypeSymbol enclosingClass() {
            return this.owner.enclosingClass();
        }

        @Override
        public List<IdentifierTree> usages() {
            return Collections.emptyList();
        }

        @Override
        public VariableTree declaration() {
            return null;
        }

        @Override
        public boolean isEffectivelyFinal() {
            return false;
        }

        @Override
        public Optional<Object> constantValue() {
            return Optional.empty();
        }

        @Override
        public boolean isLocalVariable() {
            return false;
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public SymbolMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean isVariableSymbol() {
            return true;
        }

        @Override
        public boolean isFinal() {
            return false;
        }
    }
}

