/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.InputFileUtils;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.SmapFile;
import org.sonar.plugins.java.api.SourceMap;
import org.sonar.plugins.java.api.tree.Tree;

public class GeneratedFile
implements InputFile {
    private final Path path;
    private String contents = null;
    private String md5 = null;
    @VisibleForTesting
    final List<SmapFile> smapFiles = new ArrayList<SmapFile>();
    private SourceMap sourceMap;

    public GeneratedFile(Path path) {
        this.path = path;
    }

    public SourceMap sourceMap() {
        if (this.sourceMap == null) {
            this.sourceMap = new SourceMapImpl();
        }
        return this.sourceMap;
    }

    public void addSmap(SmapFile smap) {
        this.smapFiles.add(smap);
    }

    public String relativePath() {
        return this.path.toString();
    }

    public String absolutePath() {
        return this.path.toAbsolutePath().toString();
    }

    public File file() {
        return this.path.toFile();
    }

    public Path path() {
        return this.path;
    }

    public URI uri() {
        return this.path.toUri();
    }

    public String filename() {
        return this.path.getFileName().toString();
    }

    @CheckForNull
    public String language() {
        return "java";
    }

    public InputFile.Type type() {
        throw new UnsupportedOperationException();
    }

    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public String contents() throws IOException {
        if (this.contents == null) {
            this.contents = new String(Files.readAllBytes(this.path), this.charset());
        }
        return this.contents;
    }

    public String md5Hash() {
        if (this.md5 == null) {
            this.md5 = InputFileUtils.md5Hash(this);
        }
        return this.md5;
    }

    public InputFile.Status status() {
        throw new UnsupportedOperationException();
    }

    public int lines() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return false;
    }

    public TextPointer newPointer(int line, int lineOffset) {
        throw new UnsupportedOperationException();
    }

    public TextRange newRange(TextPointer start, TextPointer end) {
        throw new UnsupportedOperationException();
    }

    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        throw new UnsupportedOperationException();
    }

    public TextRange selectLine(int line) {
        throw new UnsupportedOperationException();
    }

    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    public String key() {
        return this.absolutePath();
    }

    public boolean isFile() {
        return Files.isRegularFile(this.path, new LinkOption[0]);
    }

    public String toString() {
        return this.path.toString();
    }

    class SourceMapImpl
    implements SourceMap {
        final Map<Integer, SourceMap.Location> lines = new HashMap<Integer, SourceMap.Location>();

        private SourceMapImpl() {
            for (SmapFile sm : GeneratedFile.this.smapFiles) {
                for (SmapFile.LineInfo lineInfo : sm.getLineSection()) {
                    sm.getInputFile(lineInfo.lineFileId).ifPresent(inputFile -> this.processLineInfo((InputFile)inputFile, lineInfo));
                }
            }
        }

        private void processLineInfo(InputFile inputFile, SmapFile.LineInfo lineInfo) {
            for (int i = 0; i < lineInfo.repeatCount; ++i) {
                int inputLine = lineInfo.inputStartLine + i;
                LocationImpl location = new LocationImpl(inputFile, inputLine, inputLine);
                int outputStart = lineInfo.outputStartLine + i * lineInfo.outputLineIncrement;
                int outputEnd = lineInfo.outputStartLine + (i + 1) * lineInfo.outputLineIncrement - 1;
                outputEnd = Math.max(outputStart, outputEnd);
                for (int j = outputStart; j <= outputEnd; ++j) {
                    this.lines.merge(j, location, (x$0, x$1) -> LocationImpl.mergeLocations(x$0, x$1));
                }
            }
        }

        @Override
        public Optional<SourceMap.Location> sourceMapLocationFor(Tree tree) {
            return this.getLocation(LineUtils.startLine(tree.firstToken()), LineUtils.startLine(tree.lastToken()));
        }

        @VisibleForTesting
        Optional<SourceMap.Location> getLocation(int startLine, int endLine) {
            SourceMap.Location startLoc = this.lines.get(startLine);
            SourceMap.Location endLoc = this.lines.get(endLine);
            if (startLoc == null || endLoc == null) {
                return Optional.empty();
            }
            return Optional.of(new LocationImpl(startLoc.file(), startLoc.startLine(), endLoc.endLine()));
        }
    }

    private static final class LocationImpl
    implements SourceMap.Location {
        private final InputFile inputFile;
        private final int startLine;
        private final int endLine;

        private LocationImpl(InputFile inputFile, int startLine, int endLine) {
            this.inputFile = inputFile;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @Override
        public InputFile file() {
            return this.inputFile;
        }

        @Override
        public int startLine() {
            return this.startLine;
        }

        @Override
        public int endLine() {
            return this.endLine;
        }

        private static SourceMap.Location mergeLocations(SourceMap.Location loc1, SourceMap.Location loc2) {
            return new LocationImpl(loc1.file(), Math.min(loc1.startLine(), loc2.startLine()), Math.max(loc1.endLine(), loc2.endLine()));
        }
    }
}

