/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.collections;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @Nullable
    public static <T> T getFirst(Iterable<T> iterable, @Nullable T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static int size(Iterable<?> iterable) {
        int n;
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            n = collection.size();
        } else {
            n = CollectionUtils.size(iterable.iterator());
        }
        return n;
    }

    private static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

