/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.Preconditions;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.cfg.ControlFlowGraph;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.GuardedPatternTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.NullPatternTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PatternInstanceOfTree;
import org.sonar.plugins.java.api.tree.PatternTree;
import org.sonar.plugins.java.api.tree.RecordPatternTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypePatternTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.YieldStatementTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class CFG
implements ControlFlowGraph {
    private static final Logger LOG = LoggerFactory.getLogger(CFG.class);
    private final boolean ignoreBreakAndContinue;
    @Nullable
    private Symbol.MethodSymbol methodSymbol;
    private Block currentBlock;
    private boolean hasCompleteSemantic = true;
    private final List<Block> blocks = new ArrayList<Block>();
    private final Deque<Block> breakTargets = new LinkedList<Block>();
    private final Deque<Block> continueTargets = new LinkedList<Block>();
    private final Deque<Block> exitBlocks = new LinkedList<Block>();
    private final Deque<TryStatement> enclosingTry = new LinkedList<TryStatement>();
    private final Deque<Boolean> enclosedByCatch = new LinkedList<Boolean>();
    private final TryStatement outerTry;
    private String pendingLabel = null;
    private Map<String, Block> labelsBreakTarget = new HashMap<String, Block>();
    private Map<String, Block> labelsContinueTarget = new HashMap<String, Block>();

    private CFG(List<? extends Tree> trees, @Nullable MethodTree tree, boolean ignoreBreakAndContinue) {
        if (tree != null) {
            this.methodSymbol = tree.symbol();
            this.checkSymbolSemantic(this.methodSymbol, "method definition", tree.simpleName().identifierToken());
        }
        this.ignoreBreakAndContinue = ignoreBreakAndContinue;
        this.exitBlocks.add(this.createBlock());
        this.currentBlock = this.createBlock(this.exitBlock());
        this.outerTry = new TryStatement();
        this.enclosingTry.add(this.outerTry);
        this.enclosedByCatch.push(false);
        this.build(trees);
        this.prune();
        CFG.computePredecessors(this.blocks);
    }

    @Override
    public boolean hasCompleteSemantic() {
        return this.hasCompleteSemantic;
    }

    private void checkIdentifierSemantic(IdentifierTree tree) {
        this.checkSymbolSemantic(tree.symbol(), "unknown identifier", tree.identifierToken());
    }

    private void checkSymbolSemantic(@Nullable Symbol symbol, String reason, @Nullable SyntaxToken location) {
        if (symbol != null) {
            if (symbol.isUnknown()) {
                this.markSemanticAsIncomplete(reason, location);
            } else if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol method = (Symbol.MethodSymbol)symbol;
                if (method.returnType().isUnknown()) {
                    this.markSemanticAsIncomplete("unknown return type", location);
                } else if (method.parameterTypes().stream().anyMatch(Type::isUnknown)) {
                    this.markSemanticAsIncomplete("unknown parameter type", location);
                }
            }
        }
    }

    private Type checkTypeSemantic(Type type, String reason, @Nullable SyntaxToken location) {
        if (type.isUnknown()) {
            this.markSemanticAsIncomplete(reason, location);
        }
        return type;
    }

    private void markSemanticAsIncomplete(String reason, @Nullable SyntaxToken location) {
        if (this.hasCompleteSemantic) {
            this.hasCompleteSemantic = false;
            if (LOG.isDebugEnabled()) {
                StringBuilder logMessage = new StringBuilder();
                logMessage.append("Incomplete Semantic, ").append(reason);
                if (location != null) {
                    logMessage.append(" '").append(location.text()).append("'");
                    Position position = location.range().start();
                    logMessage.append(" line ").append(position.line()).append(" col ").append(position.column());
                }
                LOG.debug(logMessage.toString());
            }
        }
    }

    @Override
    public Block exitBlock() {
        return this.exitBlocks.peek();
    }

    @Override
    @Nullable
    public Symbol.MethodSymbol methodSymbol() {
        return this.methodSymbol;
    }

    @Override
    public Block entryBlock() {
        return this.currentBlock;
    }

    public List<Block> blocks() {
        return ListUtils.reverse(this.blocks);
    }

    public List<Block> reversedBlocks() {
        return this.blocks;
    }

    private static void computePredecessors(List<Block> blocks) {
        for (Block b : blocks) {
            for (Block successor : b.successors) {
                successor.predecessors.add(b);
            }
            for (Block successor : b.exceptions) {
                successor.predecessors.add(b);
            }
        }
        CFG.cleanupUnfeasibleBreakPaths(blocks);
    }

    private static void cleanupUnfeasibleBreakPaths(List<Block> blocks) {
        for (Block block : blocks) {
            Set happyPathPredecessor = block.predecessors.stream().filter(p -> !p.exceptions.contains(block)).collect(Collectors.toSet());
            if (!block.isFinallyBlock || happyPathPredecessor.size() != 1) continue;
            Block pred = (Block)happyPathPredecessor.iterator().next();
            if (pred.terminator == null || !pred.terminator.is(Tree.Kind.BREAK_STATEMENT)) continue;
            Set succs = block.successors.stream().map(suc -> CFG.isLoop(suc) ? CFG.getAfterLoopBlock(suc) : suc).filter(Objects::nonNull).collect(Collectors.toSet());
            block.successors.clear();
            block.successors.addAll(succs);
        }
    }

    private static boolean isLoop(Block successor) {
        return successor.terminator != null && successor.terminator.is(Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT);
    }

    @CheckForNull
    private static Block getAfterLoopBlock(Block loop) {
        if (loop.falseBlock != null) {
            return loop.falseBlock;
        }
        return loop.successorWithoutJump;
    }

    private void prune() {
        ArrayList<Block> inactiveBlocks = new ArrayList<Block>();
        boolean first = true;
        for (Block block : this.blocks) {
            if (!first && this.isInactive(block)) {
                inactiveBlocks.add(block);
            }
            first = false;
        }
        if (!inactiveBlocks.isEmpty()) {
            this.removeInactiveBlocks(inactiveBlocks);
            if (inactiveBlocks.contains(this.currentBlock)) {
                this.currentBlock = this.currentBlock.successors.iterator().next();
            }
            int id = 0;
            for (Block block : this.blocks) {
                block.id = id++;
            }
            inactiveBlocks.removeAll(this.blocks);
            if (!inactiveBlocks.isEmpty()) {
                this.prune();
            }
        }
    }

    private boolean isInactive(Block block) {
        if (block.equals(this.currentBlock) && block.successors.size() > 1) {
            return false;
        }
        return block.isInactive();
    }

    private void removeInactiveBlocks(List<Block> inactiveBlocks) {
        for (Block inactiveBlock : inactiveBlocks) {
            for (Block block : this.blocks) {
                block.prune(inactiveBlock);
            }
        }
        this.blocks.removeAll(inactiveBlocks);
    }

    private Block createBlock(Block successor) {
        Block result = this.createBlock();
        result.addSuccessor(successor);
        return result;
    }

    private Block createBlock() {
        Block result = new Block(this.blocks.size());
        this.blocks.add(result);
        return result;
    }

    public static CFG buildCFG(List<? extends Tree> trees, boolean ignoreBreak) {
        return new CFG(trees, null, ignoreBreak);
    }

    public static CFG buildCFG(List<? extends Tree> trees) {
        return new CFG(trees, null, false);
    }

    public static CFG build(MethodTree tree) {
        BlockTree block = tree.block();
        Preconditions.checkArgument(block != null, "Cannot build CFG for method with no body.");
        return new CFG(block.body(), tree, false);
    }

    private void build(ListTree<? extends Tree> trees) {
        this.build((List<? extends Tree>)trees);
    }

    private void build(List<? extends Tree> trees) {
        ListUtils.reverse(trees).forEach(this::build);
    }

    private void build(Tree tree) {
        switch (tree.kind()) {
            case BLOCK: {
                this.build(((BlockTree)tree).body());
                break;
            }
            case RETURN_STATEMENT: {
                this.buildReturnStatement((ReturnStatementTree)tree);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.build(((ExpressionStatementTree)tree).expression());
                break;
            }
            case METHOD_INVOCATION: {
                this.buildMethodInvocation((MethodInvocationTree)tree);
                break;
            }
            case IF_STATEMENT: {
                this.buildIfStatement((IfStatementTree)tree);
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.buildConditionalExpression((ConditionalExpressionTree)tree);
                break;
            }
            case VARIABLE: {
                this.buildVariable((VariableTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.buildBinaryExpression(tree);
                break;
            }
            case ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: {
                this.buildAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.buildMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)tree);
                break;
            }
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)tree);
                break;
            }
            case LABELED_STATEMENT: {
                this.buildLabeledStatement((LabeledStatementTree)tree);
                break;
            }
            case SWITCH_STATEMENT: {
                this.buildSwitchStatement((SwitchStatementTree)tree);
                break;
            }
            case SWITCH_EXPRESSION: {
                this.buildSwitchExpression((SwitchExpressionTree)tree);
                break;
            }
            case BREAK_STATEMENT: {
                this.buildBreakStatement((BreakStatementTree)tree);
                break;
            }
            case YIELD_STATEMENT: {
                this.buildYieldStatement((YieldStatementTree)tree);
                break;
            }
            case CONTINUE_STATEMENT: {
                this.buildContinueStatement((ContinueStatementTree)tree);
                break;
            }
            case WHILE_STATEMENT: {
                this.buildWhileStatement((WhileStatementTree)tree);
                break;
            }
            case DO_STATEMENT: {
                this.buildDoWhileStatement((DoWhileStatementTree)tree);
                break;
            }
            case FOR_EACH_STATEMENT: {
                this.buildForEachStatement((ForEachStatement)tree);
                break;
            }
            case FOR_STATEMENT: {
                this.buildForStatement((ForStatementTree)tree);
                break;
            }
            case TRY_STATEMENT: {
                this.buildTryStatement((TryStatementTree)tree);
                break;
            }
            case THROW_STATEMENT: {
                this.buildThrowStatement((ThrowStatementTree)tree);
                break;
            }
            case SYNCHRONIZED_STATEMENT: {
                this.buildSynchronizedStatement((SynchronizedStatementTree)tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                this.buildUnaryExpression((UnaryExpressionTree)tree);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.build(((ParenthesizedTree)tree).expression());
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.buildArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case ARRAY_DIMENSION: {
                this.buildArrayDimension((ArrayDimensionTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.buildNewClass((NewClassTree)tree);
                break;
            }
            case TYPE_CAST: {
                this.buildTypeCast(tree);
                break;
            }
            case INSTANCE_OF: {
                this.buildInstanceOf((InstanceOfTree)tree);
                break;
            }
            case PATTERN_INSTANCE_OF: {
                this.buildInstanceOf((PatternInstanceOfTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.buildNewArray((NewArrayTree)tree);
                break;
            }
            case ASSERT_STATEMENT: {
                this.buildAssertStatement((AssertStatementTree)tree);
                break;
            }
            case EMPTY_STATEMENT: 
            case CLASS: 
            case RECORD: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case METHOD_REFERENCE: 
            case LAMBDA_EXPRESSION: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHAR_LITERAL: 
            case FLOAT_LITERAL: 
            case STRING_LITERAL: 
            case TEXT_BLOCK: 
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                this.currentBlock.elements.add(tree);
                break;
            }
            case IDENTIFIER: {
                this.checkIdentifierSemantic((IdentifierTree)tree);
                this.currentBlock.elements.add(tree);
                break;
            }
            case NULL_PATTERN: 
            case TYPE_PATTERN: 
            case GUARDED_PATTERN: 
            case RECORD_PATTERN: 
            case DEFAULT_PATTERN: {
                this.buildPattern((PatternTree)tree);
                break;
            }
            default: {
                throw new UnsupportedOperationException(tree.kind().name() + " " + ((JavaTree)tree).getLine());
            }
        }
    }

    private void buildReturnStatement(ReturnStatementTree returnStatement) {
        this.currentBlock = this.createUnconditionalJump(returnStatement, this.exitBlock(), this.currentBlock);
        ExpressionTree expression = returnStatement.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildMethodInvocation(MethodInvocationTree mit) {
        SyntaxToken location = mit.methodSelect().lastToken();
        this.checkSymbolSemantic(mit.methodSymbol(), "method invocation", location);
        this.handleExceptionalPaths(mit.methodSymbol(), location);
        this.currentBlock.elements.add(mit);
        this.build(mit.arguments());
        if (mit.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)mit.methodSelect();
            this.build(memberSelect.expression());
        } else {
            this.build(mit.methodSelect());
        }
    }

    private void buildIfStatement(IfStatementTree ifStatementTree) {
        Block next;
        Block elseBlock = next = this.currentBlock;
        StatementTree elseStatement = ifStatementTree.elseStatement();
        if (elseStatement != null) {
            if (!elseStatement.is(Tree.Kind.IF_STATEMENT)) {
                this.currentBlock = this.createBlock(next);
            }
            this.build(elseStatement);
            elseBlock = this.currentBlock;
        }
        this.currentBlock = this.createBlock(next);
        this.build(ifStatementTree.thenStatement());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(ifStatementTree, thenBlock, elseBlock);
        this.buildCondition(ifStatementTree.condition(), thenBlock, elseBlock);
    }

    private void buildConditionalExpression(ConditionalExpressionTree cond) {
        Block next = this.currentBlock;
        ExpressionTree elseStatement = cond.falseExpression();
        this.currentBlock = this.createBlock(next);
        this.build(elseStatement);
        Block elseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(next);
        this.build(cond.trueExpression());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(cond, thenBlock, elseBlock);
        this.buildCondition(cond.condition(), thenBlock, elseBlock);
    }

    private void buildVariable(VariableTree tree) {
        this.checkTypeSemantic(tree.type().symbolType(), "unknown variable type", tree.type().firstToken());
        this.currentBlock.elements.add(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            this.build(initializer);
        }
    }

    private void buildBinaryExpression(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        this.currentBlock.elements.add(tree);
        this.build(binaryExpressionTree.rightOperand());
        this.build(binaryExpressionTree.leftOperand());
    }

    private void buildAssignment(AssignmentExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
        if (!ExpressionUtils.isSimpleAssignment(tree)) {
            this.build(tree.variable());
        }
    }

    private void buildMemberSelect(MemberSelectExpressionTree mse) {
        this.currentBlock.elements.add(mse);
        if (!"class".equals(mse.identifier().name())) {
            this.build(mse.expression());
        }
    }

    private void buildConditionalAnd(BinaryExpressionTree tree) {
        Block falseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(falseBlock);
        this.build(tree.rightOperand());
        this.buildConditionalBinaryLHS(tree, this.currentBlock, falseBlock);
    }

    private void buildConditionalOr(BinaryExpressionTree tree) {
        Block trueBlock = this.currentBlock;
        this.currentBlock = this.createBlock(trueBlock);
        this.build(tree.rightOperand());
        this.buildConditionalBinaryLHS(tree, trueBlock, this.currentBlock);
    }

    private void buildConditionalBinaryLHS(BinaryExpressionTree tree, Block trueBlock, Block falseBlock) {
        Block toComplete = this.currentBlock = this.createBlock();
        this.build(tree.leftOperand());
        toComplete.terminator = tree;
        toComplete.addFalseSuccessor(falseBlock);
        toComplete.addTrueSuccessor(trueBlock);
    }

    private void buildLabeledStatement(LabeledStatementTree labeledStatement) {
        String name = labeledStatement.label().name();
        this.labelsBreakTarget.put(name, this.currentBlock);
        this.pendingLabel = name;
        this.currentBlock = this.createBlock(this.currentBlock);
        this.build(labeledStatement.statement());
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildSwitchStatement(SwitchStatementTree switchStatementTree) {
        this.buildSwitch(switchStatementTree, switchStatementTree);
    }

    private void buildSwitchExpression(SwitchExpressionTree switchExpressionTree) {
        this.buildSwitch(switchExpressionTree, switchExpressionTree);
    }

    private void buildSwitch(SwitchTree switchTree, Tree terminator) {
        Block switchSuccessor = this.currentBlock;
        this.currentBlock = this.createBlock();
        this.currentBlock.terminator = terminator;
        Block switchBlock = this.currentBlock;
        List switchCasesExpressions = switchTree.cases().stream().map(CaseGroupTree::labels).flatMap(Collection::stream).map(CaseLabelTree::expressions).flatMap(Collection::stream).toList();
        ListUtils.reverse(switchCasesExpressions).forEach(this::build);
        this.build(switchTree.expression());
        Block conditionBlock = this.currentBlock;
        this.currentBlock = this.createBlock(switchSuccessor);
        this.breakTargets.addLast(switchSuccessor);
        boolean hasDefaultCase = false;
        if (!switchTree.cases().isEmpty()) {
            boolean withoutFallTrough = CFG.switchWithoutFallThrough(switchTree);
            CaseGroupTree firstCase = switchTree.cases().get(0);
            for (CaseGroupTree caseGroupTree : ListUtils.reverse(switchTree.cases())) {
                if (withoutFallTrough) {
                    this.currentBlock.successors().clear();
                    this.currentBlock.addSuccessor(switchSuccessor);
                }
                this.build(caseGroupTree.body());
                this.currentBlock.elements.add(caseGroupTree);
                if (!hasDefaultCase) {
                    this.currentBlock.isDefaultBlock = hasDefaultCase = CFG.containsDefaultCase(caseGroupTree.labels());
                }
                this.currentBlock.setCaseGroup(caseGroupTree);
                switchBlock.addSuccessor(this.currentBlock);
                if (caseGroupTree.equals(firstCase)) continue;
                this.currentBlock = this.createBlock(this.currentBlock);
            }
        }
        this.breakTargets.removeLast();
        this.currentBlock = switchBlock;
        if (!hasDefaultCase && !terminator.is(Tree.Kind.SWITCH_EXPRESSION)) {
            this.currentBlock.addSuccessor(switchSuccessor);
        }
        this.currentBlock = conditionBlock;
    }

    private static boolean switchWithoutFallThrough(SwitchTree switchTree) {
        return switchTree.cases().stream().map(CaseGroupTree::labels).flatMap(Collection::stream).noneMatch(CaseLabelTree::isFallThrough);
    }

    private static boolean containsDefaultCase(List<CaseLabelTree> labels) {
        return labels.stream().anyMatch(caseLabel -> "default".equals(caseLabel.caseOrDefaultKeyword().text()) || caseLabel.expressions().stream().anyMatch(expr -> expr.is(Tree.Kind.DEFAULT_PATTERN)));
    }

    private void buildBreakStatement(BreakStatementTree tree) {
        IdentifierTree label = tree.label();
        boolean isLabel = false;
        Block targetBlock = null;
        if (label == null) {
            if (this.breakTargets.isEmpty()) {
                if (!this.ignoreBreakAndContinue) {
                    throw new IllegalStateException("'break' statement not in loop or switch statement");
                }
            } else {
                targetBlock = this.breakTargets.getLast();
            }
        } else {
            isLabel = label.symbol() instanceof Symbol.LabelSymbol;
            targetBlock = isLabel ? this.labelsBreakTarget.get(label.name()) : this.breakTargets.getLast();
        }
        this.currentBlock = this.createUnconditionalJump(tree, targetBlock, this.currentBlock);
        if (this.currentBlock.exitBlock != null) {
            this.currentBlock.exitBlock = null;
        }
    }

    private void buildYieldStatement(YieldStatementTree tree) {
        this.currentBlock = this.createUnconditionalJump(tree, this.breakTargets.isEmpty() ? null : this.breakTargets.getLast(), this.currentBlock);
        this.build(tree.expression());
        this.currentBlock.exitBlock = null;
    }

    private void buildContinueStatement(ContinueStatementTree tree) {
        IdentifierTree label = tree.label();
        Block targetBlock = null;
        if (label == null) {
            if (this.continueTargets.isEmpty()) {
                if (!this.ignoreBreakAndContinue) {
                    throw new IllegalStateException("'continue' statement not in loop or switch statement");
                }
            } else {
                targetBlock = this.continueTargets.getLast();
            }
        } else {
            targetBlock = this.labelsContinueTarget.get(label.name());
        }
        this.currentBlock = this.createUnconditionalJump(tree, targetBlock, this.currentBlock);
        this.currentBlock.exitBlock = null;
    }

    private void buildWhileStatement(WhileStatementTree whileStatement) {
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBlock(loopback);
        this.addContinueTarget(loopback);
        this.breakTargets.addLast(falseBranch);
        this.build(whileStatement.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block bodyBlock = this.currentBlock;
        this.currentBlock = this.createBranch(whileStatement, bodyBlock, falseBranch);
        this.buildCondition(whileStatement.condition(), bodyBlock, falseBranch);
        loopback.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildDoWhileStatement(DoWhileStatementTree doWhileStatementTree) {
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBranch(doWhileStatementTree, loopback, falseBranch);
        this.buildCondition(doWhileStatementTree.condition(), loopback, falseBranch);
        this.addContinueTarget(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.breakTargets.addLast(falseBranch);
        this.build(doWhileStatementTree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        loopback.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildForEachStatement(ForEachStatement tree) {
        Block afterLoop = this.currentBlock;
        Block statementBlock = this.createBlock();
        Block loopback = this.createBranch(tree, statementBlock, afterLoop);
        this.currentBlock = this.createBlock(loopback);
        this.addContinueTarget(loopback);
        this.breakTargets.addLast(afterLoop);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        statementBlock.addSuccessor(this.currentBlock);
        this.currentBlock = loopback;
        this.build(tree.variable());
        this.currentBlock = this.createBlock(this.currentBlock);
        this.build(tree.expression());
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void addContinueTarget(Block target) {
        this.continueTargets.addLast(target);
        if (this.pendingLabel != null) {
            this.labelsContinueTarget.put(this.pendingLabel, target);
            this.pendingLabel = null;
        }
    }

    private void buildForStatement(ForStatementTree tree) {
        Block falseBranch = this.currentBlock;
        Block updateBlock = this.currentBlock = this.createBlock();
        this.build(tree.update());
        this.addContinueTarget(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.breakTargets.addLast(falseBranch);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block body = this.currentBlock;
        ExpressionTree condition = tree.condition();
        if (condition != null) {
            this.currentBlock = this.createBranch(tree, body, falseBranch);
            this.buildCondition(condition, body, falseBranch);
        } else {
            this.currentBlock = this.createUnconditionalJump(tree, body, falseBranch);
        }
        updateBlock.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.build(tree.initializer());
    }

    private void buildTryStatement(TryStatementTree tryStatementTree) {
        this.currentBlock = this.createBlock(this.currentBlock);
        BlockTree finallyBlockTree = tryStatementTree.finallyBlock();
        if (finallyBlockTree != null) {
            this.currentBlock.isFinallyBlock = true;
            Block finallyBlock = this.currentBlock;
            this.build(finallyBlockTree);
            finallyBlock.addExitSuccessor(this.exitBlock());
            this.exitBlocks.push(this.currentBlock);
            this.addContinueTarget(this.currentBlock);
            this.currentBlock.isFinallyBlock = true;
            this.breakTargets.addLast(this.currentBlock);
        }
        Block finallyOrEndBlock = this.currentBlock;
        Block beforeFinally = this.createBlock(this.currentBlock);
        TryStatement tryStatement = new TryStatement();
        this.enclosingTry.push(tryStatement);
        this.enclosedByCatch.push(false);
        for (CatchTree catchTree : ListUtils.reverse(tryStatementTree.catches())) {
            this.currentBlock = this.createBlock(finallyOrEndBlock);
            this.enclosedByCatch.push(true);
            this.build(catchTree.block());
            this.buildVariable(catchTree.parameter());
            this.currentBlock.isCatchBlock = true;
            this.enclosedByCatch.pop();
            TypeTree type = catchTree.parameter().type();
            tryStatement.addCatch(this.checkTypeSemantic(type.symbolType(), "catch parameter type", type.firstToken()), this.currentBlock);
        }
        this.currentBlock = beforeFinally;
        this.build(tryStatementTree.block());
        this.build((List<? extends Tree>)tryStatementTree.resourceList());
        this.enclosingTry.pop();
        this.enclosedByCatch.pop();
        this.currentBlock = this.createBlock(this.currentBlock);
        this.currentBlock.elements.add(tryStatementTree);
        if (finallyBlockTree != null) {
            this.exitBlocks.pop();
            this.continueTargets.removeLast();
            this.breakTargets.removeLast();
        }
    }

    private void buildThrowStatement(ThrowStatementTree throwStatementTree) {
        Block jumpTo = this.exitBlock();
        TryStatement enclosingTryCatch = this.enclosingTry.peek();
        if (enclosingTryCatch != null) {
            jumpTo = enclosingTryCatch.catches.keySet().stream().filter(t -> this.checkTypeSemantic(throwStatementTree.expression().symbolType(), "thrown expression", throwStatementTree.expression().firstToken()).isSubtypeOf((Type)t)).findFirst().map(t -> enclosingTryCatch.catches.get(t)).orElse(this.exitBlock());
        }
        this.currentBlock = this.createUnconditionalJump(throwStatementTree, jumpTo, this.currentBlock);
        this.build(throwStatementTree.expression());
    }

    private void buildSynchronizedStatement(SynchronizedStatementTree sst) {
        this.build(sst.block());
        this.currentBlock = this.createUnconditionalJump(sst, this.currentBlock, null);
        this.build(sst.expression());
    }

    private void buildUnaryExpression(UnaryExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
    }

    private void buildArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.dimension());
        this.build(tree.expression());
    }

    private void buildArrayDimension(ArrayDimensionTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildNewClass(NewClassTree tree) {
        SyntaxToken location = tree.identifier().lastToken();
        this.checkSymbolSemantic(tree.methodSymbol(), "new class", location);
        this.handleExceptionalPaths(tree.methodSymbol(), location);
        this.currentBlock.elements.add(tree);
        this.build(tree.arguments());
        ExpressionTree enclosingExpression = tree.enclosingExpression();
        if (enclosingExpression != null) {
            this.build(enclosingExpression);
        }
    }

    private void handleExceptionalPaths(Symbol.MethodSymbol symbol, @Nullable SyntaxToken location) {
        TryStatement pop = this.enclosingTry.pop();
        Block exceptionPredecessor = this.currentBlock;
        TryStatement tryStatement = Boolean.TRUE.equals(this.enclosedByCatch.peek()) ? this.enclosingTry.peek() : pop;
        this.enclosingTry.push(pop);
        if (pop != this.outerTry) {
            this.currentBlock = this.createBlock(this.currentBlock);
            this.currentBlock.exceptions.add(this.exitBlocks.peek());
            if (!Boolean.TRUE.equals(this.enclosedByCatch.peek())) {
                exceptionPredecessor = this.currentBlock;
            }
        }
        if (!symbol.isUnknown()) {
            List<Type> thrownTypes = symbol.thrownTypes();
            thrownTypes.forEach(thrownType -> {
                this.checkTypeSemantic((Type)thrownType, "thrown types", location);
                for (Type caughtType : tryStatement.catches.keySet()) {
                    if (!thrownType.isSubtypeOf(caughtType) && !caughtType.isSubtypeOf((Type)thrownType) && !thrownType.isUnknown() && !caughtType.isUnknown()) continue;
                    this.currentBlock.exceptions.add(tryStatement.catches.get(caughtType));
                }
            });
        }
        exceptionPredecessor.exceptions.addAll(tryStatement.runtimeCatches);
    }

    private void buildTypeCast(Tree tree) {
        this.enclosingTry.peek().catches.entrySet().stream().filter(e -> ((Type)e.getKey()).isSubtypeOf("java.lang.ClassCastException")).findFirst().ifPresent(e -> {
            this.currentBlock = this.createBlock(this.currentBlock);
            this.currentBlock.successors.add((Block)e.getValue());
        });
        this.currentBlock.elements.add(tree);
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        this.build(typeCastTree.expression());
    }

    private void buildInstanceOf(InstanceOfTree instanceOfTree) {
        this.currentBlock.elements.add(instanceOfTree);
        this.build(instanceOfTree.expression());
    }

    private void buildInstanceOf(PatternInstanceOfTree instanceOfTree) {
        this.currentBlock.elements.add(instanceOfTree);
        this.build(instanceOfTree.pattern());
        this.build(instanceOfTree.expression());
    }

    private void buildNewArray(NewArrayTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.dimensions());
        this.build(tree.initializers());
    }

    private void buildAssertStatement(AssertStatementTree assertStatementTree) {
        this.currentBlock.elements.add(assertStatementTree);
        this.build(assertStatementTree.condition());
    }

    private Block createUnconditionalJump(Tree terminator, @Nullable Block target, @Nullable Block successorWithoutJump) {
        Block result = this.createBlock();
        result.terminator = terminator;
        if (target != null) {
            if (target == this.exitBlock()) {
                result.addExitSuccessor(target);
            } else {
                result.addSuccessor(target);
            }
        }
        result.successorWithoutJump = successorWithoutJump;
        return result;
    }

    private void buildCondition(Tree syntaxNode, Block trueBlock, Block falseBlock) {
        switch (syntaxNode.kind()) {
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.buildCondition(((ParenthesizedTree)syntaxNode).expression(), trueBlock, falseBlock);
                break;
            }
            default: {
                this.build(syntaxNode);
            }
        }
    }

    private void buildConditionalOr(BinaryExpressionTree conditionalOr, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalOr.rightOperand(), trueBlock, falseBlock);
        Block newFalseBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalOr, trueBlock, newFalseBlock);
        this.buildCondition(conditionalOr.leftOperand(), trueBlock, newFalseBlock);
    }

    private void buildConditionalAnd(BinaryExpressionTree conditionalAnd, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalAnd.rightOperand(), trueBlock, falseBlock);
        Block newTrueBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalAnd, newTrueBlock, falseBlock);
        this.buildCondition(conditionalAnd.leftOperand(), newTrueBlock, falseBlock);
    }

    private Block createBranch(Tree terminator, Block trueBranch, Block falseBranch) {
        Block result = this.createBlock();
        result.terminator = terminator;
        result.addFalseSuccessor(falseBranch);
        result.addTrueSuccessor(trueBranch);
        return result;
    }

    public void setMethodSymbol(Symbol.MethodSymbol methodSymbol) {
        this.methodSymbol = methodSymbol;
    }

    private void buildPattern(PatternTree tree) {
        switch (tree.kind()) {
            case NULL_PATTERN: {
                this.buildNullPattern((NullPatternTree)tree);
                break;
            }
            case TYPE_PATTERN: {
                this.buildTypePattern((TypePatternTree)tree);
                break;
            }
            case GUARDED_PATTERN: {
                this.buildGuardedPattern((GuardedPatternTree)tree);
                break;
            }
            case RECORD_PATTERN: {
                this.buildRecordPattern((RecordPatternTree)tree);
                break;
            }
            case DEFAULT_PATTERN: {
                this.currentBlock.elements.add(tree);
                break;
            }
            default: {
                throw new UnsupportedOperationException(tree.kind().name() + " " + ((JavaTree)((Object)tree)).getLine());
            }
        }
    }

    private void buildNullPattern(NullPatternTree tree) {
        this.currentBlock.elements.add(tree.nullLiteral());
        this.currentBlock.elements.add(tree);
    }

    private void buildTypePattern(TypePatternTree tree) {
        this.buildVariable(tree.patternVariable());
        this.currentBlock.elements.add(tree);
    }

    private void buildGuardedPattern(GuardedPatternTree tree) {
        this.build(tree.expression());
        this.build(tree.pattern());
        this.currentBlock.elements.add(tree);
    }

    private void buildRecordPattern(RecordPatternTree tree) {
        this.build(tree.patterns());
        this.build(tree.type());
        this.currentBlock.elements.add(tree);
    }

    public static class Block
    implements IBlock<Tree>,
    ControlFlowGraph.Block {
        public static final Predicate<Block> IS_CATCH_BLOCK = Block::isCatchBlock;
        private int id;
        private final List<Tree> elements = new ArrayList<Tree>();
        private final Set<Block> successors = new LinkedHashSet<Block>();
        private final Set<Block> predecessors = new LinkedHashSet<Block>();
        private final Set<Block> exceptions = new LinkedHashSet<Block>();
        private Block trueBlock;
        private Block falseBlock;
        private Block exitBlock;
        private Block successorWithoutJump;
        private Tree terminator;
        private CaseGroupTree caseGroup;
        private boolean isFinallyBlock;
        private boolean isCatchBlock = false;
        private boolean isDefaultBlock = false;

        public Block(int id) {
            this.id = id;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public List<Tree> elements() {
            return ListUtils.reverse(this.elements);
        }

        @Override
        public Block trueBlock() {
            return this.trueBlock;
        }

        @Override
        public Block falseBlock() {
            return this.falseBlock;
        }

        @Override
        public Block exitBlock() {
            return this.exitBlock;
        }

        @Override
        public boolean isFinallyBlock() {
            return this.isFinallyBlock;
        }

        @Override
        public boolean isCatchBlock() {
            return this.isCatchBlock;
        }

        @Override
        public boolean isDefaultBlock() {
            return this.isDefaultBlock;
        }

        void addSuccessor(Block successor) {
            this.successors.add(successor);
        }

        public void addTrueSuccessor(Block successor) {
            if (this.trueBlock != null) {
                throw new IllegalStateException("Attempt to re-assign a true successor");
            }
            this.successors.add(successor);
            this.trueBlock = successor;
        }

        public void addFalseSuccessor(Block successor) {
            if (this.falseBlock != null) {
                throw new IllegalStateException("Attempt to re-assign a false successor");
            }
            this.successors.add(successor);
            this.falseBlock = successor;
        }

        public void addExitSuccessor(Block block) {
            this.successors.add(block);
            this.exitBlock = block;
        }

        public Set<Block> predecessors() {
            return this.predecessors;
        }

        @Override
        public Set<Block> successors() {
            return this.successors;
        }

        public Set<Block> exceptions() {
            return this.exceptions;
        }

        @Override
        @CheckForNull
        public Tree terminator() {
            return this.terminator;
        }

        public boolean isInactive() {
            return this.terminator == null && this.elements.isEmpty() && this.successors.size() == 1;
        }

        private void prune(Block inactiveBlock) {
            boolean hasUniqueSuccessor;
            boolean bl = hasUniqueSuccessor = inactiveBlock.successors.size() == 1;
            if (inactiveBlock.equals(this.trueBlock)) {
                Preconditions.checkArgument(hasUniqueSuccessor, "True successor must be replaced by a unique successor!");
                this.trueBlock = inactiveBlock.successors.iterator().next();
            }
            if (inactiveBlock.equals(this.falseBlock)) {
                Preconditions.checkArgument(hasUniqueSuccessor, "False successor must be replaced by a unique successor!");
                this.falseBlock = inactiveBlock.successors.iterator().next();
            }
            if (inactiveBlock.equals(this.successorWithoutJump)) {
                Preconditions.checkArgument(hasUniqueSuccessor, "SuccessorWithoutJump successor must be replaced by a unique successor!");
                this.successorWithoutJump = inactiveBlock.successors.iterator().next();
            }
            if (this.successors.remove(inactiveBlock)) {
                this.successors.addAll(inactiveBlock.successors);
            }
            if (this.exceptions.remove(inactiveBlock)) {
                this.exceptions.addAll(inactiveBlock.exceptions);
                this.exceptions.addAll(inactiveBlock.successors);
            }
            if (inactiveBlock.equals(this.exitBlock)) {
                this.exitBlock = inactiveBlock.successors.iterator().next();
            }
        }

        public boolean isMethodExitBlock() {
            return this.successors().isEmpty();
        }

        @CheckForNull
        public Block successorWithoutJump() {
            return this.successorWithoutJump;
        }

        @Override
        @CheckForNull
        public CaseGroupTree caseGroup() {
            return this.caseGroup;
        }

        public void setCaseGroup(CaseGroupTree caseGroup) {
            this.caseGroup = caseGroup;
        }
    }

    private static class TryStatement {
        Map<Type, Block> catches = new LinkedHashMap<Type, Block>();
        List<Block> runtimeCatches = new ArrayList<Block>();

        private TryStatement() {
        }

        public void addCatch(Type type, Block catchBlock) {
            if (type.is("java.lang.Exception") || type.is("java.lang.Throwable") || type.isSubtypeOf("java.lang.Error") || type.isSubtypeOf("java.lang.RuntimeException") || !type.isSubtypeOf("java.lang.Exception")) {
                this.runtimeCatches.add(catchBlock);
            }
            this.catches.put(type, catchBlock);
        }
    }

    public static interface IBlock<T> {
        public int id();

        public List<T> elements();

        public T terminator();

        public Set<? extends IBlock<T>> successors();
    }
}

