/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineColumnConverter {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r\n?|\n");
    private int[] lineStartIndexes = new int[64];
    private int lineStartIndexesLength = 0;

    public LineColumnConverter(String source) {
        Matcher matcher = LINE_SEPARATOR_PATTERN.matcher(source);
        this.addLineStartIndex(0);
        while (matcher.find()) {
            this.addLineStartIndex(matcher.end());
        }
        this.addLineStartIndex(Integer.MAX_VALUE);
    }

    private void addLineStartIndex(int index) {
        if (this.lineStartIndexesLength == this.lineStartIndexes.length) {
            this.lineStartIndexes = Arrays.copyOf(this.lineStartIndexes, this.lineStartIndexes.length * 2);
        }
        this.lineStartIndexes[this.lineStartIndexesLength] = index;
        ++this.lineStartIndexesLength;
    }

    public Pos toPos(int absolutSourcePosition) {
        int searchResult = Arrays.binarySearch(this.lineStartIndexes, 0, this.lineStartIndexesLength, absolutSourcePosition);
        if (searchResult < 0) {
            return new Pos(-searchResult - 1, absolutSourcePosition - this.lineStartIndexes[-searchResult - 2]);
        }
        return new Pos(searchResult + 1, 0);
    }

    public record Pos(int line, int columnOffset) {
    }
}

