/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode) {
        return SyntacticEquivalence.areEquivalent(leftNode, rightNode, (JavaTree t1, JavaTree t2) -> false, true);
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList) {
        return SyntacticEquivalence.areEquivalent(leftList, rightList, (t1, t2) -> false);
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList, BiPredicate<JavaTree, JavaTree> permissiveEquivalence) {
        return SyntacticEquivalence.areEquivalent(leftList, rightList, permissiveEquivalence, true);
    }

    public static boolean areSemanticallyEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList) {
        return SyntacticEquivalence.areEquivalent(leftList, rightList, SyntacticEquivalence::areNotSameMethodCalls, false);
    }

    public static boolean areEquivalentIncludingSameVariables(Tree left, Tree right) {
        return SyntacticEquivalence.areEquivalent(left, right, SyntacticEquivalence::areDifferentVariables, false);
    }

    private static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList, BiPredicate<JavaTree, JavaTree> overwriteEquivalence, boolean equivalenceValue) {
        if (leftList.size() != rightList.size()) {
            return false;
        }
        for (int i = 0; i < leftList.size(); ++i) {
            Tree right;
            Tree left = leftList.get(i);
            if (SyntacticEquivalence.areEquivalent(left, right = rightList.get(i), overwriteEquivalence, equivalenceValue)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode, BiPredicate<JavaTree, JavaTree> overwriteEquivalence, boolean equivalenceValue) {
        return SyntacticEquivalence.areEquivalent((JavaTree)leftNode, (JavaTree)rightNode, overwriteEquivalence, equivalenceValue);
    }

    private static boolean areEquivalent(@Nullable JavaTree leftNode, @Nullable JavaTree rightNode, BiPredicate<JavaTree, JavaTree> overWriteEquivalence, boolean equivalenceValue) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (overWriteEquivalence.test(leftNode, rightNode)) {
            return equivalenceValue;
        }
        if (leftNode.kind() != rightNode.kind() || leftNode.is(Tree.Kind.OTHER)) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        Iterator<Tree> iteratorA = leftNode.getChildren().iterator();
        Iterator<Tree> iteratorB = rightNode.getChildren().iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next(), overWriteEquivalence, equivalenceValue)) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    private static boolean areLeafsEquivalent(JavaTree leftNode, JavaTree rightNode) {
        if (leftNode instanceof SyntaxToken) {
            SyntaxToken syntaxToken = (SyntaxToken)((Object)leftNode);
            return Objects.equals(syntaxToken.text(), ((SyntaxToken)((Object)rightNode)).text());
        }
        if (leftNode.is(Tree.Kind.INFERED_TYPE)) {
            return rightNode.is(Tree.Kind.INFERED_TYPE);
        }
        throw new IllegalArgumentException();
    }

    private static boolean areDifferentVariables(JavaTree leftNode, JavaTree rightNode) {
        if (!leftNode.is(Tree.Kind.IDENTIFIER) || !rightNode.is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        Symbol leftSymbol = ((IdentifierTree)((Object)leftNode)).symbol();
        Symbol rightSymbol = ((IdentifierTree)((Object)rightNode)).symbol();
        if (leftSymbol.isUnknown() || rightSymbol.isUnknown()) {
            return true;
        }
        return !leftSymbol.equals(rightSymbol);
    }

    private static boolean areNotSameMethodCalls(JavaTree leftNode, JavaTree rightNode) {
        if (!leftNode.is(Tree.Kind.METHOD_INVOCATION) || !rightNode.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        Symbol.MethodSymbol leftSymbol = ((MethodInvocationTree)((Object)leftNode)).methodSymbol();
        Symbol.MethodSymbol rightSymbol = ((MethodInvocationTree)((Object)rightNode)).methodSymbol();
        if (leftSymbol.isUnknown() || rightSymbol.isUnknown()) {
            return true;
        }
        List<Type> leftArguments = leftSymbol.parameterTypes();
        List<Type> rightArguments = rightSymbol.parameterTypes();
        int leftArgumentsSize = leftArguments.size();
        if (leftArgumentsSize == rightArguments.size()) {
            for (int i = 0; i < leftArgumentsSize; ++i) {
                if (leftArguments.get(i).equals(rightArguments.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

