/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class MethodNestingLevelVisitor
extends BaseTreeVisitor {
    private int maxNestingLevel = 0;
    private int nestingLevel = 0;

    public int getMaxNestingLevel(MethodTree tree) {
        this.maxNestingLevel = 0;
        this.nestingLevel = 0;
        if (tree.block() == null) {
            return this.maxNestingLevel;
        }
        this.scan(tree.block());
        return this.maxNestingLevel;
    }

    void visit(Tree tree) {
        ++this.nestingLevel;
        if (this.nestingLevel > this.maxNestingLevel) {
            this.maxNestingLevel = this.nestingLevel;
        }
        this.scan(tree);
        --this.nestingLevel;
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.visit(tree.thenStatement());
        StatementTree elseTree = tree.elseStatement();
        if (elseTree != null) {
            if (elseTree.is(Tree.Kind.IF_STATEMENT)) {
                tree.elseStatement().accept(this);
            } else {
                this.visit(tree.elseStatement());
            }
        }
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        for (CaseGroupTree cgt : tree.cases()) {
            this.visit(cgt);
        }
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.visit(tree.block());
        for (CatchTree ct : tree.catches()) {
            this.visit(ct);
        }
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.visit(tree.statement());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.visit(tree.statement());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.visit(tree.statement());
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        this.visit(lambdaExpressionTree.body());
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.visit(tree.statement());
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.classBody() != null) {
            this.visit(tree.classBody());
        }
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (tree.block() != null) {
            this.visit(tree.block());
        }
    }
}

