/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.caching;

import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.java.SonarComponents;
import org.sonar.java.caching.DummyCache;
import org.sonar.java.caching.JavaReadCacheImpl;
import org.sonar.java.caching.JavaWriteCacheImpl;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonar.plugins.java.api.caching.JavaWriteCache;
import org.sonar.plugins.java.api.caching.SonarLintCache;

public class CacheContextImpl
implements CacheContext {
    public static final String SONAR_CACHING_ENABLED_KEY = "sonar.java.caching.enabled";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheContextImpl.class);
    private final boolean isCacheEnabled;
    private final JavaReadCache readCache;
    private final JavaWriteCache writeCache;

    private CacheContextImpl(boolean isCacheEnabled, JavaReadCache readCache, JavaWriteCache writeCache) {
        this.isCacheEnabled = isCacheEnabled;
        this.readCache = readCache;
        this.writeCache = writeCache;
    }

    public static CacheContextImpl of(@Nullable SonarComponents sonarComponents) {
        if (sonarComponents == null) {
            return CacheContextImpl.dummyCache();
        }
        SonarLintCache sonarLintCache = sonarComponents.sonarLintCache();
        if (sonarLintCache != null) {
            return CacheContextImpl.fromSonarLintCache(sonarLintCache);
        }
        SensorContext sensorContext = sonarComponents.context();
        if (sensorContext == null) {
            return CacheContextImpl.dummyCache();
        }
        try {
            boolean isCachingEnabled = CacheContextImpl.isCachingEnabled(sensorContext);
            LOGGER.trace("Caching is enabled: {}", (Object)isCachingEnabled);
            if (!isCachingEnabled) {
                return CacheContextImpl.dummyCache();
            }
            return CacheContextImpl.fromSensorContext(sensorContext);
        }
        catch (NoSuchMethodError error) {
            LOGGER.debug("Missing cache related method from sonar-plugin-api: {}.", (Object)error.getMessage());
            return CacheContextImpl.dummyCache();
        }
    }

    private static CacheContextImpl dummyCache() {
        DummyCache dummyCache = new DummyCache();
        return new CacheContextImpl(false, dummyCache, dummyCache);
    }

    private static CacheContextImpl fromSensorContext(SensorContext context) {
        return new CacheContextImpl(true, new JavaReadCacheImpl(context.previousCache()), new JavaWriteCacheImpl(context.nextCache()));
    }

    private static CacheContextImpl fromSonarLintCache(SonarLintCache sonarLintCache) {
        return new CacheContextImpl(false, new JavaReadCacheImpl(sonarLintCache), new JavaWriteCacheImpl(sonarLintCache));
    }

    private static boolean isCachingEnabled(SensorContext context) {
        return Optional.ofNullable(context.config()).flatMap(config -> config.getBoolean(SONAR_CACHING_ENABLED_KEY)).map(flag -> {
            LOGGER.debug("Forcing caching behavior. Caching will be enabled: {}", flag);
            return flag;
        }).orElse(context.isCacheEnabled());
    }

    @Override
    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    @Override
    public JavaReadCache getReadCache() {
        return this.readCache;
    }

    @Override
    public JavaWriteCache getWriteCache() {
        return this.writeCache;
    }
}

