/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.classpath;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.java.classpath.VersionImpl;
import org.sonar.plugins.java.api.Version;

public class DependencyVersionInference {
    private final Map<String, Optional<Version>> dependencyVersionsCache = new HashMap<String, Optional<Version>>();

    static Pattern makeJarPattern(String artifactId) {
        return Pattern.compile(artifactId + "-" + VersionImpl.VERSION_REGEX + "\\.jar");
    }

    public Optional<Version> infer(String artifactId, List<File> classpath) {
        return this.dependencyVersionsCache.computeIfAbsent(artifactId, key -> DependencyVersionInference.infer(DependencyVersionInference.makeJarPattern(key), classpath));
    }

    private static Optional<Version> infer(Pattern jarPattern, List<File> classpath) {
        for (File file : classpath) {
            Matcher matcher = jarPattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            return Optional.of(VersionImpl.matcherToVersion(matcher));
        }
        return Optional.empty();
    }
}

