/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.java.model.JSymbolMetadata;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class JSymbolMetadataNullabilityHelper {
    private static final Set<String> STRONG_NULLABLE_ANNOTATIONS = SetUtils.immutableSetOf((Object[])new String[]{"javax.annotation.CheckForNull", "jakarta.annotation.CheckForNull", "edu.umd.cs.findbugs.annotations.CheckForNull", "org.netbeans.api.annotations.common.CheckForNull", "org.springframework.lang.Nullable", "reactor.util.annotation.Nullable", "org.eclipse.jdt.annotation.Nullable", "org.eclipse.jgit.annotations.Nullable", "org.jspecify.annotations.Nullable"});
    private static final Set<String> WEAK_NULLABLE_ANNOTATIONS = SetUtils.immutableSetOf((Object[])new String[]{"android.annotation.Nullable", "android.support.annotation.Nullable", "androidx.annotation.Nullable", "com.sun.istack.internal.Nullable", "com.mongodb.lang.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "io.reactivex.annotations.Nullable", "io.reactivex.rxjava3.annotations.Nullable", "javax.annotation.Nullable", "jakarta.annotation.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType", "org.checkerframework.checker.nullness.qual.Nullable", "org.jetbrains.annotations.Nullable", "org.jmlspecs.annotation.Nullable", "org.netbeans.api.annotations.common.NullAllowed", "org.netbeans.api.annotations.common.NullUnknown"});
    private static final Set<String> NULLABLE_ANNOTATIONS = Collections.unmodifiableSet(Stream.of(STRONG_NULLABLE_ANNOTATIONS, WEAK_NULLABLE_ANNOTATIONS).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final Set<String> NONNULL_ANNOTATIONS = SetUtils.immutableSetOf((Object[])new String[]{"android.annotation.NonNull", "android.support.annotation.NonNull", "androidx.annotation.NonNull", "com.sun.istack.internal.NotNull", "com.mongodb.lang.NonNull", "edu.umd.cs.findbugs.annotations.NonNull", "io.reactivex.annotations.NonNull", "io.reactivex.rxjava3.annotations.NonNull", "javax.validation.constraints.NotNull", "jakarta.validation.constraints.NotNull", "lombok.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType", "org.checkerframework.checker.nullness.qual.NonNull", "org.eclipse.jdt.annotation.NonNull", "org.eclipse.jgit.annotations.NonNull", "org.jetbrains.annotations.NotNull", "org.jmlspecs.annotation.NonNull", "org.netbeans.api.annotations.common.NonNull", "org.springframework.lang.NonNull", "reactor.util.annotation.NonNull", "org.jspecify.annotations.NonNull"});
    private static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    private static final String JAKARTA_ANNOTATION_NONNULL = "jakarta.annotation.Nonnull";
    private static final String ORG_JSPECIFY_ANNOTATIONS_NULL_MARKED = "org.jspecify.annotations.NullMarked";
    private static final String ORG_JSPECIFY_ANNOTATIONS_NULL_UNMARKED = "org.jspecify.annotations.NullUnmarked";
    private static final String COM_MONGO_DB_LANG_NON_NULL_API = "com.mongodb.lang.NonNullApi";
    private static final String ORG_SPRINGFRAMEWORK_LANG_NON_NULL_API = "org.springframework.lang.NonNullApi";
    private static final String JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT = "javax.annotation.ParametersAreNonnullByDefault";
    private static final String JAKARTA_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT = "jakarta.annotation.ParametersAreNonnullByDefault";
    private static final String JAVAX_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT = "javax.annotation.ParametersAreNullableByDefault";
    private static final String JAKARTA_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT = "jakarta.annotation.ParametersAreNullableByDefault";
    private static final String ORG_SPRINGFRAMEWORK_LANG_NON_NULL_FIELDS = "org.springframework.lang.NonNullFields";
    private static final String ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT = "org.eclipse.jdt.annotation.NonNullByDefault";
    private static final Set<String> KNOWN_ANNOTATIONS = Stream.of(NULLABLE_ANNOTATIONS, NONNULL_ANNOTATIONS).flatMap(Collection::stream).collect(Collectors.toSet());
    private static final Map<ConfigurationKey, TypesForAnnotations> configuration = new HashMap<ConfigurationKey, TypesForAnnotations>();

    private JSymbolMetadataNullabilityHelper() {
    }

    private static void configureAnnotation(String name, SymbolMetadata.NullabilityType type, List<SymbolMetadata.NullabilityTarget> targets, List<SymbolMetadata.NullabilityLevel> levels) {
        JSymbolMetadataNullabilityHelper.configureAnnotation(annotation -> JSymbolMetadataNullabilityHelper.annotationType(annotation).fullyQualifiedName().equals(name) ? type : SymbolMetadata.NullabilityType.NO_ANNOTATION, targets, levels);
    }

    private static void configureAnnotation(Function<SymbolMetadata.AnnotationInstance, SymbolMetadata.NullabilityType> typeFromAnnotation, List<SymbolMetadata.NullabilityTarget> targets, List<SymbolMetadata.NullabilityLevel> levels) {
        for (SymbolMetadata.NullabilityTarget target : targets) {
            for (SymbolMetadata.NullabilityLevel level : levels) {
                ConfigurationKey key = new ConfigurationKey(target, level);
                configuration.computeIfAbsent(key, k -> new TypesForAnnotations()).add(typeFromAnnotation);
            }
        }
    }

    public static SymbolMetadata.NullabilityData getNullabilityDataAtLevel(SymbolMetadata metadata, SymbolMetadata.NullabilityTarget target, SymbolMetadata.NullabilityLevel level) {
        TypesForAnnotations typeForAnnotations = configuration.get(new ConfigurationKey(target, level));
        if (typeForAnnotations != null) {
            return JSymbolMetadataNullabilityHelper.getNullabilityDataAtLevel(new HashSet<Type>(), metadata, level, false, typeForAnnotations);
        }
        return JSymbolMetadata.noNullabilityAnnotationAt(level);
    }

    private static SymbolMetadata.NullabilityData getNullabilityDataAtLevel(Set<Type> knownTypes, SymbolMetadata metadata, SymbolMetadata.NullabilityLevel level, boolean isMetaAnnotated, TypesForAnnotations typeForAnnotations) {
        SymbolMetadata.NullabilityData directlyAnnotated = JSymbolMetadataNullabilityHelper.getNullabilityData(metadata, level, isMetaAnnotated, typeForAnnotations);
        if (directlyAnnotated.type() != SymbolMetadata.NullabilityType.NO_ANNOTATION) {
            return directlyAnnotated;
        }
        for (SymbolMetadata.AnnotationInstance annotationInstance : metadata.annotations()) {
            SymbolMetadata.NullabilityData nullabilityData;
            Symbol annotationSymbol = annotationInstance.symbol();
            Type annotationType = annotationSymbol.type();
            if (!knownTypes.add(annotationType) || KNOWN_ANNOTATIONS.contains(JSymbolMetadataNullabilityHelper.annotationType(annotationInstance).fullyQualifiedName()) || (nullabilityData = JSymbolMetadataNullabilityHelper.getNullabilityDataAtLevel(knownTypes, annotationSymbol.metadata(), level, true, typeForAnnotations)).type() == SymbolMetadata.NullabilityType.NO_ANNOTATION) continue;
            return nullabilityData;
        }
        return JSymbolMetadata.noNullabilityAnnotationAt(level);
    }

    private static SymbolMetadata.NullabilityData getNullabilityData(SymbolMetadata metadata, SymbolMetadata.NullabilityLevel level, boolean isMetaAnnotated, TypesForAnnotations typeForAnnotations) {
        SymbolMetadata.NullabilityType nullabilityType = SymbolMetadata.NullabilityType.NO_ANNOTATION;
        SymbolMetadata.AnnotationInstance annotationInstance = null;
        for (SymbolMetadata.AnnotationInstance annotation : metadata.annotations()) {
            SymbolMetadata.NullabilityType typeFromAnnotation = typeForAnnotations.getTypeFromAnnotation(annotation);
            if (typeFromAnnotation.ordinal() <= nullabilityType.ordinal()) continue;
            nullabilityType = typeFromAnnotation;
            annotationInstance = annotation;
        }
        if (nullabilityType == SymbolMetadata.NullabilityType.UNKNOWN) {
            return JSymbolMetadata.unknownNullabilityAt(level);
        }
        if (annotationInstance == null) {
            return JSymbolMetadata.noNullabilityAnnotationAt(level);
        }
        return new JSymbolMetadata.JNullabilityData(nullabilityType, level, annotationInstance, metadata.findAnnotationTree(annotationInstance), isMetaAnnotated);
    }

    private static SymbolMetadata.NullabilityType getIfStrongNullable(SymbolMetadata.AnnotationInstance annotation) {
        if (JSymbolMetadataNullabilityHelper.isStrongNullableAnnotation(JSymbolMetadataNullabilityHelper.annotationType(annotation))) {
            return SymbolMetadata.NullabilityType.STRONG_NULLABLE;
        }
        return SymbolMetadata.NullabilityType.NO_ANNOTATION;
    }

    private static boolean isStrongNullableAnnotation(Type type) {
        return STRONG_NULLABLE_ANNOTATIONS.contains(type.fullyQualifiedName());
    }

    private static SymbolMetadata.NullabilityType getIfNullable(SymbolMetadata.AnnotationInstance annotation) {
        if (JSymbolMetadataNullabilityHelper.isNullableAnnotation(JSymbolMetadataNullabilityHelper.annotationType(annotation))) {
            return SymbolMetadata.NullabilityType.WEAK_NULLABLE;
        }
        return SymbolMetadata.NullabilityType.NO_ANNOTATION;
    }

    private static boolean isNullableAnnotation(Type type) {
        return NULLABLE_ANNOTATIONS.contains(type.fullyQualifiedName());
    }

    private static SymbolMetadata.NullabilityType getIfNonNull(SymbolMetadata.AnnotationInstance annotation) {
        if (JSymbolMetadataNullabilityHelper.isNonNullAnnotation(JSymbolMetadataNullabilityHelper.annotationType(annotation))) {
            return annotation.values().isEmpty() ? SymbolMetadata.NullabilityType.NON_NULL : SymbolMetadata.NullabilityType.UNKNOWN;
        }
        return SymbolMetadata.NullabilityType.NO_ANNOTATION;
    }

    private static boolean isNonNullAnnotation(Type type) {
        return NONNULL_ANNOTATIONS.contains(type.fullyQualifiedName());
    }

    private static SymbolMetadata.NullabilityType getTypeFromNonNull(SymbolMetadata.AnnotationInstance annotation) {
        if (JAVAX_ANNOTATION_NONNULL.equals(JSymbolMetadataNullabilityHelper.annotationType(annotation).fullyQualifiedName()) || JAKARTA_ANNOTATION_NONNULL.equals(JSymbolMetadataNullabilityHelper.annotationType(annotation).fullyQualifiedName())) {
            List<SymbolMetadata.AnnotationValue> values = annotation.values();
            if (values.isEmpty() || JSymbolMetadataNullabilityHelper.checkAnnotationParameter(values, "when", "ALWAYS")) {
                return SymbolMetadata.NullabilityType.NON_NULL;
            }
            if (JSymbolMetadataNullabilityHelper.checkAnnotationParameter(values, "when", "UNKNOWN")) {
                return SymbolMetadata.NullabilityType.WEAK_NULLABLE;
            }
            return SymbolMetadata.NullabilityType.STRONG_NULLABLE;
        }
        return SymbolMetadata.NullabilityType.NO_ANNOTATION;
    }

    private static SymbolMetadata.NullabilityType getIfEclipseNonNullByDefault(SymbolMetadata.AnnotationInstance annotation, String expectedValue) {
        if (ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT.equals(JSymbolMetadataNullabilityHelper.annotationType(annotation).fullyQualifiedName())) {
            return annotation.values().isEmpty() || JSymbolMetadataNullabilityHelper.checkAnnotationParameter(annotation.values(), "value", expectedValue) ? SymbolMetadata.NullabilityType.NON_NULL : SymbolMetadata.NullabilityType.NO_ANNOTATION;
        }
        return SymbolMetadata.NullabilityType.NO_ANNOTATION;
    }

    private static Type annotationType(SymbolMetadata.AnnotationInstance annotation) {
        return annotation.symbol().type();
    }

    private static boolean checkAnnotationParameter(List<SymbolMetadata.AnnotationValue> valuesForAnnotation, String fieldName, String expectedValue) {
        return valuesForAnnotation.stream().filter(annotationValue -> fieldName.equals(annotationValue.name())).anyMatch(annotationValue -> JSymbolMetadataNullabilityHelper.isExpectedValue(annotationValue.value(), expectedValue));
    }

    private static boolean isExpectedValue(Object annotationValue, String expectedValue) {
        Symbol symbol;
        if (annotationValue instanceof Object[]) {
            Object[] objects = (Object[])annotationValue;
            return JSymbolMetadataNullabilityHelper.containsValue(objects, expectedValue);
        }
        return annotationValue instanceof Symbol && expectedValue.equals((symbol = (Symbol)annotationValue).name());
    }

    private static boolean containsValue(Object[] annotationValue, String expectedValue) {
        return Arrays.stream(annotationValue).map(Symbol.class::cast).anyMatch(symbol -> expectedValue.equals(symbol.name()));
    }

    static {
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfStrongNullable, Arrays.asList(SymbolMetadata.NullabilityTarget.PARAMETER, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.LOCAL_VARIABLE), Collections.singletonList(SymbolMetadata.NullabilityLevel.VARIABLE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfStrongNullable, Collections.singletonList(SymbolMetadata.NullabilityTarget.METHOD), Collections.singletonList(SymbolMetadata.NullabilityLevel.METHOD));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfNullable, Arrays.asList(SymbolMetadata.NullabilityTarget.PARAMETER, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.LOCAL_VARIABLE), Collections.singletonList(SymbolMetadata.NullabilityLevel.VARIABLE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfNullable, Collections.singletonList(SymbolMetadata.NullabilityTarget.METHOD), Collections.singletonList(SymbolMetadata.NullabilityLevel.METHOD));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfNonNull, Arrays.asList(SymbolMetadata.NullabilityTarget.PARAMETER, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.LOCAL_VARIABLE), Collections.singletonList(SymbolMetadata.NullabilityLevel.VARIABLE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getIfNonNull, Collections.singletonList(SymbolMetadata.NullabilityTarget.METHOD), Collections.singletonList(SymbolMetadata.NullabilityLevel.METHOD));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getTypeFromNonNull, Arrays.asList(SymbolMetadata.NullabilityTarget.PARAMETER, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.LOCAL_VARIABLE), Collections.singletonList(SymbolMetadata.NullabilityLevel.VARIABLE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JSymbolMetadataNullabilityHelper::getTypeFromNonNull, Collections.singletonList(SymbolMetadata.NullabilityTarget.METHOD), Collections.singletonList(SymbolMetadata.NullabilityLevel.METHOD));
        JSymbolMetadataNullabilityHelper.configureAnnotation(COM_MONGO_DB_LANG_NON_NULL_API, SymbolMetadata.NullabilityType.NON_NULL, Arrays.asList(SymbolMetadata.NullabilityTarget.METHOD, SymbolMetadata.NullabilityTarget.PARAMETER), Collections.singletonList(SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(ORG_SPRINGFRAMEWORK_LANG_NON_NULL_API, SymbolMetadata.NullabilityType.NON_NULL, Arrays.asList(SymbolMetadata.NullabilityTarget.METHOD, SymbolMetadata.NullabilityTarget.PARAMETER), Collections.singletonList(SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(ORG_JSPECIFY_ANNOTATIONS_NULL_MARKED, SymbolMetadata.NullabilityType.NON_NULL, Arrays.asList(SymbolMetadata.NullabilityTarget.CLASS, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.METHOD, SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(ORG_JSPECIFY_ANNOTATIONS_NULL_UNMARKED, SymbolMetadata.NullabilityType.WEAK_NULLABLE, Arrays.asList(SymbolMetadata.NullabilityTarget.CLASS, SymbolMetadata.NullabilityTarget.FIELD, SymbolMetadata.NullabilityTarget.METHOD, SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT, SymbolMetadata.NullabilityType.NON_NULL, Collections.singletonList(SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JAVAX_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT, SymbolMetadata.NullabilityType.WEAK_NULLABLE, Collections.singletonList(SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JAKARTA_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT, SymbolMetadata.NullabilityType.NON_NULL, Collections.singletonList(SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(JAKARTA_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT, SymbolMetadata.NullabilityType.WEAK_NULLABLE, Collections.singletonList(SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(ORG_SPRINGFRAMEWORK_LANG_NON_NULL_FIELDS, SymbolMetadata.NullabilityType.NON_NULL, Collections.singletonList(SymbolMetadata.NullabilityTarget.FIELD), Collections.singletonList(SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(annotationInstance -> JSymbolMetadataNullabilityHelper.getIfEclipseNonNullByDefault(annotationInstance, "PARAMETER"), Collections.singletonList(SymbolMetadata.NullabilityTarget.PARAMETER), Arrays.asList(SymbolMetadata.NullabilityLevel.VARIABLE, SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(annotationInstance -> JSymbolMetadataNullabilityHelper.getIfEclipseNonNullByDefault(annotationInstance, "FIELD"), Collections.singletonList(SymbolMetadata.NullabilityTarget.FIELD), Arrays.asList(SymbolMetadata.NullabilityLevel.VARIABLE, SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        JSymbolMetadataNullabilityHelper.configureAnnotation(annotationInstance -> JSymbolMetadataNullabilityHelper.getIfEclipseNonNullByDefault(annotationInstance, "RETURN_TYPE"), Collections.singletonList(SymbolMetadata.NullabilityTarget.METHOD), Arrays.asList(SymbolMetadata.NullabilityLevel.METHOD, SymbolMetadata.NullabilityLevel.CLASS, SymbolMetadata.NullabilityLevel.PACKAGE));
        KNOWN_ANNOTATIONS.add(JAVAX_ANNOTATION_NONNULL);
        KNOWN_ANNOTATIONS.add(JAKARTA_ANNOTATION_NONNULL);
        KNOWN_ANNOTATIONS.add(COM_MONGO_DB_LANG_NON_NULL_API);
        KNOWN_ANNOTATIONS.add(ORG_SPRINGFRAMEWORK_LANG_NON_NULL_API);
        KNOWN_ANNOTATIONS.add(JAVAX_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT);
        KNOWN_ANNOTATIONS.add(JAKARTA_ANNOTATION_PARAMETERS_ARE_NONNULL_BY_DEFAULT);
        KNOWN_ANNOTATIONS.add(JAVAX_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
        KNOWN_ANNOTATIONS.add(JAKARTA_ANNOTATION_PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
        KNOWN_ANNOTATIONS.add(ORG_SPRINGFRAMEWORK_LANG_NON_NULL_FIELDS);
        KNOWN_ANNOTATIONS.add(ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL_BY_DEFAULT);
        KNOWN_ANNOTATIONS.add(ORG_JSPECIFY_ANNOTATIONS_NULL_MARKED);
        KNOWN_ANNOTATIONS.add(ORG_JSPECIFY_ANNOTATIONS_NULL_UNMARKED);
    }

    private static class ConfigurationKey {
        private final SymbolMetadata.NullabilityTarget target;
        private final SymbolMetadata.NullabilityLevel level;

        ConfigurationKey(SymbolMetadata.NullabilityTarget target, SymbolMetadata.NullabilityLevel level) {
            this.target = target;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationKey that = (ConfigurationKey)o;
            if (this.target != that.target) {
                return false;
            }
            return this.level == that.level;
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.level.hashCode();
            return result;
        }
    }

    private static class TypesForAnnotations
    extends ArrayList<Function<SymbolMetadata.AnnotationInstance, SymbolMetadata.NullabilityType>> {
        private TypesForAnnotations() {
        }

        private SymbolMetadata.NullabilityType getTypeFromAnnotation(SymbolMetadata.AnnotationInstance annotation) {
            if (annotation.symbol().isUnknown()) {
                return SymbolMetadata.NullabilityType.UNKNOWN;
            }
            for (Function typeForAnnotation : this) {
                SymbolMetadata.NullabilityType type = (SymbolMetadata.NullabilityType)((Object)typeForAnnotation.apply(annotation));
                if (type == SymbolMetadata.NullabilityType.NO_ANNOTATION) continue;
                return type;
            }
            return SymbolMetadata.NullabilityType.NO_ANNOTATION;
        }
    }
}

