/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.sonar.java.model.JMethodSymbol;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbolMetadata;
import org.sonar.java.model.JType;
import org.sonar.java.model.JTypeSymbol;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

abstract class JSymbol
implements Symbol {
    protected final JSema sema;
    protected final IBinding binding;
    private int hashCode;
    private Symbol owner;
    private SymbolMetadata metadata;

    JSymbol(JSema sema, IBinding binding) {
        this.sema = Objects.requireNonNull(sema);
        this.binding = Objects.requireNonNull(binding);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JSymbol)) {
            return false;
        }
        JSymbol other = (JSymbol)obj;
        if (this.binding.getKind() != other.binding.getKind()) {
            return false;
        }
        switch (this.binding.getKind()) {
            case 2: {
                return JType.areEqual((ITypeBinding)this.binding, (ITypeBinding)other.binding);
            }
            case 3: {
                return JSymbol.areEqualVariables(this, other);
            }
            case 4: {
                return JSymbol.areEqualMethodSymbols((JMethodSymbol)this, (JMethodSymbol)other);
            }
        }
        return super.equals(obj);
    }

    private static boolean areEqualVariables(JSymbol thisVariableSymbol, JSymbol otherVariableSymbol) {
        IVariableBinding thisBinding = (IVariableBinding)thisVariableSymbol.binding;
        IVariableBinding otherBinding = (IVariableBinding)otherVariableSymbol.binding;
        return thisBinding.getVariableId() == otherBinding.getVariableId() && thisVariableSymbol.owner().equals(otherVariableSymbol.owner());
    }

    private static boolean areEqualMethodSymbols(JMethodSymbol thisMethodSymbol, JMethodSymbol otherMethodSymbol) {
        IMethodBinding thisBinding = (IMethodBinding)thisMethodSymbol.binding;
        IMethodBinding otherBinding = (IMethodBinding)otherMethodSymbol.binding;
        if (thisMethodSymbol.isLambda() && otherMethodSymbol.isLambda()) {
            return Objects.equals(thisBinding.getKey(), otherBinding.getKey());
        }
        return thisMethodSymbol.name().equals(otherMethodSymbol.name()) && thisMethodSymbol.owner().equals(otherMethodSymbol.owner()) && Arrays.equals(thisBinding.getParameterTypes(), otherBinding.getParameterTypes()) && Arrays.equals(thisBinding.getTypeParameters(), otherBinding.getTypeParameters()) && Arrays.equals(thisBinding.getTypeArguments(), otherBinding.getTypeArguments());
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            Symbol resolvedOwner = this.owner();
            this.hashCode = resolvedOwner == null ? 0 : resolvedOwner.hashCode() * 31;
            this.hashCode += this.name().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public final String name() {
        if (this.binding.getKind() == 4 && ((IMethodBinding)this.binding).isConstructor()) {
            return "<init>";
        }
        if (this.binding.getKind() == 2 && ((ITypeBinding)this.binding).isParameterizedType()) {
            return ((ITypeBinding)this.binding).getErasure().getName();
        }
        return this.binding.getName();
    }

    @Override
    public final Symbol owner() {
        if (this.isUnknown()) {
            return Symbols.unknownSymbol;
        }
        if (this.owner == null) {
            this.owner = this.convertOwner();
        }
        return this.owner;
    }

    private Symbol convertOwner() {
        switch (this.binding.getKind()) {
            case 1: {
                return Symbols.rootPackage;
            }
            case 2: {
                return this.typeOwner((ITypeBinding)this.binding);
            }
            case 4: {
                return this.methodOwner((IMethodBinding)this.binding);
            }
            case 3: {
                return this.variableOwner((IVariableBinding)this.binding);
            }
        }
        throw new IllegalStateException(this.unexpectedBinding());
    }

    private String unexpectedBinding() {
        return "Unexpected binding Kind: " + this.binding.getKind();
    }

    private Symbol typeOwner(ITypeBinding typeBinding) {
        if (typeBinding.isPrimitive()) {
            return Symbols.rootPackage;
        }
        IMethodBinding declaringMethod = typeBinding.getDeclaringMethod();
        if (declaringMethod != null) {
            return this.sema.methodSymbol(declaringMethod);
        }
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        if (declaringClass != null) {
            return this.sema.typeSymbol(declaringClass);
        }
        return this.sema.packageSymbol(typeBinding.getPackage());
    }

    private Symbol methodOwner(IMethodBinding methodBinding) {
        return this.sema.typeSymbol(methodBinding.getDeclaringClass());
    }

    private Symbol variableOwner(IVariableBinding variableBinding) {
        if (!variableBinding.isRecordComponent()) {
            IMethodBinding declaringMethod = variableBinding.getDeclaringMethod();
            if (declaringMethod != null) {
                return this.sema.methodSymbol(declaringMethod);
            }
            ITypeBinding declaringClass = variableBinding.getDeclaringClass();
            if (declaringClass != null) {
                return this.sema.typeSymbol(declaringClass);
            }
        }
        return this.ownerOfRecordComponentConstant(variableBinding);
    }

    private Symbol ownerOfRecordComponentConstant(IVariableBinding variableBinding) {
        Tree node = this.sema.declarations.get(variableBinding);
        if (node == null) {
            return Symbols.unknownSymbol;
        }
        boolean initializerBlock = false;
        boolean staticInitializerBlock = false;
        block6: while (true) {
            node = node.parent();
            switch (node.kind()) {
                case CLASS: 
                case RECORD: 
                case ENUM: {
                    JTypeSymbol typeSymbol = this.sema.typeSymbol(((ClassTreeImpl)node).typeBinding);
                    if (initializerBlock) {
                        return this.sema.initializerBlockSymbol(typeSymbol);
                    }
                    if (staticInitializerBlock) {
                        return this.sema.staticInitializerBlockSymbol(typeSymbol);
                    }
                    return typeSymbol;
                }
                case INITIALIZER: {
                    initializerBlock = true;
                    continue block6;
                }
                case STATIC_INITIALIZER: {
                    staticInitializerBlock = true;
                    continue block6;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    return Symbols.unknownMethodSymbol;
                }
            }
        }
    }

    @Override
    public final Type type() {
        switch (this.binding.getKind()) {
            case 2: {
                return this.sema.type((ITypeBinding)this.binding);
            }
            case 3: {
                ITypeBinding variableType = ((IVariableBinding)this.binding).getType();
                return variableType != null ? this.sema.type(variableType) : Symbols.unknownType;
            }
            case 1: 
            case 4: {
                return Symbols.unknownType;
            }
        }
        throw new IllegalStateException(this.unexpectedBinding());
    }

    @Override
    public final boolean isVariableSymbol() {
        return this.binding.getKind() == 3;
    }

    @Override
    public final boolean isTypeSymbol() {
        return !this.isUnknown() && this.binding.getKind() == 2;
    }

    @Override
    public final boolean isMethodSymbol() {
        return this.binding.getKind() == 4;
    }

    @Override
    public final boolean isPackageSymbol() {
        return this.binding.getKind() == 1;
    }

    @Override
    public final boolean isStatic() {
        return Modifier.isStatic((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isEnum() {
        switch (this.binding.getKind()) {
            case 2: {
                return ((ITypeBinding)this.binding).isEnum();
            }
            case 3: {
                return ((IVariableBinding)this.binding).isEnumConstant();
            }
        }
        return false;
    }

    @Override
    public final boolean isInterface() {
        return this.binding.getKind() == 2 && ((ITypeBinding)this.binding).isInterface();
    }

    @Override
    public final boolean isAbstract() {
        return Modifier.isAbstract((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isPublic() {
        return Modifier.isPublic((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isPrivate() {
        return Modifier.isPrivate((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isProtected() {
        return Modifier.isProtected((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isPackageVisibility() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public final boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    @Override
    public final boolean isVolatile() {
        return Modifier.isVolatile((int)this.binding.getModifiers());
    }

    @Override
    public final boolean isUnknown() {
        return this.binding.isRecovered();
    }

    @Override
    public final SymbolMetadata metadata() {
        if (this.metadata == null) {
            try {
                this.metadata = this.convertMetadata();
            }
            catch (RuntimeException e) {
                this.metadata = Symbols.EMPTY_METADATA;
            }
        }
        return this.metadata;
    }

    private SymbolMetadata convertMetadata() {
        switch (this.binding.getKind()) {
            case 1: {
                return new JSymbolMetadata(this.sema, this, this.sema.resolvePackageAnnotations(this.binding.getName()));
            }
            case 3: {
                ITypeBinding type = ((IVariableBinding)this.binding).getType();
                return new JSymbolMetadata(this.sema, this, type == null ? new IAnnotationBinding[]{} : JSymbol.getAnnotations(type), this.binding.getAnnotations());
            }
            case 4: {
                ITypeBinding returnType = ((IMethodBinding)this.binding).getReturnType();
                if (returnType == null) {
                    return Symbols.EMPTY_METADATA;
                }
                return new JSymbolMetadata(this.sema, this, JSymbol.getAnnotations(returnType), this.binding.getAnnotations());
            }
        }
        return new JSymbolMetadata(this.sema, this, this.binding.getAnnotations());
    }

    private static IAnnotationBinding[] getAnnotations(ITypeBinding type) {
        ArrayList iAnnotationBindings = new ArrayList();
        for (ITypeBinding typeArgument : type.getTypeArguments()) {
            Collections.addAll(iAnnotationBindings, typeArgument.getTypeAnnotations());
        }
        Collections.addAll(iAnnotationBindings, type.getTypeAnnotations());
        return iAnnotationBindings.toArray(new IAnnotationBinding[0]);
    }

    @Override
    @Nullable
    public final Symbol.TypeSymbol enclosingClass() {
        switch (this.binding.getKind()) {
            case 1: {
                return null;
            }
            case 2: {
                return this.typeEnclosingClass((ITypeBinding)this.binding);
            }
            case 4: {
                return this.methodEnclosingClass((IMethodBinding)this.binding);
            }
            case 3: {
                return this.variableEnclosingClass((IVariableBinding)this.binding);
            }
        }
        throw new IllegalStateException(this.unexpectedBinding());
    }

    private Symbol.TypeSymbol typeEnclosingClass(ITypeBinding typeBinding) {
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        if (declaringClass != null) {
            return this.sema.typeSymbol(declaringClass);
        }
        return (Symbol.TypeSymbol)((Object)this);
    }

    private Symbol.TypeSymbol methodEnclosingClass(IMethodBinding methodBinding) {
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        return this.sema.typeSymbol(declaringClass);
    }

    private Symbol.TypeSymbol variableEnclosingClass(IVariableBinding variableBinding) {
        ITypeBinding declaringClass = variableBinding.getDeclaringClass();
        if (declaringClass != null) {
            return this.sema.typeSymbol(declaringClass);
        }
        IMethodBinding declaringMethod = variableBinding.getDeclaringMethod();
        if (declaringMethod != null) {
            return this.sema.typeSymbol(declaringMethod.getDeclaringClass());
        }
        Tree node = this.sema.declarations.get(variableBinding);
        if (node == null) {
            return Symbols.unknownTypeSymbol;
        }
        while (true) {
            node = node.parent();
            switch (node.kind()) {
                case CLASS: 
                case RECORD: 
                case ENUM: {
                    return this.sema.typeSymbol(((ClassTreeImpl)node).typeBinding);
                }
            }
        }
    }

    @Override
    public final List<IdentifierTree> usages() {
        List<IdentifierTree> usages = this.sema.usages.get(JSema.declarationBinding(this.binding));
        return usages != null ? usages : Collections.emptyList();
    }

    @Override
    @Nullable
    public Tree declaration() {
        return this.sema.declarations.get(JSema.declarationBinding(this.binding));
    }
}

